package org.herac.tuxguitar.gui.printer;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.FileChooser;

public class PrintDialog {
	private Shell parent;
	private Shell dialog;
	private int style;
	private PrintService[] printServices;
	private PrinterData printerData;
	
	private Combo servicesCombo;
	private Label servicesStatus;
	private Label servicesType;
	private Label servicesInfo;
	private Button printToFile;
	private Text filePath;
	private Button fileChooser;
	private Spinner copiesSpinner;
	private Button allPages;
	private Button rangePages;
	private Text fromRangePage;
	private Text toRangePage;	
	
	public PrintDialog (Shell parent) {
		this (parent,SWT.DIALOG_TRIM |SWT.APPLICATION_MODAL);
	}
	
	public PrintDialog(Shell parent,int style){
		this.parent = parent;
		this.style = style;
		this.findServices();
	}
	
	public void findServices(){
		this.printServices = PrintServiceLookup.lookupPrintServices(null,null);
	}
	
	public PrinterData open(){
		this.dialog = new Shell(this.parent,this.style);
		this.dialog.setLayout(new FillLayout());
		this.dialog.setText(TuxGuitar.getProperty("print.dialog"));
		
		this.initComposites();
		
		this.dialog.pack();
		this.dialog.open();

		int x = parent.getBounds().x + (parent.getBounds().width - dialog.getSize().x) / 2;
		int y = parent.getBounds().y + (parent.getBounds().height - dialog.getSize().y) / 2;
		this.dialog.setLocation(x, y);		
		
		while (!dialog.isDisposed()) {
            if (!dialog.getDisplay().readAndDispatch()) {
            	dialog.getDisplay().sleep();
            }

        }		
		return this.printerData;		
	}
	
	private void initComposites(){
		Composite composite = new Composite(this.dialog,SWT.NONE);
		composite.setLayout(new GridLayout(1,true));
		
		//-------SERVICES--------------------------------------------------
		Composite servicesComposite = new Composite(composite,SWT.NONE);
		servicesComposite.setLayout(new GridLayout());
		servicesComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));		
		Group services = new Group(servicesComposite,SWT.NONE);
		services.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		services.setText(TuxGuitar.getProperty("print.service"));
		services.setLayout(new GridLayout(2,false));		
		Label serviceNameLabel = new Label(services,SWT.NONE);
		serviceNameLabel.setText(TuxGuitar.getProperty("print.service.name") + ":");
		this.servicesCombo = new Combo(services,SWT.DROP_DOWN | SWT.READ_ONLY);		
        for (int i = 0; i < this.printServices.length; i++) {
        	this.servicesCombo.add(this.printServices[i].getName());
        }
        this.servicesCombo.select(0);
        this.servicesCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				checkServiceValues();
			}		
		});
        
		Label serviceStatusLabel = new Label(services,SWT.NONE);
		serviceStatusLabel.setText(TuxGuitar.getProperty("print.service.status") + ":");		
		this.servicesStatus = new Label(services,SWT.NONE);
		this.servicesStatus.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		Label serviceTypeLabel = new Label(services,SWT.NONE);
		serviceTypeLabel.setText(TuxGuitar.getProperty("print.service.type") + ":");
		this.servicesType = new Label(services,SWT.NONE);
		this.servicesType.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		Label serviceInfoLabel = new Label(services,SWT.NONE);
		serviceInfoLabel.setText(TuxGuitar.getProperty("print.service.info") + ":");
		this.servicesInfo = new Label(services,SWT.NONE);
		this.servicesInfo.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
				
		//print to file
		//Composite fileComposite = new Composite(services,SWT.NONE);
		//fileComposite.setLayout(new GridLayout(3,false));
		//fileComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true,2,1));
				
		this.printToFile = new Button(services,SWT.CHECK);
		this.printToFile.setLayoutData(new GridData(SWT.BEGINNING,SWT.CENTER,true,true,2,1));
		this.printToFile.setText(TuxGuitar.getProperty("print.print-to-file"));
		this.printToFile.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				checkPrintToFileComposites();
			}		
		});
		
		this.filePath = new Text(services,SWT.BORDER);
		this.filePath.setLayoutData(new GridData(220,16));
		
        GridData chooserData = new GridData(SWT.LEFT,SWT.FILL,true,true);    
        chooserData.minimumWidth = 80;
        chooserData.minimumHeight = 25;   				
		
		this.fileChooser = new Button(services,SWT.PUSH);
		this.fileChooser.setLayoutData(chooserData);
		this.fileChooser.setText(TuxGuitar.getProperty("print.file-chooser"));
		this.fileChooser.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				 chooseFile();
			}		
		});
		this.checkPrintToFileComposites();
		this.checkServiceValues();
        //-------DOCUMENT INFO---------------------------------------------
		Composite docInfo = new Composite(composite,SWT.NONE);
		docInfo.setLayout(new GridLayout(2,false));
		docInfo.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		//range--------------------------------------------------
		Group range = new Group(docInfo, SWT.SHADOW_ETCHED_IN);
		range.setLayout(new GridLayout(4,false));
		range.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		range.setText(TuxGuitar.getProperty("print.range"));

		this.allPages = new Button(range,SWT.RADIO);
		this.allPages.setText(TuxGuitar.getProperty("print.range.all-pages"));
		this.allPages.setLayoutData(new GridData(SWT.NONE,SWT.NONE,false,false,4,1));
		this.allPages.setSelection(true);	
		this.allPages.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				checkRangeComposites();
			}		
		});
		
		this.rangePages = new Button(range,SWT.RADIO);
		this.rangePages.setText(TuxGuitar.getProperty("print.range.pages"));
		this.rangePages.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				checkRangeComposites();
			}		
		});
		
		this.fromRangePage = new Text(range,SWT.BORDER);
		this.fromRangePage.setLayoutData(new GridData(25,15));
		
		Label rangeToLabel = new Label(range,SWT.NONE);
		rangeToLabel.setText(TuxGuitar.getProperty("print.range.pages-to"));
		
		this.toRangePage = new Text(range,SWT.BORDER);		
		this.toRangePage.setLayoutData(new GridData(25,15));
		
		this.checkRangeComposites();
		//copies--------------------------------------------------------------
		Group copies = new Group(docInfo, SWT.SHADOW_ETCHED_IN);
		copies.setLayout(new GridLayout(2,false));
		copies.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		copies.setText(TuxGuitar.getProperty("print.copies"));
		
		Label copiesLabel = new Label(copies,SWT.NONE);
		copiesLabel.setLayoutData(new GridData(SWT.NONE,SWT.CENTER,true,true));
		copiesLabel.setText(TuxGuitar.getProperty("print.copies-number"));
		this.copiesSpinner = new Spinner(copies,SWT.BORDER);
		this.copiesSpinner.setLayoutData(new GridData(SWT.NONE,SWT.CENTER,true,true));
		this.copiesSpinner.setMaximum(100);
		this.copiesSpinner.setMinimum(1);
		//-------BUTTONS---------------------------------------------------
        Composite buttons = new Composite(composite, SWT.NONE);
        buttons.setLayout(new GridLayout(2,false));
        buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;   
        
		Button buttonOk = new Button(buttons, SWT.PUSH);
		buttonOk.setLayoutData(data);
		buttonOk.setText(TuxGuitar.getProperty("print.print"));
		buttonOk.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				updatePrinterData();
				dialog.dispose();
			}
		});
		Button buttonCancel = new Button(buttons, SWT.PUSH);
		buttonCancel.setLayoutData(data);
		buttonCancel.setText(TuxGuitar.getProperty("cancel"));
		buttonCancel.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				dialog.dispose();
			}
		});
	}
	

	private void checkServiceValues(){
		String status = new String();
		String type = new String();
		String info = new String();		
		int serviceSelection = servicesCombo.getSelectionIndex();
		if(serviceSelection >= 0){
			PrintService printService = this.printServices[serviceSelection];			
			PrintServiceAttribute statusAtt = printService.getAttribute(PrinterIsAcceptingJobs.class);
			PrintServiceAttribute typeAtt = printService.getAttribute(PrinterMakeAndModel.class);
			PrintServiceAttribute infoAtt = printService.getAttribute(PrinterInfo.class);			
			status = (statusAtt == null)?"":statusAtt.toString();
			type = (typeAtt == null)?"":typeAtt.toString();
			info = (infoAtt == null)?"":infoAtt.toString();
		}		
		this.servicesStatus.setText(status);
		this.servicesType.setText(type);
		this.servicesInfo.setText(info);
	}
	
	private void checkRangeComposites(){
		boolean rangePagesSelected = this.rangePages.getSelection();		
		this.fromRangePage.setEnabled(rangePagesSelected);
		this.toRangePage.setEnabled(rangePagesSelected);
	}

	
	private void checkPrintToFileComposites(){
		boolean selected = this.printToFile.getSelection();		
		this.filePath.setEnabled(selected);
		this.fileChooser.setEnabled(selected);
	}
	
	private void chooseFile(){
        String fileName = FileChooser.instance().open(dialog,FileChooser.ALL_FORMAT/*,null*/);
        if(fileName != null){
        	this.filePath.setText(fileName);
        }
	}
	
	private void updatePrinterData(){
		this.printerData = new PrinterData();
		int serviceSelection = servicesCombo.getSelectionIndex();
		if(serviceSelection >= 0){
			printerData.name = this.printServices[serviceSelection].getName();
		}
		printerData.copyCount = this.copiesSpinner.getSelection();
		printerData.printToFile = this.printToFile.getSelection();
		printerData.fileName = this.filePath.getText();
		printerData.scope = PrinterData.ALL_PAGES;
		if(!this.allPages.getSelection()){
			try{
				int startPage = Integer.parseInt(this.fromRangePage.getText());
				int endPage = Integer.parseInt(this.toRangePage.getText());			
				printerData.startPage = startPage;
				printerData.endPage = endPage;
				printerData.scope = PrinterData.PAGE_RANGE;
			}catch(NumberFormatException e){				
			}
		}
	}
}
