package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;

public class LanguageOption extends Option{
    private Button[] languages;
    
    
    public LanguageOption(ConfigEditor configEditor,ToolBar toolBar,final Composite parent){
        super(configEditor,toolBar,parent,TuxGuitar.getProperty("settings.config.language"));  
    }
    
    public void createOption(){		
		getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));	
		getToolItem().setImage(SystemImages.OPTION_LANGUAGE);
		getToolItem().addSelectionListener(this);
		
		showLabel(getComposite(),SWT.FILL,SWT.TOP | SWT.LEFT | SWT.WRAP,SWT.BOLD,0,TuxGuitar.getProperty("settings.config.language.choose"));	
		
		Composite composite = new Composite(getComposite(),SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(getTabbedData());		
		
		String currenLanguage = getConfig().getStringConfigValue(ConfigKeys.LANGUAGE);
		if(currenLanguage == null || currenLanguage.trim().length() == 0){
			currenLanguage = TuxGuitar.instance().getLanguageManager().getLanguage();
		}
		String[] availableLanguages = TuxGuitar.instance().getLanguageManager().getLanguages();
		if(availableLanguages != null){
			this.languages = new Button[availableLanguages.length];
			for(int i = 0;i < this.languages.length;i++){
				this.languages[i] = new Button(composite,SWT.RADIO); 
				this.languages[i].setData(availableLanguages[i]);				
				this.languages[i].setText(TuxGuitar.getProperty(availableLanguages[i]));	    		    
				if(availableLanguages[i].equals(currenLanguage)){
					this.languages[i].setSelection(true);
				}
			}
		}
		
    }                        
    
    public void updateConfig(){    		        
    	String selected = "";
    	if(this.languages != null && this.languages.length > 0){
    		for(int i = 0;i < this.languages.length;i++){
    			if(this.languages[i].getSelection()){
    				selected = (String)this.languages[i].getData();
    			}
    		}
    	}
		getConfig().setProperty(ConfigKeys.LANGUAGE,selected);
    }
    
    
    public void applyConfig(boolean force){
    	TuxGuitar.instance().loadLanguage();
    	TuxGuitar.instance().loadProperties();
    	TuxGuitar.instance().getMixer().update();
    }
}