#!/bin/bash
#
#   multistation-devices-session-startup.sh
#
# AUTHOR
#   Jason Kim <jason@userful.com>
#
# DESCRIPTION
#   - This is run as normal login user, not root.
# 	- update GConf keys
# 	- call device specific script (audio and storage)
#
#
# Copyright (c) 2002-2007 by Userful Corporation
#
# Called from: default.session. (When gnome session starts)
# 			   - /usr/share/gnome/ for FC 
# 			   - /opt/gnome/share/gnome/ for SuSE
#            : /etc/xdg/autostart/umx-session-init.desktop
#
# Call: multistation-audio-session-startup.sh, multistation-storage-session-startup.sh

logfile="/var/log/userful-start.log"

# 
# update GConf keys
GCONF_VALUE=

# Do not show mounted volume on the desktop (gnome)
#GCONF_VALUE=`gconftool-2 -g /apps/nautilus/desktop/volumes_visible 2> /dev/null`
#if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
#	gconftool-2 --type bool --set /apps/nautilus/desktop/volumes_visible "false"
#fi

# Show computer icon
GCONF_VALUE=`gconftool-2 -g /apps/nautilus/desktop/computer_icon_visible 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "true" ]; then
	gconftool-2 --type bool --set /apps/nautilus/desktop/computer_icon_visible "true"
fi


## Disable Auto-Mount/Browse
# Don't open File Browser on other station
GCONF_VALUE=`gconftool-2 -g /apps/nautilus/preferences/media_automount 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /apps/nautilus/preferences/media_automount "false"
fi
GCONF_VALUE=`gconftool-2 -g /apps/nautilus/preferences/media_automount_open 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /apps/nautilus/preferences/media_automount_open "false"
fi
# Disable auto browse
GCONF_VALUE=`gconftool-2 -g /desktop/gnome/volume_manager/autobrowse 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
	gconftool-2 --type bool --set /desktop/gnome/volume_manager/autobrowse "false"
fi
# Disable automount drives
GCONF_VALUE=`gconftool-2 -g /desktop/gnome/volume_manager/automount_drives 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
	gconftool-2 --type bool --set /desktop/gnome/volume_manager/automount_drives "false"
fi
# Disable automount media
GCONF_VALUE=`gconftool-2 -g /desktop/gnome/volume_manager/automount_media 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
	gconftool-2 --type bool --set /desktop/gnome/volume_manager/automount_media "false"
fi


# Disable autoplay cda
#GCONF_VALUE=`gconftool-2 -g /desktop/gnome/volume_manager/autoplay_cda 2> /dev/null`
#if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
#	gconftool-2 --type bool --set /desktop/gnome/volume_manager/autoplay_cda "false"
#fi

# Disable autoplay cdr
#GCONF_VALUE=`gconftool-2 -g /desktop/gnome/volume_manager/autoplay_cdr 2> /dev/null`
#if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
#	gconftool-2 --type bool --set /desktop/gnome/volume_manager/autoplay_cdr "false"
#fi

# Disable autoplay dvd
#GCONF_VALUE=`gconftool-2 -g /desktop/gnome/volume_manager/autoplay_dvd 2> /dev/null`
#if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
#	gconftool-2 --type bool --set /desktop/gnome/volume_manager/autoplay_dvd "false"
#fi

# Disable autoplay vcd
#GCONF_VALUE=`gconftool-2 -g /desktop/gnome/volume_manager/autoplay_vcd 2> /dev/null`
#if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
#	gconftool-2 --type bool --set /desktop/gnome/volume_manager/autoplay_vcd "false"
#fi

# set GConf key for gnome-cd
GCONF_VALUE=`gconftool-2 -g /apps/gnome-cd/device 2> /dev/null`
if [ -n "$GCONF_VALUE" ]; then
	search_station_string="Srn$DISPLAY"
	assigned_CD_drive=`grep CDROM /etc/multiuserdevices | grep $search_station_string  | awk '{print $2}'`
	if [ "$assigned_CD_drive" != "" ]; then
		gconftool-2 --type string --set /apps/gnome-cd/device $assigned_CD_drive
	fi
fi

# Disable ESD
GCONF_VALUE=`gconftool-2 -g /desktop/gnome/sound/enable_esd 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /desktop/gnome/sound/enable_esd "false"
fi

# Disable event sound 
GCONF_VALUE=`gconftool-2 -g /desktop/gnome/sound/event_sounds 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /desktop/gnome/sound/event_sounds "false"
fi


##
## Disable System suspend and hibernate
GCONF_VALUE=`gconftool-2 -g /apps/gnome-power-manager/can_hibernate 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /apps/gnome-power-manager/can_hibernate "false"
fi
GCONF_VALUE=`gconftool-2 -g /apps/gnome-power-manager/can_suspend 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /apps/gnome-power-manager/can_suspend "false"
fi
# Ubuntu 9.04
GCONF_VALUE=`gconftool-2 -g /apps/gnome-power-manager/general/can_hibernate 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /apps/gnome-power-manager/general/can_hibernate "false"
fi
GCONF_VALUE=`gconftool-2 -g /apps/gnome-power-manager/general/can_suspend 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /apps/gnome-power-manager/general/can_suspend "false"
fi


## Disable Swith User
GCONF_VALUE=`gconftool-2 -g /apps/gnome-screensaver/user_switch_enabled 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /apps/gnome-screensaver/user_switch_enabled "false"
fi
GCONF_VALUE=`gconftool-2 -g /apps/fast-user-switch-applet/show_guest_login 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "false" ]; then
    gconftool-2 --type bool --set /apps/fast-user-switch-applet/show_guest_login "false"
fi
GCONF_VALUE=`gconftool-2 -g /apps/fast-user-switch-applet/show_active_users_only 2> /dev/null`
if [ -n "$GCONF_VALUE" -a "$GCONF_VALUE" != "true" ]; then
    gconftool-2 --type bool --set /apps/fast-user-switch-applet/show_active_users_only "true"
fi


if [ -x /opt/userful/bin/multistation-audio-session-startup.sh ]; then
	/opt/userful/bin/multistation-audio-session-startup.sh
fi

if [ -x /opt/userful/bin/multistation-storage-session-startup.sh ]; then
	/opt/userful/bin/multistation-storage-session-startup.sh
fi

