#!/bin/bash
#
#  userful-ctrlaltbreak-command.sh
#
##################################


############
# usage()
############
function usage()
{
	echo ""
	echo "Usage: userful ctrlaltbreak [OPTION]"
	echo ""
	echo -e "\tOPTIONS:"
	echo -e "\t\t-h"
	echo -e "\t\t-help\t\t- Print this help message"
	echo -e "\t\t-enable\t\t- Enable Ctrl-Alt-Break functionality"
	echo -e "\t\t-disable\t- Disable Ctrl-Alt-Break functionality"
	echo ""
	exit 1
}

#########################
# toggleXtype()
#########################
function toggleCtrlAltBreak()
{
	[[ -z $1 ]] && usage

	if [[ "$1" == "-enable" ]]; then
		echo -e "\nEnable Ctrl-Alt-Break functionality..\n"
		configtype="enable"

	elif [[ "$1" == "-disable" ]]; then
		echo -e "\nDisable Ctrl-Alt-Break functionality..\n"
		configtype="disable"
	fi

	# Update dm.conf with configtype
	if grep "^[[:space:]]*CTRLALTBREAK=" /etc/userful/dm.conf > /dev/null 2>&1; then
    	sed -i -e "s/^[[:space:]]*CTRLALTBREAK=.*/CTRLALTBREAK=$configtype/g" /etc/userful/dm.conf
	elif grep "^[[:space:]]*#[[:space:]]*CTRLALTBREAK=" /etc/userful/dm.conf > /dev/null 2>&1; then
    	sed -i -e "s/^[[:space:]]*#[[:space:]]*CTRLALTBREAK=.*/CTRLALTBREAK=$configtype/g" /etc/userful/dm.conf
	else
    	echo "CTRLALTBREAK=$configtype" >> /etc/userful/dm.conf
	fi
}

#-------------------
# Start from here
#-------------------

# Import functions
source /opt/userful/bin/userful-bash-lib.sh

#
# Check if user has root access..
IsRoot

[[ -z $1 ]] && usage

case "$1" in
	-h|-help)
		usage
		;;

	-enable|-disable)
		toggleCtrlAltBreak $1
		;;

	*)
		echo -e "\nError: Invalid option - $1"
		usage
		;;
esac

