#!/bin/bash
#
# 	umx-mandatory-dev-refresh.sh
#
#	Author:
#		Jason Kim <jason@userful.com>
#
# 	Copyright (c) 2002-2008 by Userful Corporation
#
# 	DESCRIPTION
#       - This feature is preliminary and only for ThinNetworks for now.
#		- This program regenerates /etc/umx-man-dev using HAL on every bootup and
#		  keyboard assignment.  
#       - License key have the information of mandatory device
#

logfile="/var/log/userful-start.log"
CONFIG_FILE="/etc/umx-man-dev"
ProgramName=`basename $0`

##
## Load userful-license-info
if [ -f /etc/userful/userful-license-info ]; then
    source /etc/userful/userful-license-info
else
    echo "`date +"%b %d %T"` $ProgramName: Unable to find userful-license-info." >> $logfile
    rm -f $CONFIG_FILE
    # create /etc/umx-man-dev 
    #echo "TOTAL:0 AVAIL:0" >> $CONFIG_FILE
    exit 1
fi

#  - Use license key to enable/disable Mandatory device
if [ x"$MANDATORY_DEV" == x ]; then
    # Mandatory device is not enabled.
    rm -f $CONFIG_FILE
    exit 0
fi

#if [ x"$VENDOR_STR" == x ] || 
#   [ x"$DEV_TYPE" == x ]; then
#    echo "`date +"%b %d %T"` $ProgramName: Invalid information for the mandatory device is found." >> $logfile
#    rm -f $CONFIG_FILE
#    exit 1
#fi

echo "`date +"%b %d %T"` $ProgramName: Mandatory device is enabled. $MANDATORY_DEV" >> $logfile

## Check /etc/usbinput
if [ ! -e /etc/usbinput ]; then
    /opt/userful/bin/make-config-file
fi
if [ ! -e /etc/usbinput ]; then
    echo "`date +"%b %d %T"` $ProgramName: Unable to find the /etc/usbinput" >> $logfile
    rm -f $CONFIG_FILE
    #echo "TOTAL:0 AVAIL:0" >> $CONFIG_FILE
    exit 1
fi

# Initialize $CONFIG_FILE
: > $CONFIG_FILE
chmod a+r $CONFIG_FILE

#-------------------------------------------------
# Utilize HAL system to find the mandatory device(old)
#-------------------------------------------------
##
## Find total number of mandatory devices
## Use lsusb -v for now.
TOTAL_DEV=`lsusb -v | grep $MANDATORY_DEV | wc -l`

if [ x"$EXTRA_STN" != x ]; then
    TOTAL_DEV=$((TOTAL_DEV+EXTRA_STN))
fi

##
## Figure the used mandatory devices using /etc/usbinput
##
USED_DEV=0

while read line; do
    if [ "${line:5:3}" == "kbd" ]; then
        # Check the configured keyboard.
        if [ "${line:1:1}" == "1" ]; then
            USED_DEV=$((USED_DEV+1))
        fi
    fi
done < /etc/usbinput

AVAIL_DEV=$((TOTAL_DEV-$USED_DEV))
if [ $AVAIL_DEV -lt 0 ];then
    AVAIL_DEV=0
fi

##
## Create config file, umx-man-dev
##
echo "TOTAL:$TOTAL_DEV AVAILABLE:$AVAIL_DEV"  > $CONFIG_FILE

##################
#TOTAL_DEV=0
## TODO:
##  usb.vendor should be changed
#MAN_UDIS=`hal-find-by-property --key "usb.vendor" --string "$VENDOR_STR"`
#for UDI in $MAN_UDIS
#do
#	# Find driver 
#	DRIVER=`hal-get-property --udi "$UDI" --key "info.linux.driver"`
#
#    if [ "$DRIVER" != "$DEV_TYPE" ]; then
#        continue
#    fi
#
#    #echo "$UDI"
#    TOTAL_DEV=$((TOTAL_DEV+1))
#done
#
## Figure the used mandatory devices using /etc/usbinput
#USED_DEV=0
#
#while read line; do
#    if [ "${line:5:3}" == "kbd" ]; then
#        if [ "${line:1:1}" == "1" ]; then
#            USED_DEV=$((USED_DEV+1))
#        fi
#    fi
#done < /etc/usbinput
#
#AVAIL_DEV=$((TOTAL_DEV-$USED_DEV))
#if [ $AVAIL_DEV -lt 0 ];then
#    AVAIL_DEV=0
#fi
#echo "TOTAL:$TOTAL_DEV AVAILABLE:$AVAIL_DEV"  > $CONFIG_FILE
