/*
 * res.h
 *
 * Written by
 *  Andreas Boose <viceteam@t-online.de>
 *  Ettore Perazzoli <ettore@comm2000.it>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _RES_H
#define _RES_H

#define IDR_MENUC64                     101
#define IDR_MENUC128                    102
#define IDR_MENUVIC                     103
#define IDR_MENUPET                     104
#define IDR_MENUPLUS4                   105
#define IDR_MENUCBM2                    106
#define IDR_MENUMONITOR                 107
#define IDR_MONTOOLBAR                  108
#define IDI_ICON1                       109

#define IDD_ABOUT                       110
#define IDC_ABOUT_VERSION               1002

#define IDC_BROWSEDISK                  1006
#define IDC_SELECTDISK                  1007
#define IDC_SELECTNONE                  1008
#define IDC_SELECTDIR                   1009
#define IDC_SELECTREAL                  1010
#define IDC_BROWSEDIR                   1011

#define IDD_DISKDEVICE_DIALOG           1012
#define IDC_AUTOSTART                   1013
#define IDC_DISKIMAGE                   1014
#define IDC_DIR                         1015
#define IDC_TOGGLE_READP00              1016
#define IDC_TOGGLE_WRITEP00             1017
#define IDC_TOGGLE_HIDENONP00           1018
#define IDC_TOGGLE_ATTACH_READONLY      1019
#define IDC_TOGGLE_USEIECDEVICE         1020

#define IDC_SELECT_DRIVE_TYPE_1541      1021
#define IDC_SELECT_DRIVE_TYPE_1541II    1022
#define IDC_SELECT_DRIVE_TYPE_1551      1023
#define IDC_SELECT_DRIVE_TYPE_1570      1024
#define IDC_SELECT_DRIVE_TYPE_1571      1025
#define IDC_SELECT_DRIVE_TYPE_1571cr    1026
#define IDC_SELECT_DRIVE_TYPE_1581      1027
#define IDC_SELECT_DRIVE_TYPE_2031      1028
#define IDC_SELECT_DRIVE_TYPE_2040      1029
#define IDC_SELECT_DRIVE_TYPE_3040      1030
#define IDC_SELECT_DRIVE_TYPE_4040      1031
#define IDC_SELECT_DRIVE_TYPE_1001      1032
#define IDC_SELECT_DRIVE_TYPE_8050      1033
#define IDC_SELECT_DRIVE_TYPE_8250      1034
#define IDC_SELECT_DRIVE_TYPE_NONE      1035

#define IDD_DRIVE_EXTEND_DIALOG         1036
#define IDC_SELECT_DRIVE_EXTEND_NEVER   1037
#define IDC_SELECT_DRIVE_EXTEND_ASK     1038
#define IDC_SELECT_DRIVE_EXTEND_ACCESS  1039

#define IDD_DRIVE_IDLE_METHOD           1040
#define IDC_SELECT_DRIVE_IDLE_NO_IDLE   1041
#define IDC_SELECT_DRIVE_IDLE_TRAP_IDLE 1042
#define IDC_SELECT_DRIVE_IDLE_SKIP_CYCLES 1043

#define IDD_DRIVE_SYNC_FACTOR           1050
#define IDC_SELECT_DRIVE_SYNC_PAL       1051
#define IDC_SELECT_DRIVE_SYNC_NTSC      1052
#define IDC_SELECT_DRIVE_SYNC_NTSCOLD   1053
#define IDC_TOGGLE_DRIVE_PARALLEL_CABLE 1060
#define IDD_SNAPSHOT_SAVE_DIALOG        1070
#define IDC_SNAPSHOT_SAVE_IMAGE         1071
#define IDC_TOGGLE_SNAPSHOT_SAVE_DISKS  1072
#define IDC_TOGGLE_SNAPSHOT_SAVE_ROMS   1073
#define IDD_MEDIAFILE_DIALOG            1074
#define IDC_SCREENSHOT_DRIVER           1075
#define IDD_VICII_DIALOG                1080
#define IDC_TOGGLE_VICII_SSC            1081
#define IDC_TOGGLE_VICII_SBC            1082
#define IDC_TOGGLE_VICII_NEWLUM         1083
#define IDD_PET_SETTINGS_MODEL_DIALOG   1095
#define IDD_PET_SETTINGS_IO_DIALOG      1096
#define IDD_PET_SETTINGS_SUPER_DIALOG   1097
#define IDD_PET_SETTINGS_8296_DIALOG    1098
#define IDC_SELECT_PET_2001_8N          1100
#define IDC_SELECT_PET_3008             1101
#define IDC_SELECT_PET_3016             1102
#define IDC_SELECT_PET_3032             1103
#define IDC_SELECT_PET_3032B            1104
#define IDC_SELECT_PET_4016             1105
#define IDC_SELECT_PET_4032             1106
#define IDC_SELECT_PET_4032B            1107
#define IDC_SELECT_PET_8032             1108
#define IDC_SELECT_PET_8096             1109
#define IDC_SELECT_PET_8296             1110
#define IDC_SELECT_PET_SUPER            1111
#define IDC_SELECT_PET_MEM4K            1120
#define IDC_SELECT_PET_MEM8K            1121
#define IDC_SELECT_PET_MEM16K           1122
#define IDC_SELECT_PET_MEM32K           1123
#define IDC_SELECT_PET_MEM96K           1124
#define IDC_SELECT_PET_MEM128K          1125
#define IDC_SELECT_PET_IO2K             1128
#define IDC_SELECT_PET_IO256            1129
#define IDC_SELECT_PET_VIDEO_AUTO       1130
#define IDC_SELECT_PET_VIDEO_40         1131
#define IDC_SELECT_PET_VIDEO_80         1132
#define IDC_SELECT_PET_KEYB_GRAPHICS    1135
#define IDC_SELECT_PET_KEYB_BUSINESS    1136
#define IDC_TOGGLE_PET_CRTC             1140
#define IDC_TOGGLE_PET_SUPER_IO_ENABLE  1141
#define IDC_TOGGLE_PET_8296_RAM9        1142
#define IDC_TOGGLE_PET_8296_RAMA        1143
#define IDD_CBMII_SETTINGS_MODEL_DIALOG 1148
#define IDD_CBMII_SETTINGS_IO_DIALOG    1149
#define IDC_SELECT_CBMII_610            1150
#define IDC_SELECT_CBMII_620            1151
#define IDC_SELECT_CBMII_620P           1152
#define IDC_SELECT_CBMII_710            1153
#define IDC_SELECT_CBMII_720            1154
#define IDC_SELECT_CBMII_720P           1155
#define IDC_SELECT_CBMII_MEM_128        1160
#define IDC_SELECT_CBMII_MEM_256        1161
#define IDC_SELECT_CBMII_MEM_512        1162
#define IDC_SELECT_CBMII_MEM_1024       1163
#define IDC_SELECT_CBMII_HW0            1165
#define IDC_SELECT_CBMII_HW1            1166
#define IDC_SELECT_CBMII_HW2            1167
#define IDC_TOGGLE_CBMII_RAM08          1170
#define IDC_TOGGLE_CBMII_RAM1           1171
#define IDC_TOGGLE_CBMII_RAM2           1172
#define IDC_TOGGLE_CBMII_RAM4           1173
#define IDC_TOGGLE_CBMII_RAM6           1174
#define IDC_TOGGLE_CBMII_RAMC           1175
#define IDC_SELECT_CBMII_KEYB_GRAPHICS  1180
#define IDC_SELECT_CBMII_KEYB_BUSINESS  1181
#define IDC_TOGGLE_DRIVE_EXPANSION_2000 1190
#define IDC_TOGGLE_DRIVE_EXPANSION_4000 1191
#define IDC_TOGGLE_DRIVE_EXPANSION_6000 1192
#define IDC_TOGGLE_DRIVE_EXPANSION_8000 1193
#define IDC_TOGGLE_DRIVE_EXPANSION_A000 1194

#define IDD_JOY_SETTINGS_DIALOG         1200
#define IDC_JOY_DEV1                    1201
#define IDC_JOY_DEV2                    1202
#define IDC_JOY_CALIBRATE               1203
#define IDC_JOY_CONFIG_A                1204
#define IDC_JOY_CONFIG_B                1205
#define IDC_JOY_FIRE1_SPEED             1206
#define IDC_JOY_FIRE2_SPEED             1207
#define IDC_JOY_FIRE1_AXIS              1208
#define IDC_JOY_FIRE2_AXIS              1209
#define IDC_JOY_FIRE1_BUTTON            1210
#define IDC_JOY_FIRE2_BUTTON            1211
#define IDC_JOY_AUTOFIRE1_BUTTON	1212
#define IDC_JOY_AUTOFIRE2_BUTTON	1213

#define IDD_CONFIG_KEYSET_DIALOG        1215
#define IDC_KEYSET_SW                   1216
#define IDC_KEYSET_S                    1217
#define IDC_KEYSET_SE                   1218
#define IDC_KEYSET_W                    1219
#define IDC_KEYSET_E                    1220
#define IDC_KEYSET_NW                   1221
#define IDC_KEYSET_N                    1222
#define IDC_KEYSET_NE                   1223
#define IDC_KEYSET_FIRE                 1224
#define IDC_KEY_SW                      1225
#define IDC_KEY_S                       1226
#define IDC_KEY_SE                      1227
#define IDC_KEY_W                       1228
#define IDC_KEY_E                       1229
#define IDC_KEY_NW                      1230
#define IDC_KEY_N                       1231
#define IDC_KEY_NE                      1232
#define IDC_KEY_FIRE                    1233

#define IDD_CONFIG_KEY_DIALOG           1235

#define IDD_SOUND_SETTINGS_DIALOG       1240
#define IDC_SOUND_FREQ                  1241
#define IDC_SOUND_BUFFER                1242
#define IDC_SOUND_OVERSAMPLE            1243
#define IDC_SOUND_SYNCH                 1244
#define IDC_SOUND_DIRECTX               1245
#define IDC_SOUND_WMM                   1246
#define IDC_SOUND_SIDSTEREO             1247

#define IDD_OPEN_TEMPLATE               1250
#define IDD_OPENTAPE_TEMPLATE           1251
#define IDC_PREVIEW                     1252
#define IDC_BLANK_IMAGE                 1253
#define IDC_BLANK_IMAGE_TYPE            1254
#define IDC_BLANK_IMAGE_NAME            1255
#define IDC_BLANK_IMAGE_ID              1256

#define IDD_DATASETTE_SETTINGS_DIALOG   1260
#define IDC_DATASETTE_RESET_WITH_CPU    1261
#define IDC_DATASETTE_SPEED_TUNING      1262
#define IDC_DATASETTE_ZERO_GAP_DELAY    1263

#define IDD_VIC_SETTINGS_DIALOG         1270
#define IDC_VIC_NOEXPANSION             1271
#define IDC_VIC_3KEXPANSION             1272
#define IDC_VIC_8KEXPANSION             1273
#define IDC_VIC_16KEXPANSION            1274
#define IDC_VIC_24KEXPANSION            1275
#define IDC_VIC_FULLEXPANSION           1276
#define IDC_VIC_CUSTOMEXPANSION         1277
#define IDC_VIC_MEMORY_BLOCK0           1278
#define IDC_VIC_MEMORY_BLOCK1           1279
#define IDC_VIC_MEMORY_BLOCK2           1280
#define IDC_VIC_MEMORY_BLOCK3           1281
#define IDC_VIC_MEMORY_BLOCK5           1282

#define IDD_DIALOG1                     1301
#define IDD_TEXTDLG                     1301
#define IDC_TEXT                        1302
#define IDC_HEADER                      1303

#define IDD_CONSOLE_SAVE_DIALOG         1310
#define IDC_TOGGLE_CONSOLE_APPEND       1311

#define IDD_FULLSCREEN_SETTINGS_DIALOG  1320
#define IDC_FULLSCREEN_DEVICE           1321
#define IDC_FULLSCREEN_RESOLUTION       1322
#define IDC_FULLSCREEN_BITDEPTH         1323
#define IDC_FULLSCREEN_REFRESHRATE      1324

#define IDD_REU_SETTINGS_DIALOG         1330
#define IDC_REU_ENABLE                  1331
#define IDC_REU_SIZE                    1332
#define IDC_REU_FILE                    1333
#define IDC_REU_BROWSE                  1334

#define IDD_SID_GENERAL_SETTINGS_DIALOG 1340
#define IDD_SID_RESID_SETTINGS_DIALOG   1341
#define IDD_SID_HARDSID_SETTINGS_DIALOG 1342
#define IDC_SID_FILTERS                 1343
#define IDC_SID_6581                    1344
#define IDC_SID_8580                    1345
#define IDC_SID_STEREO                  1346
#define IDC_SID_ENGINE                  1347
#define IDC_SID_RESID_SAMPLING          1348
#define IDC_SID_RESID_PASSBAND          1349
#define IDC_SID_STEREOADDRESS           1350
#define IDC_SID_HARDSID_LEFT_ENGINE     1351
#define IDC_SID_HARDSID_RIGHT_ENGINE    1352

#define IDD_CUSTOM_SPEED_DIALOG         1390
#define IDC_CUSTOM_SPEED                1391

#define IDD_VIDEO_COLORS_DIALOG         1400
#define IDC_VIDEO_COLORS_SAT            1401
#define IDC_VIDEO_COLORS_CON            1402
#define IDC_VIDEO_COLORS_BRI            1403
#define IDD_VIDEO_FULLSCREEN_DIALOG     1404
#define IDC_VIDEO_FULLSCREEN_DEVICE     1405
#define IDC_VIDEO_FULLSCREEN_BITDEPTH   1406
#define IDC_VIDEO_FULLSCREEN_RESOLUTION 1407
#define IDC_VIDEO_FULLSCREEN_REFRESHRATE 1408
#define IDD_VIDEO_ADVANCED_DIALOG       1409
#define IDC_VIDEO_COLORS_GAM            1410
#define IDC_VIDEO_COLORS_PHA            1411

#define IDC_TOGGLE_VIDEO_EXTPALETTE     1412
#define IDC_VIDEO_CUSTOM_NAME           1413
#define IDC_VIDEO_CUSTOM_BROWSE         1414
#define IDC_SELECT_VIDEO_CUSTOM         1415
#define IDC_VIDEO_ADVANCED_SHADE        1416
#define IDC_VIDEO_ADVANCED_BLUR         1417
#define IDC_VIDEO_ADVANCED_MODE         1418
#define IDC_TOGGLE_VIDEO_VBLANK_SYNC    1419
#define IDC_TOGGLE_VIDEO_DX_PRIMARY	1420
#define IDD_VIDEO_PALETTE_DIALOG        1421

#define IDD_PLUS4_MEMORY_DIALOG         1425
#define IDC_SELECT_PLUS4_MEM_16         1426
#define IDC_SELECT_PLUS4_MEM_32         1427
#define IDC_SELECT_PLUS4_MEM_64         1428

#define IDD_RAM_SETTINGS_DIALOG         1430
#define IDC_RAMINIT_STARTVALUE          1431
#define IDC_RAMINIT_VALUEINVERT         1432
#define IDC_RAMINIT_PATTERNINVERT       1433
#define IDC_RAMINIT_PREVIEW             1434

#define IDD_DRIVE_SETTINGS_DIALOG_C64VIC20 1440
#define IDD_DRIVE_SETTINGS_DIALOG_PLUS4    1441
#define IDD_DRIVE_SETTINGS_DIALOG_PETCBM2  1442
#define IDD_DRIVE_SETTINGS_DIALOG_C128     1443

#define IDD_TFE_SETTINGS_DIALOG         1450
#define IDC_TFE_SETTINGS_ENABLE_T       1451
#define IDC_TFE_SETTINGS_ENABLE         1452
#define IDC_TFE_SETTINGS_INTERFACE_T    1453
#define IDC_TFE_SETTINGS_INTERFACE      1454
#define IDC_TFE_SETTINGS_INTERFACE_NAME 1455
#define IDC_TFE_SETTINGS_INTERFACE_DESC 1456

#define IDD_PRINTER_SETTINGS_DIALOG     1500
#define IDC_PRINTER_TYPE                1501
#define IDC_PRINTER_DRIVER              1502
#define IDC_PRINTER_TEXTOUT             1503
#define IDC_PRINTER_USEIECDEVICE        1504
#define IDC_PRINTER_OUTPUT              1505
#define IDC_PRINTER_FORMFEED            1506
#define IDC_PRINTER_OUTPUT_FILE1_NAME   1590
#define IDC_PRINTER_OUTPUT_FILE2_NAME   1591
#define IDC_PRINTER_OUTPUT_FILE3_NAME   1592

#define IDD_C128_MACHINE_SETTINGS_DIALOG     1600
#define IDC_C128_MACHINE_TYPE                1601
#define IDD_C128_FUNCTIONROM_SETTINGS_DIALOG 1630
#define IDC_C128_FUNCTIONROM_INTERNAL        1631
#define IDC_C128_FUNCTIONROM_INTERNAL_NAME   1632
#define IDC_C128_FUNCTIONROM_INTERNAL_BROWSE 1633
#define IDC_C128_FUNCTIONROM_EXTERNAL        1634
#define IDC_C128_FUNCTIONROM_EXTERNAL_NAME   1635
#define IDC_C128_FUNCTIONROM_EXTERNAL_BROWSE 1636

#define IDD_C64ROM_SETTINGS_DIALOG      1660
#define IDC_C64ROM_KERNAL_FILE          1661
#define IDC_C64ROM_KERNAL_BROWSE        1662
#define IDC_C64ROM_BASIC_FILE           1663
#define IDC_C64ROM_BASIC_BROWSE         1664
#define IDC_C64ROM_CHARGEN_FILE         1665
#define IDC_C64ROM_CHARGEN_BROWSE       1666
#define IDD_C64ROM_RESOURCE_DIALOG      1667
#define IDC_C64ROM_KERNAL_RESOURCE      1668
#define IDC_C64ROM_BASIC_RESOURCE       1669
#define IDC_C64ROM_CHARGEN_RESOURCE     1670

#define IDD_C128ROM_SETTINGS_DIALOG     1680
#define IDC_C128ROM_KERNALINT_FILE      1681
#define IDC_C128ROM_KERNALINT_BROWSE    1682
#define IDC_C128ROM_KERNALDE_FILE       1683
#define IDC_C128ROM_KERNALDE_BROWSE     1684
#define IDC_C128ROM_KERNALFI_FILE       1685
#define IDC_C128ROM_KERNALFI_BROWSE     1686
#define IDC_C128ROM_KERNALFR_FILE       1687
#define IDC_C128ROM_KERNALFR_BROWSE     1688
#define IDC_C128ROM_KERNALIT_FILE       1689
#define IDC_C128ROM_KERNALIT_BROWSE     1690
#define IDC_C128ROM_KERNALNO_FILE       1691
#define IDC_C128ROM_KERNALNO_BROWSE     1692
#define IDC_C128ROM_KERNALSE_FILE       1693
#define IDC_C128ROM_KERNALSE_BROWSE     1694
#define IDC_C128ROM_BASICLO_FILE        1695
#define IDC_C128ROM_BASICLO_BROWSE      1696
#define IDC_C128ROM_BASICHI_FILE        1697
#define IDC_C128ROM_BASICHI_BROWSE      1698
#define IDC_C128ROM_CHARGENINT_FILE     1699
#define IDC_C128ROM_CHARGENINT_BROWSE   1700
#define IDC_C128ROM_CHARGENDE_FILE      1701
#define IDC_C128ROM_CHARGENDE_BROWSE    1702
#define IDC_C128ROM_CHARGENFR_FILE      1703
#define IDC_C128ROM_CHARGENFR_BROWSE    1704
#define IDC_C128ROM_CHARGENSE_FILE      1705
#define IDC_C128ROM_CHARGENSE_BROWSE    1706
#define IDC_C128ROM_KERNAL64_FILE       1707
#define IDC_C128ROM_KERNAL64_BROWSE     1708
#define IDC_C128ROM_BASIC64_FILE        1709
#define IDC_C128ROM_BASIC64_BROWSE      1710
#define IDD_C128ROM_RESOURCE_DIALOG     1711
#define IDC_C128ROM_KERNALINT_RESOURCE  1712
#define IDC_C128ROM_KERNALDE_RESOURCE   1713
#define IDC_C128ROM_KERNALFI_RESOURCE   1714
#define IDC_C128ROM_KERNALFR_RESOURCE   1715
#define IDC_C128ROM_KERNALIT_RESOURCE   1716
#define IDC_C128ROM_KERNALNO_RESOURCE   1717
#define IDC_C128ROM_KERNALSE_RESOURCE   1718
#define IDC_C128ROM_BASICLO_RESOURCE    1719
#define IDC_C128ROM_BASICHI_RESOURCE    1720
#define IDC_C128ROM_CHARGENINT_RESOURCE 1721
#define IDC_C128ROM_CHARGENDE_RESOURCE  1722
#define IDC_C128ROM_CHARGENFR_RESOURCE  1723
#define IDC_C128ROM_CHARGENSE_RESOURCE  1724
#define IDC_C128ROM_KERNAL64_RESOURCE   1725
#define IDC_C128ROM_BASIC64_RESOURCE    1726

#define IDD_VIC20ROM_SETTINGS_DIALOG    1730
#define IDC_VIC20ROM_KERNAL_FILE        1731
#define IDC_VIC20ROM_KERNAL_BROWSE      1732
#define IDC_VIC20ROM_BASIC_FILE         1733
#define IDC_VIC20ROM_BASIC_BROWSE       1734
#define IDC_VIC20ROM_CHARGEN_FILE       1735
#define IDC_VIC20ROM_CHARGEN_BROWSE     1736
#define IDD_VIC20ROM_RESOURCE_DIALOG    1737
#define IDC_VIC20ROM_KERNAL_RESOURCE    1738
#define IDC_VIC20ROM_BASIC_RESOURCE     1739
#define IDC_VIC20ROM_CHARGEN_RESOURCE   1740

#define IDD_PETROM_SETTINGS_DIALOG      1750
#define IDC_PETROM_KERNAL_FILE          1751
#define IDC_PETROM_KERNAL_BROWSE        1752
#define IDC_PETROM_BASIC_FILE           1753
#define IDC_PETROM_BASIC_BROWSE         1754
#define IDC_PETROM_CHARGEN_FILE         1755
#define IDC_PETROM_CHARGEN_BROWSE       1756
#define IDC_PETROM_EDITOR_FILE          1757
#define IDC_PETROM_EDITOR_BROWSE        1758
#define IDC_PETROM_ROM9_FILE            1759
#define IDC_PETROM_ROM9_BROWSE          1760
#define IDC_PETROM_ROMA_FILE            1761
#define IDC_PETROM_ROMA_BROWSE          1762
#define IDC_PETROM_ROMB_FILE            1763
#define IDC_PETROM_ROMB_BROWSE          1764
#define IDD_PETROM_RESOURCE_DIALOG      1765
#define IDC_PETROM_KERNAL_RESOURCE      1766
#define IDC_PETROM_BASIC_RESOURCE       1767
#define IDC_PETROM_CHARGEN_RESOURCE     1768
#define IDC_PETROM_EDITOR_RESOURCE      1769
#define IDC_PETROM_ROM9_RESOURCE        1770
#define IDC_PETROM_ROMA_RESOURCE        1771
#define IDC_PETROM_ROMB_RESOURCE        1772

#define IDD_PLUS4ROM_SETTINGS_DIALOG    1780
#define IDC_PLUS4ROM_KERNAL_FILE        1781
#define IDC_PLUS4ROM_KERNAL_BROWSE      1782
#define IDC_PLUS4ROM_BASIC_FILE         1783
#define IDC_PLUS4ROM_BASIC_BROWSE       1784
#define IDC_PLUS4ROM_3P1LO_FILE         1785
#define IDC_PLUS4ROM_3P1LO_BROWSE       1786
#define IDC_PLUS4ROM_3P1HI_FILE         1787
#define IDC_PLUS4ROM_3P1HI_BROWSE       1788
#define IDD_PLUS4ROM_RESOURCE_DIALOG    1789
#define IDC_PLUS4ROM_KERNAL_RESOURCE    1790
#define IDC_PLUS4ROM_BASIC_RESOURCE     1791
#define IDC_PLUS4ROM_3P1LO_RESOURCE     1792
#define IDC_PLUS4ROM_3P1HI_RESOURCE     1793

#define IDD_CBM2ROM_SETTINGS_DIALOG     1810
#define IDC_CBM2ROM_KERNAL_FILE         1811
#define IDC_CBM2ROM_KERNAL_BROWSE       1812
#define IDC_CBM2ROM_BASIC_FILE          1813
#define IDC_CBM2ROM_BASIC_BROWSE        1814
#define IDC_CBM2ROM_CHARGEN_FILE        1815
#define IDC_CBM2ROM_CHARGEN_BROWSE      1816
#define IDC_CBM2ROM_CART1_FILE          1817
#define IDC_CBM2ROM_CART1_BROWSE        1818
#define IDC_CBM2ROM_CART2_FILE          1819
#define IDC_CBM2ROM_CART2_BROWSE        1820
#define IDC_CBM2ROM_CART4_FILE          1821
#define IDC_CBM2ROM_CART4_BROWSE        1822
#define IDC_CBM2ROM_CART6_FILE          1823
#define IDC_CBM2ROM_CART6_BROWSE        1824
#define IDD_CBM2ROM_RESOURCE_DIALOG     1825
#define IDC_CBM2ROM_KERNAL_RESOURCE     1826
#define IDC_CBM2ROM_BASIC_RESOURCE      1827
#define IDC_CBM2ROM_CHARGEN_RESOURCE    1828
#define IDC_CBM2ROM_CART1_RESOURCE      1829
#define IDC_CBM2ROM_CART2_RESOURCE      1830
#define IDC_CBM2ROM_CART4_RESOURCE      1831
#define IDC_CBM2ROM_CART6_RESOURCE      1832

#define IDD_IDE64_SETTINGS_DIALOG       1840
#define IDC_IDE64_HDIMAGE_BROWSE        1841
#define IDC_IDE64_HDIMAGE_FILE          1842
#define IDC_TOGGLE_IDE64_SIZEAUTODETECT 1843
#define IDC_IDE64_CYLINDERS             1844
#define IDC_IDE64_HEADS                 1845
#define IDC_IDE64_SECTORS               1846
#define IDC_IDE64_SIZE                  1847

#define IDD_C64DRIVEROM_SETTINGS_DIALOG   1850
#define IDD_C128DRIVEROM_SETTINGS_DIALOG  1851
#define IDD_VIC20DRIVEROM_SETTINGS_DIALOG 1852
#define IDD_PETDRIVEROM_SETTINGS_DIALOG   1853
#define IDD_PLUS4DRIVEROM_SETTINGS_DIALOG 1854
#define IDD_CBM2DRIVEROM_SETTINGS_DIALOG  1855
#define IDD_C64ROMDRIVE_RESOURCE_DIALOG   1856
#define IDD_C128ROMDRIVE_RESOURCE_DIALOG  1857
#define IDD_VIC20ROMDRIVE_RESOURCE_DIALOG 1858
#define IDD_PETROMDRIVE_RESOURCE_DIALOG   1859
#define IDD_PLUS4ROMDRIVE_RESOURCE_DIALOG 1860
#define IDD_CBM2ROMDRIVE_RESOURCE_DIALOG  1861

#define IDC_DRIVEROM_1541_FILE          1870
#define IDC_DRIVEROM_1541_BROWSE        1871
#define IDC_DRIVEROM_1541II_FILE        1872
#define IDC_DRIVEROM_1541II_BROWSE      1873
#define IDC_DRIVEROM_1551_FILE          1874
#define IDC_DRIVEROM_1551_BROWSE        1875
#define IDC_DRIVEROM_1570_FILE          1876
#define IDC_DRIVEROM_1570_BROWSE        1877
#define IDC_DRIVEROM_1571_FILE          1878
#define IDC_DRIVEROM_1571_BROWSE        1879
#define IDC_DRIVEROM_1571CR_FILE        1880
#define IDC_DRIVEROM_1571CR_BROWSE      1881
#define IDC_DRIVEROM_1581_FILE          1882
#define IDC_DRIVEROM_1581_BROWSE        1883
#define IDC_DRIVEROM_2031_FILE          1884
#define IDC_DRIVEROM_2031_BROWSE        1885
#define IDC_DRIVEROM_2040_FILE          1886
#define IDC_DRIVEROM_2040_BROWSE        1887
#define IDC_DRIVEROM_3040_FILE          1888
#define IDC_DRIVEROM_3040_BROWSE        1889
#define IDC_DRIVEROM_4040_FILE          1890
#define IDC_DRIVEROM_4040_BROWSE        1891
#define IDC_DRIVEROM_1001_FILE          1892
#define IDC_DRIVEROM_1001_BROWSE        1893
#define IDC_DRIVEROM_1541_RESOURCE      1900
#define IDC_DRIVEROM_1541II_RESOURCE    1901
#define IDC_DRIVEROM_1551_RESOURCE      1902
#define IDC_DRIVEROM_1570_RESOURCE      1903
#define IDC_DRIVEROM_1571_RESOURCE      1904
#define IDC_DRIVEROM_1571CR_RESOURCE    1905
#define IDC_DRIVEROM_1581_RESOURCE      1906
#define IDC_DRIVEROM_2031_RESOURCE      1907
#define IDC_DRIVEROM_2040_RESOURCE      1908
#define IDC_DRIVEROM_3040_RESOURCE      1909
#define IDC_DRIVEROM_4040_RESOURCE      1910
#define IDC_DRIVEROM_1001_RESOURCE      1911

#define IDD_ROMSET_SETTINGS_DIALOG      1920
#define IDC_ROMSET_SELECT_ARCHIVE       1921
#define IDC_ROMSET_SELECT_FILE          1922
#define IDC_ROMSET_ARCHIVE_NAME         1923
#define IDC_ROMSET_ARCHIVE_BROWSE       1924
#define IDC_ROMSET_ARCHIVE_LOAD         1925
#define IDC_ROMSET_ARCHIVE_SAVE         1926
#define IDC_ROMSET_ARCHIVE_ACTIVE       1927
#define IDC_ROMSET_ARCHIVE_APPLY        1928
#define IDC_ROMSET_ARCHIVE_NEW          1929
#define IDC_ROMSET_ARCHIVE_DELETE       1930
#define IDC_ROMSET_FILE_NAME            1931
#define IDC_ROMSET_FILE_BROWSE          1932
#define IDC_ROMSET_FILE_LOAD            1933
#define IDC_ROMSET_FILE_SAVE            1934
#define IDC_ROMSET_PREVIEW              1935
#define IDC_ROMSET_RESOURCE_COMPUTER    1936
#define IDC_ROMSET_RESOURCE_DRIVE       1937
#define IDC_ROMSET_RESOURCE_OTHER       1938

#define IDD_ROMSET_ENTER_NAME_DIALOG    1940
#define IDC_ROMSET_ENTER_NAME           1941

#define IDD_ACIA_SETTINGS_DIALOG        1950
#define IDC_ACIA_ENABLE                 1951
#define IDC_ACIA_DEVICE                 1952
#define IDC_ACIA_LOCATION               1953
#define IDC_ACIA_INTERRUPT              1954

#define IDD_RS232USER_SETTINGS_DIALOG   1960
#define IDC_RS232USER_ENABLE            1961
#define IDC_RS232USER_DEVICE            1962
#define IDC_RS232USER_BAUDRATE          1963

#define IDD_RS232_SETTINGS_DIALOG       1970
#define IDC_RS232_DEVICE1               1971
#define IDC_RS232_DEVICE2               1972
#define IDC_RS232_DEVICE3               1973
#define IDC_RS232_DEVICE4               1974

#define IDD_C64KBD_MAPPING_SETTINGS_DIALOG 1980
#define IDC_C64KBD_MAPPING_SELECT_SYM   1981
#define IDC_C64KBD_MAPPING_SELECT_SYMDE 1982
#define IDC_C64KBD_MAPPING_SELECT_POS   1983
#define IDC_C64KBD_MAPPING_SYM          1984
#define IDC_C64KBD_MAPPING_SYMDE        1985
#define IDC_C64KBD_MAPPING_POS          1986
#define IDC_C64KBD_MAPPING_SYM_BROWSE   1987
#define IDC_C64KBD_MAPPING_SYMDE_BROWSE 1988
#define IDC_C64KBD_MAPPING_POS_BROWSE   1989
#define IDC_C64KBD_MAPPING_DUMP         1990

#define IDD_C128KBD_MAPPING_SETTINGS_DIALOG 2000
#define IDC_C128KBD_MAPPING_SELECT_SYM  2001
#define IDC_C128KBD_MAPPING_SELECT_POS  2002
#define IDC_C128KBD_MAPPING_SYM         2003
#define IDC_C128KBD_MAPPING_POS         2004
#define IDC_C128KBD_MAPPING_SYM_BROWSE  2005
#define IDC_C128KBD_MAPPING_POS_BROWSE  2006
#define IDC_C128KBD_MAPPING_DUMP        2007

#define IDD_VIC20KBD_MAPPING_SETTINGS_DIALOG 2010
#define IDC_VIC20KBD_MAPPING_SELECT_SYM 2011
#define IDC_VIC20KBD_MAPPING_SELECT_POS 2012
#define IDC_VIC20KBD_MAPPING_SYM        2013
#define IDC_VIC20KBD_MAPPING_POS        2014
#define IDC_VIC20KBD_MAPPING_SYM_BROWSE 2015
#define IDC_VIC20KBD_MAPPING_POS_BROWSE 2016
#define IDC_VIC20KBD_MAPPING_DUMP       2017

#define IDD_PETKBD_MAPPING_SETTINGS_DIALOG 2020
#define IDC_PETKBD_MAPPING_SELECT_UKSYM 2021
#define IDC_PETKBD_MAPPING_SELECT_UKPOS 2022
#define IDC_PETKBD_MAPPING_SELECT_GRSYM 2023
#define IDC_PETKBD_MAPPING_SELECT_GRPOS 2024
#define IDC_PETKBD_MAPPING_SELECT_DESYM 2025
#define IDC_PETKBD_MAPPING_SELECT_DEPOS 2026
#define IDC_PETKBD_MAPPING_UKSYM        2027
#define IDC_PETKBD_MAPPING_UKPOS        2028
#define IDC_PETKBD_MAPPING_GRSYM        2029
#define IDC_PETKBD_MAPPING_GRPOS        2030
#define IDC_PETKBD_MAPPING_DESYM        2031
#define IDC_PETKBD_MAPPING_DEPOS        2032
#define IDC_PETKBD_MAPPING_UKSYM_BROWSE 2033
#define IDC_PETKBD_MAPPING_UKPOS_BROWSE 2034
#define IDC_PETKBD_MAPPING_GRSYM_BROWSE 2035
#define IDC_PETKBD_MAPPING_GRPOS_BROWSE 2036
#define IDC_PETKBD_MAPPING_DESYM_BROWSE 2037
#define IDC_PETKBD_MAPPING_DEPOS_BROWSE 2038
#define IDC_PETKBD_MAPPING_DUMP         2039

#define IDD_PLUS4KBD_MAPPING_SETTINGS_DIALOG 2050
#define IDC_PLUS4KBD_MAPPING_SELECT_SYM 2051
#define IDC_PLUS4KBD_MAPPING_SELECT_POS 2052
#define IDC_PLUS4KBD_MAPPING_SYM        2053
#define IDC_PLUS4KBD_MAPPING_POS        2054
#define IDC_PLUS4KBD_MAPPING_SYM_BROWSE 2055
#define IDC_PLUS4KBD_MAPPING_POS_BROWSE 2056
#define IDC_PLUS4KBD_MAPPING_DUMP       2057

#define IDD_CBM2KBD_MAPPING_SETTINGS_DIALOG 2060
#define IDC_CBM2KBD_MAPPING_SELECT_UKSYM 2061
#define IDC_CBM2KBD_MAPPING_SELECT_UKPOS 2062
#define IDC_CBM2KBD_MAPPING_SELECT_GRSYM 2063
#define IDC_CBM2KBD_MAPPING_SELECT_GRPOS 2064
#define IDC_CBM2KBD_MAPPING_SELECT_DESYM 2065
#define IDC_CBM2KBD_MAPPING_SELECT_DEPOS 2066
#define IDC_CBM2KBD_MAPPING_UKSYM        2067
#define IDC_CBM2KBD_MAPPING_UKPOS        2068
#define IDC_CBM2KBD_MAPPING_GRSYM        2069
#define IDC_CBM2KBD_MAPPING_GRPOS        2070
#define IDC_CBM2KBD_MAPPING_DESYM        2071
#define IDC_CBM2KBD_MAPPING_DEPOS        2072
#define IDC_CBM2KBD_MAPPING_UKSYM_BROWSE 2073
#define IDC_CBM2KBD_MAPPING_UKPOS_BROWSE 2074
#define IDC_CBM2KBD_MAPPING_GRSYM_BROWSE 2075
#define IDC_CBM2KBD_MAPPING_GRPOS_BROWSE 2076
#define IDC_CBM2KBD_MAPPING_DESYM_BROWSE 2077
#define IDC_CBM2KBD_MAPPING_DEPOS_BROWSE 2078
#define IDC_CBM2KBD_MAPPING_DUMP         2079
 
#define IDM_FILE_EXIT                   40001
#define IDM_EXIT                        40001
#define IDM_ABOUT                       40002
#define IDM_PAUSE                       40003
#define IDM_AUTOSTART                   40004
#define IDM_RESET_HARD                  40005
#define IDM_RESET_SOFT                  40006
#define IDM_RESET_DRIVE8                40007
#define IDM_RESET_DRIVE9                40008
#define IDM_RESET_DRIVE10               40009
#define IDM_RESET_DRIVE11               40010
#define IDM_ATTACH_8                    40011
#define IDM_ATTACH_9                    40012
#define IDM_ATTACH_10                   40013
#define IDM_ATTACH_11                   40014
#define IDM_ATTACH_TAPE                 40015
#define IDM_DETACH_TAPE                 40016
#define IDM_DATASETTE_CONTROL           40017
#define IDM_DETACH_8                    40018
#define IDM_DETACH_9                    40019
#define IDM_DETACH_10                   40020
#define IDM_DETACH_11                   40021
#define IDM_DETACH_ALL                  40022
#define IDM_TOGGLE_SOUND                40023
#define IDM_TOGGLE_DOUBLESIZE           40024
#define IDM_TOGGLE_DOUBLESCAN           40025
#define IDM_TOGGLE_DRIVE_TRUE_EMULATION 40026
#define IDM_TOGGLE_VIDEOCACHE           40027
#define IDM_DRIVE_SETTINGS              40030
#define IDM_CART_ATTACH_CRT             40040
#define IDM_CART_ATTACH_8KB             40041
#define IDM_CART_ATTACH_16KB            40042
#define IDM_CART_ATTACH_AR              40043
#define IDM_CART_ATTACH_AT              40044
#define IDM_CART_ATTACH_EPYX            40045
#define IDM_CART_ATTACH_IEEE488         40046
#define IDM_CART_ATTACH_RR              40047
#define IDM_CART_ATTACH_SS4             40048
#define IDM_CART_ATTACH_SS5             40049
#define IDM_CART_ATTACH_IDE64           40050
#define IDM_CART_ATTACH_FUNCLO		40051
#define IDM_CART_ATTACH_FUNCHI		40052
#define IDM_CART_ATTACH_C1LO		40053
#define IDM_CART_ATTACH_C1HI		40054
#define IDM_CART_ATTACH_C2LO		40055
#define IDM_CART_ATTACH_C2HI		40056
#define IDM_CART_SET_DEFAULT            40058
#define IDM_CART_DETACH                 40059
#define IDM_CART_VIC20_8KB_2000         40060
#define IDM_CART_VIC20_8KB_6000         40061
#define IDM_CART_VIC20_8KB_A000         40062
#define IDM_CART_VIC20_4KB_B000         40063
#define IDM_CART_VIC20_16KB             40064
#define IDM_CART_VIC20_16KB_4000        40065
#define IDM_CART_ENABLE_EXPERT          40066
#define IDM_CART_MODE_OFF               40067
#define IDM_CART_MODE_PRG               40068
#define IDM_CART_MODE_ON                40069
#define IDM_TOGGLE_CART_RESET           40070
#define IDM_SNAPSHOT_LOAD               40080
#define IDM_SNAPSHOT_SAVE               40081
#define IDM_MEDIAFILE                   40082
#define IDM_EVENT_DIRECTORY             40083
#define IDM_EVENT_TOGGLE_RECORD         40084
#define IDM_EVENT_TOGGLE_PLAYBACK       40085
#define IDM_EVENT_START_MODE_SAVE       40086
#define IDM_EVENT_START_MODE_LOAD       40087
#define IDM_EVENT_START_MODE_RESET      40088
#define IDM_EVENT_START_MODE_PLAYBACK   40089
#define IDM_EVENT_SETMILESTONE          40090
#define IDM_EVENT_RESETMILESTONE        40091
#define IDM_SETTINGS_SAVE               40095
#define IDM_SETTINGS_LOAD               40096
#define IDM_SETTINGS_DEFAULT            40097
#define IDM_DEVICEMANAGER               40098
#define IDM_REFRESH_RATE_AUTO           40100
#define IDM_REFRESH_RATE_1              40101
#define IDM_REFRESH_RATE_2              40102
#define IDM_REFRESH_RATE_3              40103
#define IDM_REFRESH_RATE_4              40104
#define IDM_REFRESH_RATE_5              40105
#define IDM_REFRESH_RATE_6              40106
#define IDM_REFRESH_RATE_7              40107
#define IDM_REFRESH_RATE_8              40108
#define IDM_REFRESH_RATE_9              40109
#define IDM_REFRESH_RATE_10             40110
#define IDM_REFRESH_RATE_CUSTOM         40111
#define IDM_MAXIMUM_SPEED_200           40120
#define IDM_MAXIMUM_SPEED_100           40121
#define IDM_MAXIMUM_SPEED_50            40122
#define IDM_MAXIMUM_SPEED_20            40123
#define IDM_MAXIMUM_SPEED_10            40124
#define IDM_MAXIMUM_SPEED_NO_LIMIT      40125
#define IDM_MAXIMUM_SPEED_CUSTOM        40126
#define IDM_TOGGLE_WARP_MODE            40129
#define IDM_VICII_SETTINGS              40130
#define IDM_PET_SETTINGS                40131
#define IDM_CBM2_SETTINGS               40132
#define IDM_SYNC_FACTOR_PAL             40140
#define IDM_SYNC_FACTOR_NTSC            40141
#define IDM_SYNC_FACTOR_NTSCOLD         40142
#define IDM_JOY_SETTINGS                40143
#define IDM_SOUND_SETTINGS              40144
#define IDM_STATUS_WINDOW               40145
#define IDM_MONITOR                     40146
#define IDM_CART_FREEZE                 40149
#define IDM_SAVEQUICK                   40150
#define IDM_LOADQUICK                   40151
#define IDM_HELP                        40152
#define IDM_DATASETTE_CONTROL_START     40160
#define IDM_DATASETTE_CONTROL_STOP      40161
#define IDM_DATASETTE_CONTROL_FORWARD   40162
#define IDM_DATASETTE_CONTROL_REWIND    40163
#define IDM_DATASETTE_CONTROL_RECORD    40164
#define IDM_DATASETTE_CONTROL_RESET     40165
#define IDM_DATASETTE_RESET_COUNTER     40166
#define IDM_FLIP_ADD                    40170
#define IDM_FLIP_REMOVE                 40171
#define IDM_FLIP_NEXT                   40172
#define IDM_FLIP_PREVIOUS               40173
#define IDM_FLIP_LOAD                   40174
#define IDM_FLIP_SAVE                   40175
#define IDM_REU_SETTINGS                40180
#define IDM_TOGGLE_CRTCDOUBLESIZE       40181
#define IDM_TOGGLE_CRTCDOUBLESCAN       40182
#define IDM_TOGGLE_CRTCVIDEOCACHE       40183
#define IDM_SWAP_JOYSTICK               40184
#define IDM_TOGGLE_EMUID                40185
#define IDM_IEEE488                     40186
#define IDM_MOUSE                       40187
#define IDM_DATASETTE_SETTINGS          40188
#define IDM_TOGGLE_VDC64KB              40189
#define IDM_TOGGLE_VDC_DOUBLESIZE       40190
#define IDM_TOGGLE_VDC_DOUBLESCAN       40191
#define IDM_VIC_SETTINGS                40192
#define IDM_TOGGLE_VIRTUAL_DEVICES      40193
#define IDM_CONTRIBUTORS                40194
#define IDM_LICENSE                     40195
#define IDM_WARRANTY                    40196
#define IDM_CMDLINE                     40197
#define IDM_FULLSCREEN_SETTINGS         40198
#define IDM_TOGGLE_SAVE_SETTINGS_ON_EXIT 40199
#define IDM_TOGGLE_FULLSCREEN           40200
#define IDM_TOGGLE_CONFIRM_ON_EXIT      40201
#define IDM_SID_SETTINGS                40202
#define IDM_TOGGLE_IFUNCTIONROM         40205
#define IDM_IFUNCTIONROM_NAME           40206
#define IDM_TOGGLE_EFUNCTIONROM         40207
#define IDM_EFUNCTIONROM_NAME           40208
#define IDM_TOGGLE_FASTPAL              40209
#define IDM_VIDEO_SETTINGS              40210
#define IDM_PLUS4_SETTINGS              40211
#define IDM_RAM_SETTINGS                40212
#define IDM_TFE_SETTINGS                40213
#define IDM_TOGGLE_MAINCPU_TRACE        40216
#define IDM_TOGGLE_DRIVE0CPU_TRACE      40217
#define IDM_TOGGLE_DRIVE1CPU_TRACE      40218
#define IDM_TOGGLE_SCALE2X              40219
#define IDM_CUSTOM_SPEED                40220
#define IDM_PRINTER_SETTINGS            40221
#define IDM_C128_SETTINGS               40222
#define IDM_FORMFEED_PRINTERIEC4        40223
#define IDM_FORMFEED_PRINTERIEC5        40224
#define IDM_FORMFEED_PRINTERUSERPORT    40225
#define IDM_ROM_SETTINGS                40226
#define IDM_IDE64_SETTINGS              40227
#define IDM_ACIA_SETTINGS               40228
#define IDM_RS232USER_SETTINGS          40229
#define IDM_RS232_SETTINGS              40230
#define IDM_KEYBOARD_SETTINGS           40231
#define IDM_DEBUG_MODE_NORMAL           40240
#define IDM_DEBUG_MODE_SMALL            40241
#define IDM_DEBUG_MODE_HISTORY          40242
#define IDM_DEBUG_MODE_AUTOPLAY         40243

#define IDM_MON_OPEN                    42000
#define IDM_MON_SAVE                    42001
#define IDM_MON_PRINT                   42002
#define IDM_MON_STOP_DEBUG              42003
#define IDM_MON_STOP_EXEC               42004
#define IDM_MON_CURRENT                 42005
#define IDM_MON_STEP_INTO               42006
#define IDM_MON_STEP_OVER               42007
#define IDM_MON_SKIP_RETURN             42008
#define IDM_MON_GOTO_CURSOR             42009
#define IDM_MON_EVAL                    42010
#define IDM_MON_WND_EVAL                42011
#define IDM_MON_WND_REG                 42012
#define IDM_MON_WND_MEM                 42013
#define IDM_MON_WND_DIS                 42014
#define IDM_MON_WND_CONSOLE             42015
#define IDM_MON_COMPUTER                42016
#define IDM_MON_DRIVE8                  42017
#define IDM_MON_DRIVE9                  42018
#define IDM_MON_HELP                    42019
#define IDM_MON_CASCADE                 42020
#define IDM_MON_TILE_HORIZ              42021
#define IDM_MON_TILE_VERT               42022
#define IDM_MON_ARRANGE_ICONS           42023
#define IDM_MON_GOTO_PC                 42024
#define IDM_MON_GOTO_ADDRESS            42025
#define IDM_MON_SET_BP                  42026
#define IDM_MON_UNSET_BP                42027
#define IDM_MON_ENABLE_BP               42028
#define IDM_MON_DISABLE_BP              42029
#define IDM_WNDCHILD                    42100

#define WM_CONSOLE_INSERTLINE           (WM_USER)
#define WM_CONSOLE_CLOSED               (WM_USER+1)
#define WM_CONSOLE_RESIZED              (WM_USER+2)
#define WM_CONSOLE_ACTIVATED            (WM_USER+3)

#endif

