#!/bin/sh

#
# bin2c.sh - make a header file out of a binary file using od2c.sh
#
# Written by
#  Marco van den Heuvel <blackystardust68@yahoo.com>
#
# This file is part of VICE, the Versatile Commodore Emulator.
# See README for copyright notice.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
#  02111-1307  USA.
#

BINFILENAME=$1
HEADERFILENAME=$2
ARRAYNAME=$3
CROSS=$4
SHELL=$5
TOPSRCDIR=$6

echo Generating $HEADERFILENAME
if test x"$CROSS" = "xtrue"; then
    echo >$HEADERFILENAME "/* Autogenerated file, do not edit */"
    echo >>$HEADERFILENAME ""
    echo >>$HEADERFILENAME "$ARRAYNAME = {"
    od -Ax -v -t x1 -w8 $BINFILENAME >$HEADERFILENAME.tmp
    $SHELL $TOPSRCDIR/src/od2c.sh <$HEADERFILENAME.tmp >>$HEADERFILENAME
    echo >>$HEADERFILENAME "};"
    rm -f $HEADERFILENAME.tmp
else
    ./bin2c $BINFILENAME $HEADERFILENAME "$ARRAYNAME"
fi
