#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "global.h"

extern char vqr_error[],
            vqr_warning[];            

void t_code(char code)
{
  char *p;
  switch(code) {
    case 'V':              
              printf(VQREGISTER_VERSION);
              break;
    case 'E':
              t_printf(vqr_error, -2); 
              break;
    case 'W':
              global_f_warning();
              break;
    case 'D':
	      show_html_domains();
	      break;
    default:
              break;
  };
}

void g_code(char *id, int fd)
{
  char *r = NULL;

  r = f_global_par(id);

  t_printf(r, fd);
}

void t_printf(char *str, int outfd)
{  
  int ret = 0;

  if ((str) && (str[0])) {
     if (outfd == -2)
        printf("%s", str); 
     else if (outfd != -1) {
        ret = write(outfd, (char *)str, strlen(str));
        if (ret < 1) {
           global_warning("Message spool failed");
           t_open(T_FAILURE);
        }
     }
  }
}

void t_open(char *filename)
{
  FILE *stream = NULL;
  char *p = NULL, b[MAX_TEMPLATE_LINE_LENGTH], t = 0, *h = NULL, *d = NULL;

  printf("Content-type: text/html\n\n");

  stream = fopen(filename, "r");
  if (stream == NULL)
     tfatal();  

  while(1) {
     memset((char *)b, 0, MAX_TEMPLATE_LINE_LENGTH);
     fgets(b, MAX_TEMPLATE_LINE_LENGTH, stream);

     if (feof(stream))
        break;

     for (p = b; *p; p++) {
         if ((*p == '$') && (*(p + 1) == '-')) {
            t = *(p + 4);
            *(p + 4) = '\0';
            g_code(p + 2, -2);
            *(p + 4) = t;
            p += 3;
         }

         else if ((*p == '%') && (*(p + 1) == '-')) {
            t_code(*(p + 2));
            p += 2;
         }

         else if ((*p == '&') && (*(p + 1) == '-')) {
            /*
               This format is a little more funky.

               &-XX(data)
            */

            p += 2;
            h = (p + 2);

            if (*h == '(') {
               *h++ = '\0';

               for (d = h; *d; d++) {
                   if (*d == ')')
                      break;
               }
 
               if (*d == ')') {
                  *d = '\0';

                  a_code(p, h);

                  p = d;
               }
            }
         }

         else if ((*p == '^') && (*(p + 1) == '-')) {
            /*
               !-XX(data)
            */

            p += 2;
            h = (p + 2);

            if (*h == '(') {
               *h++ = '\0';

               for (d = h; *d; d++) {
                   if (*d == ')')
                      break;
               }
 
               if (*d == ')') {
                  *d = '\0';

                  p_code(p, h);

                  p = d;
               }
            }
         }

         else
            putchar(*p);
     }
  }

  fclose(stream);
  
  exit(0);
}

void et_open(int outfd, char *filename)
{
  int ret = 0;
  FILE *stream = NULL;
  char *p = NULL, b[MAX_TEMPLATE_LINE_LENGTH], t = 0;

  stream = fopen(filename, "r");
  if (stream == NULL) {
     global_warning("Missing templates");
     t_open(T_FAILURE);
  }

  while(1) {
     memset((char *)b, 0, MAX_TEMPLATE_LINE_LENGTH);
     fgets(b, MAX_TEMPLATE_LINE_LENGTH, stream);

     if (feof(stream))
        break;

     for (p = b; *p; p++) {
         if ((*p == '$') && (*(p + 1) == '-')) {
            t = *(p + 4);
            *(p + 4) = '\0';
            g_code(p + 2, outfd);
            *(p + 4) = t;
            p += 3;
         }

         else {
            ret = write(outfd, &(*p), 1);
            if (ret < 1) {
               global_warning("Message spool failed");
               t_open(T_FAILURE);
            }
         }
     }
  }

  fclose(stream);
}

void a_code(char *id, char *data)
{
  char *ret = NULL;

  ret = f_global_par(id);
  if (!ret) {    
     if (!(strcmp(data, "")))
        printf("SELECTED");

     return;
  } 

  if (!(strcasecmp(ret, data)))
     printf("SELECTED");
}

void p_code(char *id, char *data)
{
  char *ret = NULL;

  ret = f_global_par(id);
  if (!ret) {
     if (!(strcmp(data, "")))
        printf("CHECKED");

     return;
  }

  if (!(strcasecmp(ret, data)))
     printf("CHECKED");
}
