/*
Copyright (C) 2007 Bastian Suter ("Sable")

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/************************************************************************/
/* BattlEye Server code                                                 */
/************************************************************************/

#include "../qcommon/qcommon.h"
#include "../qcommon/sys_library.h"
#include "server.h"


#ifdef BATTLEYE

#if defined(_M_IX86) || defined(__i386__)
#undef ARCH
#define ARCH "x86"
#elif defined(_M_AMD64) || defined(__x86_64__)
#undef ARCH
#define ARCH "x64"
#endif

int FS_AbsoluteFileExists( const char *filename );


static void SV_BE_SendPacket(int pid, void *packet, size_t len)
{
	MSG_WriteByte(&svs.clients[pid].be.outMsg, svc_battleye);
	MSG_WriteShort(&svs.clients[pid].be.outMsg, len);
	MSG_CopyData(&svs.clients[pid].be.outMsg, packet, len);
}

static void SV_BE_KickPlayer(int pid, char *reason)
{
	SV_DropClient(&svs.clients[pid], DROP_TYPE_NORECONNECT, "BattlEye: " S_COLOR_YELLOW "%s", reason);
}

static void SV_BE_PrintMessage(char *message)
{
	Com_Printf("BattlEye Server: %s\n", message);
}


void SV_BE_Load(void)
{
	if (svbe.module)
		return;

	if (FS_AbsoluteFileExists(va("%s/BattlEye/BEServer_" ARCH LIB_SUFFIX, FS_WriteDirectory())) == -1)
		FS_CopyBaseFile("BattlEye/BEServer_" ARCH LIB_SUFFIX, "BattlEye/BEServer_" ARCH LIB_SUFFIX);

	if ((svbe.module = Sys_Library_Open(va("%s/BattlEye/BEServer_" ARCH LIB_SUFFIX, FS_WriteDirectory()))))
	{
		// the BE "Init" export
		qbyte (*Init)(char *, int, void (*)(char *), void (*)(int, void *, size_t), void (*)(int, char *), qbyte (**)(void), void (**)(char *), void (**)(int, char *, void *), void (**)(int), void (**)(int, void *, size_t));
		if ((Init = Sys_Library_ProcAddress(svbe.module, "Init")))
		{
			if (Init(va("%.3f", VERSION), sv_maxclients->integer, &SV_BE_PrintMessage, &SV_BE_SendPacket, &SV_BE_KickPlayer, &svbe.Run, &svbe.Command, &svbe.AddPlayer, &svbe.RemovePlayer, &svbe.NewPacket))
			{
				int i;
				for (i = 0; i < sv_maxclients->integer; i++)
				{
					if (svs.clients[i].state == CS_SPAWNED && !(svs.clients[i].edict && (svs.clients[i].edict->r.svflags & SVF_FAKECLIENT)))
						svbe.AddPlayer( i, svs.clients[i].name, NULL );
				}
			}
			else
			{
				SV_BE_Unload();
				Com_Error(ERR_DROP, "Failed to initialize BattlEye Server");
			}
		}
		else
		{
			SV_BE_Unload();
			Com_Error(ERR_DROP, "Failed to get BattlEye Server procedure. %s", Sys_Library_ErrorString());
		}
	}
	else
		Com_Error(ERR_DROP, "Failed to load BattlEye Server. %s", Sys_Library_ErrorString());
}

void SV_BE_Unload(void)
{
	if (!svbe.module)
		return;

	if (Sys_Library_Close(svbe.module))
		svbe.module = NULL;
	else
		Com_Error(ERR_DROP, "Failed to unload BattlEye Server. %s", Sys_Library_ErrorString());
}

void SV_BEServerCmd_f(void)
{
	if (svbe.module && Cmd_Argc() > 1)
		svbe.Command(Cmd_Args());
}

#endif // BATTLEYE
