/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "ui_local.h"
#include "../game/g_gametype_ca.h"

/*
=======================================================================

MAIN MENU

=======================================================================
*/
static menuframework_s	s_ca_menu;

static void M_CA_PlayerClassFuncGrunt( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, va("cmd playerclass %i", CA_PLAYERCLASS_GRUNT) );
	M_PopMenu();
}

static void M_CA_PlayerClassFuncCamper( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, va("cmd playerclass %i", CA_PLAYERCLASS_CAMPER) );
	M_PopMenu();
}

static void M_CA_PlayerClassFuncSpammer( menucommon_t *menuitem )
{
	trap_Cmd_ExecuteText( EXEC_APPEND, va("cmd playerclass %i", CA_PLAYERCLASS_SPAMMER) );
	M_PopMenu();
}

// copy from ui_game.c: void M_Game_Init( void )
static void M_CA_Init( void )
{
	int yoffset = 0;
	menucommon_t *menuitem;

	s_ca_menu.nitems = 0;

	menuitem = UI_InitMenuItem( "m_ca_title1", "SELECT CLASS", 0, yoffset, MTYPE_SEPARATOR, ALIGN_CENTER_TOP, uis.fontSystemBig, NULL );
	Menu_AddItem( &s_ca_menu, menuitem );
	yoffset += 2 * trap_SCR_strHeight( menuitem->font );

	// FIXME: refine menu item and placement
	menuitem = UI_InitMenuItem( "m_ca_playerclass_grunt", "Grunt", 0, yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_CA_PlayerClassFuncGrunt );
	Menu_AddItem( &s_ca_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_ca_playerclass_camper", "Camper", 0, yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_CA_PlayerClassFuncCamper );
	Menu_AddItem( &s_ca_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_ca_playerclass_spammer", "Spammer", 0, yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_CA_PlayerClassFuncSpammer );
	Menu_AddItem( &s_ca_menu, menuitem );

	yoffset += 1.5 * trap_SCR_strHeight( menuitem->font );

	menuitem = UI_InitMenuItem( "m_ca_cancel", "cancel", 0, yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_genericBackFunc );
	Menu_AddItem( &s_ca_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	Menu_Center( &s_ca_menu );
	Menu_Init( &s_ca_menu );

	Menu_SetStatusBar( &s_ca_menu, NULL );
}

static void M_CA_Draw( void )
{
	Menu_AdjustCursor( &s_ca_menu, 1 );
	Menu_Draw( &s_ca_menu );
}

static const char *M_CA_Key( int key )
{
	return Default_MenuKey( &s_ca_menu, key );
}

static const char *M_CA_CharEvent( int key )
{
	return Default_MenuCharEvent( &s_ca_menu, key );
}

void M_Menu_CA_f( void )
{
	M_CA_Init();
	M_PushMenu( &s_ca_menu, M_CA_Draw, M_CA_Key, M_CA_CharEvent );
}
