/*
   Copyright (C) 2007 Will Franklin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#include "matchmaker.h"
#include "mm_hash.h"

mempool_t *auth_mempool;

//=================
// Auth_Init
// Initialize auth system
//=================
void Auth_Init( void )
{
	auth_mempool = Mem_AllocPool( NULL, "Auth system" );
}

//=================
// Auth_Shutdown
// Cleanup the auth system
//=================
void Auth_Shutdown( void )
{
	Mem_FreePool( &auth_mempool );
}

//=================
// Auth_AuthenticateUser
// Check if details are valid and return id if so
//=================
int Auth_AuthenticateUser( const char *email, const char *pass )
{
	char query[MAX_QUERY_SIZE];
	MYSQL_RES *res;
	MYSQL_ROW row;
	int uid;
	char *pass2;
	char eemail[MAX_EMAIL_LENGTH * 2 + 1]; // worst cast scenario, all chars escaped

	if( !db_handle )
		Com_Error( ERR_DROP, "Auth_AuthenticateUser: No database connection initialized" );

	if( !pass || !email || !*pass || !*email )
		return 0;

	// check pass validity
	if( strlen( pass ) != HASH_SIZE )
		return 0;

	pass2 = ( char * )pass;
	do
	{
		// pass should only contain alphanumeric characters
		if( !isalpha( *pass2 ) && !isdigit( *pass2 ) )
			return 0;
	}
	while( ++pass2 );


	DB_EscapeString( eemail, email, sizeof( eemail ) );

	Q_snprintfz( query, sizeof( query ), "SELECT `id` FROM `%s` WHERE `email`='%s' && `password`='%s' LIMIT 1", DBTABLE_USERS, eemail, pass );

	if( DB_Query( db_handle, query ) != DB_SUCCESS )
		return 0;

	if( DB_FetchResult( db_handle, &res ) != DB_SUCCESS )
		return 0;

	if( DB_FetchRow( res, &row, 0 ) != DB_SUCCESS )
		return 0;

	uid = atoi( row[0] );
	DB_FreeResult( &res );

	return uid;
}

//=================
// Auth_CheckUserExistsById
//=================
qboolean Auth_CheckUserExistsById( const int uid )
{
	char query[MAX_QUERY_SIZE];
	MYSQL_RES *res;
	MYSQL_ROW row;
	int count;

	if( !db_handle )
		Com_Error( ERR_DROP, "Auth_CheckUser: No database connection initialized" );

	if( !uid )
		return qfalse;

	Q_snprintfz( query, sizeof( query ), "SELECT COUNT(*) FROM `%s` WHERE `id`='%d' LIMIT 1", DBTABLE_USERS, uid );

	if( DB_Query( db_handle, query ) != DB_SUCCESS )
		return qfalse;

	if( DB_FetchResult( db_handle, &res ) != DB_SUCCESS )
		return qfalse;

	if( DB_FetchRow( res, &row, 0 ) != DB_SUCCESS )
	{
		DB_FreeResult( &res );
		return qfalse;
	}

	count = atoi( row[0] );
	DB_FreeResult( &res );

	return ( qboolean ) count;
}
