/*
   Copyright (C) 2007 Will Franklin.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 */

#include "../game/q_shared.h"
#include "mm_supported.h"

mm_supported_items_t supported_items[] =
{
	/*{ "eb", 0.142f },
	   { "gb", 0.142f },
	   { "gl", 0.142f },
	   { "lg", 0.142f },
	   { "pg", 0.142f },
	   { "rg", 0.142f },
	   { "rl", 0.142f },*/
	{ "dg", 0.05f }, // damage given
	{ "dt", -0.05f }, // damage taken

	{ NULL, 0.0f }
};

// maxclients will be defined by us atm, maybe user defined later on
mm_supported_gametypes_t supported_gametypes[] =
{
	{
		"ca", // short name
		GAMETYPE_CA, // tag
		8, // max clients
		10, // scorelimit
		0.0f, // timelimit
		qfalse // falldamage
	},
	{
		"ctf", // short name
		GAMETYPE_CTF, // tag
		8, // max clients
		10, // scorelimit
		0.0f, // timelimit
		qtrue // falldamage
	},
	{
		"da", // short name
		GAMETYPE_DA, // tag
		4, // max clients
		10, // scorelimit
		0.0f, // timelimit
		qfalse // falldamage
	},
	{
		"dm", // short name
		GAMETYPE_DM, // tag
		8, // max clients
		0, // scorelimit
		10.0f, // timelimit
		qtrue // falldamage
	},
	{
		"duel", // short name
		GAMETYPE_DUEL, // tag
		2, // max clients
		0, // scorelimit
		5.0f, // timelimit
		qtrue // falldamage
	},
	{
		"tdm", // short name
		GAMETYPE_TDM, // tag
		8, // max clients
		0, // scorelimit
		10.0f, // timelimit
		qtrue // falldamage
	},

	// EOL
	{ NULL }
};


//================
// MM_CheckItemExists
// Check item exists
//================
qboolean MM_CheckItemExists( const char *name )
{
	mm_supported_items_t *item;
	for( item = supported_items; item->short_name; item++ )
	{
		if( !strcmp( item->short_name, name ) )
			return qtrue;
	}

	return qfalse;
}

//================
// MM_GetGameTypeTagByName
// Returns gametype tag for specified name
//================
int MM_GetGameTypeTagByName( const char *name )
{
	mm_supported_gametypes_t *gametype;

	for( gametype = supported_gametypes; gametype->short_name; gametype++ )
	{
		if( !strcmp( gametype->short_name, name ) )
			return gametype->tag;
	}

	return -1;
}

//================
// MM_GetGameTypeNameByTag
// Returns the gametype name for the corresponding tag
//================
char *MM_GetGameTypeNameByTag( int tag )
{
	mm_supported_gametypes_t *gametype;

	for( gametype = supported_gametypes; gametype->short_name; gametype++ )
	{
		if( gametype->tag == tag )
			return gametype->short_name;
	}

	return NULL;
}

//================
// MM_GetGameTypeInfo
// returns information about gametype
//================
void MM_GetGameTypeInfo( int tag, int *maxclients, int *scorelimit, float *timelimit, qboolean *falldamage )
{
	mm_supported_gametypes_t *gametype;

	for( gametype = supported_gametypes; gametype->short_name; gametype++ )
	{
		if( gametype->tag == tag )
			break;
	}

	if( maxclients ) *maxclients = gametype ? gametype->maxclients : 0;
	if( scorelimit ) *scorelimit = gametype ? gametype->scorelimit : 0;
	if( timelimit ) *timelimit = gametype ? gametype->timelimit : 0;
	if( falldamage) *falldamage = gametype ? gametype->falldamage : 0;
}
