; Script generated by the HM NIS Edit Script Wizard.
RequestExecutionLevel user

!include x64.nsh
!include WordFunc.nsh
!insertmacro VersionCompare
!include LogicLib.nsh

SetCompressor /SOLID lzma

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "OpenTK"
!define PRODUCT_VERSION "1.0" ; To be replaced by Build.exe
;!define PRODUCT_VERSION_REVISION "{{revision}}"  ; To be replaced by Build.exe
;!define PRODUCT_VERSION_EXTRA "{{extra}}" ; To be replaced by Build.exe
!define PRODUCT_PUBLISHER "The Open Toolkit team"
!define PRODUCT_WEB_SITE "http://www.opentk.com"
!define PRODUCT_UNINST_KEY "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define DOTNET20_PUBLIC_ASSEMBLIES_KEY "SOFTWARE\Microsoft\.NETFramework\v2.0.50727\AssemblyFoldersEx\${PRODUCT_NAME} ${PRODUCT_VERSION}"

!define MULTIUSER_EXECUTIONLEVEL User
!define MULTIUSER_INSTALLMODE_DEFAULT_CURRENTUSER
!define MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY "SHELL_CONTEXT"
!define MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_VALUENAME "InstallDir"
!define MULTIUSER_INSTALLMODE_INSTDIR_REGISTRY_KEY "SHELL_CONTEXT"
!define MULTIUSER_INSTALLMODE_INSTDIR_REGISTRY_VALUENAME "InstallDir"
!define MULTIUSER_INSTALLMODE_INSTDIR "${PRODUCT_NAME}\${PRODUCT_VERSION}"
;!include MultiUser.nsh ; Doesn't really do what we need to (goes to AppData instead of Documents, no x64 support)

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "..\..\Source\Examples\Resources\App.ico"
!define MUI_UNICON "..\..\Source\Examples\Resources\App.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
;!insertmacro MUI_PAGE_WELCOME
; License page;
!insertmacro MUI_PAGE_LICENSE "..\..\Documentation\License.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI END ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "opentk.exe"
InstallDir "${MULTIUSER_INSTALLMODE_INSTDIR}"
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  StrCpy $INSTDIR "$DOCUMENTS\${MULTIUSER_INSTALLMODE_INSTDIR}"
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

; The "" makes the section hidden.
Section "" SecUninstallPrevious

    Call UninstallPrevious

SectionEnd

Function UninstallPrevious

    ; Check for uninstaller.
    ReadRegStr $R0 ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString"
    ReadRegStr $R1 ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}" "InstallDir"

    ${If} $R0 == ""
        Goto Done
    ${EndIf}

    DetailPrint "Removing previous installation."

    ; Run the uninstaller silently.
    ; The "if" is necessary becaused older installer versions
    ; did not set "InstallDir".
    CopyFiles "$R0" "$TEMP\uninst.exe"
    ${If} $R1 != ""
      ExecWait '$TEMP\uninst.exe /S _?=$R1'
    ${Else}
      Push $R0
      Call GetParent
      Pop $R0
      ExecWait '$TEMP\uninst.exe /S _?=$R0'
    ${EndIf}

    Done:
    
FunctionEnd

 ; GetParent
 ; input, top of stack  (e.g. C:\Program Files\Poop)
 ; output, top of stack (replaces, with e.g. C:\Program Files)
 ; modifies no other variables.
 ;
 ; Usage:
 ;   Push "C:\Program Files\Directory\Whatever"
 ;   Call GetParent
 ;   Pop $R0
 ;   ; at this point $R0 will equal "C:\Program Files\Directory"
 Function GetParent
 
  Exch $R0
  Push $R1
  Push $R2
  Push $R3
 
  StrCpy $R1 0
  StrLen $R2 $R0
 
  loop:
    IntOp $R1 $R1 + 1
    IntCmp $R1 $R2 get 0 get
    StrCpy $R3 $R0 1 -$R1
    StrCmp $R3 "\" get
  Goto loop

  get:
    StrCpy $R0 $R0 -$R1
 
    Pop $R3
    Pop $R2
    Pop $R1
    Exch $R0
 
FunctionEnd

Section "Core library" SEC01
  SectionIn RO
  
  ${If} $INSTDIR == $PROGRAMFILES
    ${OrIf} $INSTDIR == $DOCUMENTS
    ${OrIf} $INSTDIR == $DESKTOP
    ${OrIf} $INSTDIR == $WINDIR
    ${OrIf} $INSTDIR == $SYSDIR
    ${OrIf} $INSTDIR == $PROFILE
    MessageBox MB_OK "Cannot install directly under $INSTDIR. Please specify a subfolder."
    Abort
  ${EndIf}

  SetOutPath $INSTDIR
  File /r /x *.vshost.exe /x *.vshost.exe.manifest /x *.log ..\..\Binaries
  File /r /x .svn /x obj /x Source /x Source\*.* ..\..\Documentation
  SetOutPath $INSTDIR\Source\Examples
  File /r /x .svn /x obj /x *.snk /x *.user /x *.pidb /x html /x latex /x OpenTK*.xml ..\..\Source\Examples
SectionEnd

Section "Source code" SEC02
  SetOutPath $INSTDIR
  File /r /x .svn /x obj /x *.snk /x *.user /x *.pidb /x html /x latex /x OpenTK*.xml ..\..\Source
  File /r /x .svn ..\..\*.csproj
  File ..\..\*.sln
  File ..\..\OpenTK.snk
  File /r /x .svn /x obj /x opentk /x opentk-actual.* /x *.exe /x *.msi /x *.deb /x *.rpm /x *.zip ..\..\Installers
SectionEnd

Section "OpenAL drivers" SEC03
  SetOutPath $INSTDIR\Installers\Dependencies
  NSISdl::download /TIMEOUT=5000 http://www.opentk.net/files/dependencies/win32/oalinst.exe oalinst.exe
  NSISdl::download /TIMEOUT=5000 http://www.opentk.net/files/dependencies/win32/oalinst-license.txt oalinst-license.txt
  ExecShell "open"  '"$INSTDIR\Installers\Dependencies\oalinst.exe"' /S
SectionEnd

Section "NShader plugin (VS2010)" SEC04
  SetOutPath $INSTDIR\Installers\Dependencies
  NSISdl::download /TIMEOUT=5000 http://www.opentk.net/files/dependencies/win32/NShaderVS2010.vsix NShaderVS2010.vsix
  NSISdl::download /TIMEOUT=5000 http://www.opentk.net/files/dependencies/win32/nshader-license.txt nshader-license.txt
  ExecShell "open" '"$INSTDIR\Installers\Dependencies\NShaderVS2010.vsix"'
SectionEnd

Section "NShader plugin (VS2008)" SEC05
  SetOutPath $INSTDIR\Installers\Dependencies
  NSISdl::download /TIMEOUT=5000 http://www.opentk.net/files/dependencies/win32/NShaderVS2008.msi NShaderVS2008.msi
  NSISdl::download /TIMEOUT=5000 http://www.opentk.net/files/dependencies/win32/nshader-license.txt nshader-license.txt
  ExecShell "open" '"$INSTDIR\Installers\Dependencies\NShaderVS2008.msi"'
SectionEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateDirectory "$SMPROGRAMS\OpenTK"
  
  SetOutPath "$INSTDIR\Binaries\OpenTK\Release" ; Make sure the working directory is correct
  CreateShortCut "$SMPROGRAMS\OpenTK\OpenTK Example Browser.lnk" "$INSTDIR\Binaries\OpenTK\Release\Examples.exe"
  SetOutPath $INSTDIR
  
  CreateShortCut "$SMPROGRAMS\OpenTK\Function Reference (PDF).lnk" "$INSTDIR\Documentation\Reference.pdf"
  CreateShortCut "$SMPROGRAMS\OpenTK\Project Manual (PDF).lnk" "$INSTDIR\Documentation\Manual.pdf"
  ;CreateShortCut "$SMPROGRAMS\OpenTK\Release Notes.lnk" "$INSTDIR\Documentation\Release.txt"
  ;CreateShortCut "$SMPROGRAMS\OpenTK\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
SectionEnd

Section -Post
  ${If} ${RunningX64}
    SetRegView 64
  ${EndIf}
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}" "InstallDir" "$INSTDIR"
  WriteRegStr ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  WriteRegStr ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${DOTNET20_PUBLIC_ASSEMBLIES_KEY}" "" "$INSTDIR\Binaries\OpenTK\Release"
SectionEnd

LangString DESC_Section1 ${LANG_ENGLISH} "Installs the Open Toolkit library, documentation and samples."
LangString DESC_Section2 ${LANG_ENGLISH} "Installs the source code for the Open Toolkit library."
LangString DESC_Section3 ${LANG_ENGLISH} "Installs OpenAL sound drivers from Creative Inc. Required for OpenAL support."
LangString DESC_Section4 ${LANG_ENGLISH} "Adds support for GLSL syntax highlighting to Visual Studio 2010. Requires Professional edition or higher."
LangString DESC_Section5 ${LANG_ENGLISH} "Adds support for GLSL syntax highlighting to Visual Studio 2008. Requires Professional edition or higher."

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} $(DESC_Section1)
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} $(DESC_Section2)
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} $(DESC_Section3)
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} $(DESC_Section4)
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC05} $(DESC_Section5)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

Function un.onUninstSuccess
  HideWindow
FunctionEnd

Function un.onInit
  !insertmacro MUI_UNGETLANGUAGE
  IfSilent +3
    MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you wish to completely uninstall $(^Name) and all of its components?" IDYES +2
    Abort
FunctionEnd

Section Uninstall
  ${If} ${RunningX64}
    SetRegView 64
  ${EndIf}

  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"

  RMDir /r "$SMPROGRAMS\OpenTK"

  Delete "$INSTDIR\*.sln"
  Delete "$INSTDIR\Build.exe"
  Delete "$INSTDIR\*.log"
  RMDir /r "$INSTDIR\Installers"
  RMDir /r "$INSTDIR\Source"
  RMDir /r "$INSTDIR\Documentation"
  RMDir /r "$INSTDIR\Binaries"
  RMDir "$INSTDIR"


  DeleteRegKey ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey ${MULTIUSER_INSTALLMODE_DEFAULT_REGISTRY_KEY} "${DOTNET20_PUBLIC_ASSEMBLIES_KEY}"
  SetAutoClose true
SectionEnd
