/***********************************************************************
 * Permission is hereby granted to any individual or institution       *
 * for use, copying, or redistribution of the AV2XGobi C code          *
 * and associated documentation, provided such code and documentation  *
 * are not sold for profit and the following copyright notice is       *
 * retained in the code and documentation:                             *
 *                                                                     *
 *   Copyright (c) 1995 Iowa State University                          *
 *                                                                     *
 * We encourage you to share questions, comments and modifications.    *
 *                                                                     *
 *   Juergen Symanzik (symanzik@iastate.edu)                           *
 *   Dianne Cook (dicook@iastate.edu)                                  *
 *   James J. Majure (majure@iastate.edu)                              *
 *   Martin Schneider (maschn@informatik.uni-marburg.de)               *
 *                                                                     *
 * The code in this file was generated by ESRI, using rpcgen.          *
 * It has been modified to provide the functionality required for      *
 * the AV2XGOBI link.                                                  *
 *                                                                     *
 ***********************************************************************/

/* @(#)aiserver.x	1.1 4/28/94 10:19:11 */

/* !!!MS!!! */
#ifdef DCE_RPC_USED

#define PROGINTERN
#include "rpc_vars.h"

void wait_for_rpcs(int wait_time)
{
  /* Synchronize with the other p-Thread */
  /* Free mutex (Test for RPC) */
  pthread_mutex_unlock(&mutex);
  
  sleep(wait_time);

  /* Lock mutex again (No RPC possible) */
  pthread_mutex_lock(&mutex);
}

void dce_rpc_server_listen()
{
    unsigned32 status;

    rpc_server_listen(cMaxCalls,&status);
    CHECK_DCE_ERROR(status,ABORT);

    /* Will never happen, but ... */
    rpc_server_unregister_if(xgobi_goes_dce_v1_0_s_ifspec,0,&status);
    CHECK_DCE_ERROR(status,ABORT);
    rpc_ep_unregister(xgobi_goes_dce_v1_0_s_ifspec,pbvBindings,0,&status);
    CHECK_DCE_ERROR(status,ABORT);
    rpc_binding_vector_free(&pbvBindings,&status);
    CHECK_DCE_ERROR(status,ABORT);
}

void dce_rpc_server_main ()
{
    unsigned32 status;
    int ret;

    strcpy(pszProtocolSequence,"ncacn_ip_tcp");
    pszEndpoint = NULL;
    cMaxCalls = 1;
    pbvBindings = NULL;

    pthread_mutex_init(&mutex,pthread_mutexattr_default);
    /* No RPCs now! */
    pthread_mutex_lock(&mutex);

    /* Initialize DCE RPC */
    rpc_server_use_protseq(pszProtocolSequence,cMaxCalls,&status);
    CHECK_DCE_ERROR(status,ABORT);
    rpc_server_inq_bindings(&pbvBindings,&status);
    CHECK_DCE_ERROR(status,ABORT);
    rpc_ep_register(xgobi_goes_dce_v1_0_s_ifspec,pbvBindings,0,0,&status);
    CHECK_DCE_ERROR(status,ABORT);
    rpc_server_register_if(xgobi_goes_dce_v1_0_s_ifspec,0,0,&status);
    CHECK_DCE_ERROR(status,ABORT);

/* p-Thread to rpc_server_listen */
    ret = pthread_create(&t_handle,pthread_attr_default,
            (void *(*)(void *)) dce_rpc_server_listen,NULL);
}

#endif

#ifdef RPC_USED

#include <stdio.h>
#include <rpc/rpc.h>
#include "rpc_server.h"

#define PROGINTERN
#include "rpc_vars.h"

void wait_for_rpcs(int wait_time)
{
  fd_set readfds,
         writefds,
         exceptfds;
  struct timeval timeout;
  int i;

  FD_ZERO (&readfds);
  FD_ZERO (&writefds);
  FD_ZERO (&exceptfds);

  timeout.tv_sec = 0;
  timeout.tv_usec = 100;

  for (i = 0; i < howmany (FD_SETSIZE, NFDBITS); i++)
    readfds.fds_bits[i] = svc_fdset.fds_bits[i];

  select (FD_SETSIZE, &readfds, &writefds, &exceptfds, &timeout);
  svc_getreqset (&readfds);
}

unsigned long server_prognum;
unsigned long server_vernum;


static void aiserver_1();


void rpc_server_main (sv_prognum, sv_vernum)

unsigned long sv_prognum;
unsigned long sv_vernum;

{
  register SVCXPRT *transp;

  fd_set readfds,
         writefds,
         exceptfds;

  static int firsttime = 1;

  if (! firsttime)
    return;

        server_prognum = sv_prognum;
        server_vernum = sv_vernum;

	(void) pmap_unset(sv_prognum, sv_vernum);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		fprintf(stderr, "cannot create udp service.");
		exit(1);
	}

	if (!svc_register(transp, sv_prognum, sv_vernum, aiserver_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (sv_prognum, sv_vernum, udp).");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		fprintf(stderr, "cannot create tcp service.");
		exit(1);
	}

	if (!svc_register(transp, sv_prognum, sv_vernum, aiserver_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (sv_prognum, sv_vernum, tcp).");
		exit(1);
	}

  firsttime = 0;

/*	svc_run();
	fprintf(stderr, "svc_run returned");
	exit(1); */
/*
  typedef struct fd_set {
          fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
  } fd_set;
*/

	/* NOTREACHED */
}



bool_t
xdr_strngrec(xdrs, objp)
        XDR *xdrs;
        strngrec *objp;

{
        if (!xdr_string(xdrs, &objp->retstr, 1024)) {
                return (FALSE);
        }

        return (TRUE);
}



static void
aiserver_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;

{
	union {
		char *procedure1_1_arg;
		char *procedure2_1_arg;
		char *procedure3_1_arg;
		char *procedure4_1_arg;
		char *procedure5_1_arg;
		char *procedure6_1_arg;
		char *procedure7_1_arg;
		char *procedure8_1_arg;
		char *procedure9_1_arg;
		char *procedure10_1_arg;
		char *procedure11_1_arg;
		char *procedure12_1_arg;
		char *procedure13_1_arg;
		char *procedure14_1_arg;
		char *procedure15_1_arg;
		char *procedure16_1_arg;
		char *procedure17_1_arg;
		char *procedure18_1_arg;
		char *procedure19_1_arg;
		char *procedure20_1_arg;
		char *procedure21_1_arg;
		char *procedure22_1_arg;
		char *procedure23_1_arg;
		char *procedure24_1_arg;
		char *procedure25_1_arg;
		char *procedure26_1_arg;
		char *procedure27_1_arg;
		char *procedure28_1_arg;
		char *procedure29_1_arg;
		char *procedure30_1_arg;
		char *procedure31_1_arg;
		char *procedure32_1_arg;
		char *procedure33_1_arg;
		char *procedure34_1_arg;
		char *procedure35_1_arg;
		char *procedure36_1_arg;
		char *procedure37_1_arg;
		char *procedure38_1_arg;
		char *procedure39_1_arg;
		char *procedure40_1_arg;
		char *procedure41_1_arg;
		char *procedure42_1_arg;
		char *procedure43_1_arg;
		char *procedure44_1_arg;
		char *procedure45_1_arg;
		char *procedure46_1_arg;
		char *procedure47_1_arg;
		char *procedure48_1_arg;
		char *procedure49_1_arg;
		char *procedure50_1_arg;
		char *procedure51_1_arg;
		char *procedure52_1_arg;
		char *procedure53_1_arg;
		char *procedure54_1_arg;
		char *procedure55_1_arg;
		char *procedure56_1_arg;
		char *procedure57_1_arg;
		char *procedure58_1_arg;
		char *procedure59_1_arg;
		char *procedure60_1_arg;
		char *procedure61_1_arg;
		char *procedure62_1_arg;
		char *procedure63_1_arg;
		char *procedure64_1_arg;
		char *procedure65_1_arg;
		char *procedure66_1_arg;
		char *procedure67_1_arg;
		char *procedure68_1_arg;
		char *procedure69_1_arg;
		char *procedure70_1_arg;
		char *procedure71_1_arg;
		char *procedure72_1_arg;
		char *procedure73_1_arg;
		char *procedure74_1_arg;
		char *procedure75_1_arg;
		char *procedure76_1_arg;
		char *procedure77_1_arg;
		char *procedure78_1_arg;
		char *procedure79_1_arg;
		char *procedure80_1_arg;
		char *procedure81_1_arg;
		char *procedure82_1_arg;
		char *procedure83_1_arg;
		char *procedure84_1_arg;
		char *procedure85_1_arg;
		char *procedure86_1_arg;
		char *procedure87_1_arg;
		char *procedure88_1_arg;
		char *procedure89_1_arg;
		char *procedure90_1_arg;
		char *procedure91_1_arg;
		char *procedure92_1_arg;
		char *procedure93_1_arg;
		char *procedure94_1_arg;
		char *procedure95_1_arg;
		char *procedure96_1_arg;
		char *procedure97_1_arg;
		char *procedure98_1_arg;
		char *procedure99_1_arg;
		char *quit_1_arg;
	} argument;

	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, (xdrproc_t) xdr_void, (char *)NULL);
		return;

	case Procedure1:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure1_1;
		break;

	case Procedure2:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure2_1;
		break;

	case Procedure3:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure3_1;
		break;

	case Procedure4:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure4_1;
		break;

	case Procedure5:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure5_1;
		break;

	case Procedure6:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure6_1;
		break;

	case Procedure7:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure7_1;
		break;

	case Procedure8:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure8_1;
		break;

	case Procedure9:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure9_1;
		break;

	case Procedure10:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure10_1;
		break;

	case Procedure11:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure11_1;
		break;

	case Procedure12:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure12_1;
		break;

	case Procedure13:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure13_1;
		break;

	case Procedure14:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure14_1;
		break;

	case Procedure15:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure15_1;
		break;

	case Procedure16:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure16_1;
		break;

	case Procedure17:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure17_1;
		break;

	case Procedure18:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure18_1;
		break;

	case Procedure19:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure19_1;
		break;

	case Procedure20:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure20_1;
		break;

	case Procedure21:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure21_1;
		break;

	case Procedure22:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure22_1;
		break;

	case Procedure23:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure23_1;
		break;

	case Procedure24:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure24_1;
		break;

	case Procedure25:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure25_1;
		break;

	case Procedure26:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure26_1;
		break;

	case Procedure27:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure27_1;
		break;

	case Procedure28:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure28_1;
		break;

	case Procedure29:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure29_1;
		break;

	case Procedure30:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure30_1;
		break;

	case Procedure31:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure31_1;
		break;

	case Procedure32:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure32_1;
		break;

	case Procedure33:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure33_1;
		break;

	case Procedure34:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure34_1;
		break;

	case Procedure35:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure35_1;
		break;

	case Procedure36:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure36_1;
		break;

	case Procedure37:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure37_1;
		break;

	case Procedure38:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure38_1;
		break;

	case Procedure39:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure39_1;
		break;

	case Procedure40:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure40_1;
		break;

	case Procedure41:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure41_1;
		break;

	case Procedure42:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure42_1;
		break;

	case Procedure43:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure43_1;
		break;

	case Procedure44:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure44_1;
		break;

	case Procedure45:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure45_1;
		break;

	case Procedure46:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure46_1;
		break;

	case Procedure47:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure47_1;
		break;

	case Procedure48:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure48_1;
		break;

	case Procedure49:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure49_1;
		break;

	case Procedure50:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure50_1;
		break;

	case Procedure51:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure51_1;
		break;

	case Procedure52:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure52_1;
		break;

	case Procedure53:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure53_1;
		break;

	case Procedure54:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure54_1;
		break;

	case Procedure55:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure55_1;
		break;

	case Procedure56:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure56_1;
		break;

	case Procedure57:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure57_1;
		break;

	case Procedure58:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure58_1;
		break;

	case Procedure59:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure59_1;
		break;

	case Procedure60:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure60_1;
		break;

	case Procedure61:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure61_1;
		break;

	case Procedure62:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure62_1;
		break;

	case Procedure63:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure63_1;
		break;

	case Procedure64:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure64_1;
		break;

	case Procedure65:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure65_1;
		break;

	case Procedure66:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure66_1;
		break;

	case Procedure67:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure67_1;
		break;

	case Procedure68:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure68_1;
		break;

	case Procedure69:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure69_1;
		break;

	case Procedure70:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure70_1;
		break;

	case Procedure71:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure71_1;
		break;

	case Procedure72:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure72_1;
		break;

	case Procedure73:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure73_1;
		break;

	case Procedure74:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure74_1;
		break;

	case Procedure75:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure75_1;
		break;

	case Procedure76:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure76_1;
		break;

	case Procedure77:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure77_1;
		break;

	case Procedure78:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure78_1;
		break;

	case Procedure79:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure79_1;
		break;

	case Procedure80:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure80_1;
		break;

	case Procedure81:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure81_1;
		break;

	case Procedure82:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure82_1;
		break;

	case Procedure83:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure83_1;
		break;

	case Procedure84:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure84_1;
		break;

	case Procedure85:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure85_1;
		break;

	case Procedure86:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure86_1;
		break;

	case Procedure87:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure87_1;
		break;

	case Procedure88:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure88_1;
		break;

	case Procedure89:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure89_1;
		break;

	case Procedure90:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure90_1;
		break;

	case Procedure91:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure91_1;
		break;

	case Procedure92:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure92_1;
		break;

	case Procedure93:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure93_1;
		break;

	case Procedure94:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure94_1;
		break;

	case Procedure95:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure95_1;
		break;

	case Procedure96:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure96_1;
		break;

	case Procedure97:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure97_1;
		break;

	case Procedure98:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure98_1;
		break;

	case Procedure99:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) procedure99_1;
		break;

	case Quit:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_strngrec;
		local = (char *(*)()) quit_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}

/* 	bzero((char *) &argument, sizeof(argument));

        The command bzero does not exist on all machines.
        Here is its description from the man pages:

          void bzero (char *string, int length);

          The bzero() function nulls the string in the string parameter, for the
          value of the length parameter in bytes.

        A patch that should work on most systems follows:
*/

        strncpy ((char *) &argument, "", sizeof (argument));

	if (!svc_getargs(transp, (xdrproc_t) xdr_argument, (char *) &argument)) {
		svcerr_decode(transp);
		return;
	}

	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, (xdrproc_t) xdr_result, result)) {
		svcerr_systemerr(transp);
	}

	if (!svc_freeargs(transp, (xdrproc_t) xdr_argument, (char *) &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}

	return;
}

#endif
