
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <xmms/configfile.h>

#include "liveice.h"

static gint lv_sample_rates[6]={
	16000,
	22050,
	24000,
	32000,
	44100,
	48000
};

static gint lv_bitrates[14]={
	16000,
	24000,
	32000,
	48000,
	56000,
	64000,
	80000,
	96000,
	112000,
	128000,
	160000,
	196000,
	256000
};

static gint lv_channels[2]={
	1,
	2,
};

/* I'm a lazy bastard - so everythign is appearing as a global */
static GtkWidget *configure_window;
static GtkWidget *vbox1;
static GtkWidget *notebook1;
static GtkWidget *vbox2;
static GtkWidget *frame6;
static GtkWidget *table1;
static GtkWidget *label10;
static GtkWidget *samplerate_menu;
static GtkWidget *samplerate_menu_menu;
static GtkWidget *glade_menuitem;
static GtkWidget *label11;
static GtkWidget *bitrate_menu;
static GtkWidget *bitrate_menu_menu = NULL;
static GtkWidget *label12;
static GtkWidget *channels_menu;
static GtkWidget *channels_menu_menu;
static GtkWidget *vseparator7;
static GtkWidget *vseparator6;
static GtkWidget *vseparator5;
static GtkWidget *frame7;
static GtkWidget *table2;
static GtkWidget *encoder_menu;
static GtkWidget *encoder_menu_menu;
static GtkWidget *label6;
static GtkWidget *label7;
static GtkWidget *encoder_command;
static GtkWidget *vseparator9;
static GtkWidget *vseparator8;
static GtkWidget *frame8;
static GtkWidget *hbox3;
static GtkWidget *format_test_message;
static GtkWidget *label1;
static GtkWidget *vbox6;
static GtkWidget *frame9;
static GtkWidget *table3;
static GtkWidget *vseparator10;
static GtkWidget *vseparator11;
static GtkWidget *vseparator12;
static GtkWidget *vseparator13;
static GtkWidget *stream_name_entry;
static GtkWidget *stream_description_entry;
static GtkWidget *stream_url_entry;
static GtkWidget *stream_genre_entry;
static GtkWidget *label14;
static GtkWidget *label15;
static GtkWidget *label16;
static GtkWidget *label17;
static GtkWidget *frame10;
static GtkWidget *hbox4;
static GtkWidget *public_checkbutton;
static GtkWidget *label2;
static GtkWidget *vbox7;
static GtkWidget *frame12;
static GtkWidget *table4;
static GtkWidget *label19;
static GtkWidget *label20;
static GtkWidget *server_addr_entry;
static GtkWidget *server_port_entry;
static GtkWidget *frame13;
static GtkWidget *vbox8;
static GtkWidget *header_type_button;
static GtkWidget *title_streaming_button;
static GtkWidget *hbox6;
static GtkWidget *table5;
static GtkWidget *label21;
static GtkWidget *stream_mountpoint_entry;
static GtkWidget *label22;
static GtkWidget *server_password_entry;
static GtkWidget *hbox7;
static GtkWidget *remote_dumpfile_button;
static GtkWidget *remote_dumpfile_entry;
static GtkWidget *label3;
static GtkWidget *hbuttonbox1;
static GtkWidget *ok_button;
static GtkWidget *apply_button;
static GtkWidget *cancel_button;
static GtkTooltips *tooltips;

/* the about window */
static GtkWidget *about_window;

static gint gui_sample_rate,gui_bitrate,gui_channels,gui_encoder;

static void conf_apply_cb(GtkButton * button, gpointer data);
static void set_bitrate_cb(GtkWidget *w, gpointer data);

static gint liveice_about_destroy_cb(GtkWidget * w, GdkEventAny * e, gpointer data)
{

	
	gtk_widget_destroy(about_window);
	about_window = NULL;
	return TRUE;
}

static void liveice_about_ok_cb(GtkButton * button, gpointer data)
{
	
	gtk_widget_destroy(GTK_WIDGET(about_window));
	about_window = NULL;
}

/* check if the format is valid */

static int check_audio_format(void){
	gint item_loop, min_bitrate = 0, max_bitrate = 12;
	gchar *buf;

	if(gui_sample_rate >24000)
	{
		if(gui_channels == 1)
		{
			min_bitrate = 2; /* 32 kbps */
			if(gui_bitrate < 32000)
				gui_bitrate = 32000;
		}
		else
		{
			min_bitrate = 5; /* 64 kbps */
			if(gui_bitrate < 64000)
				gui_bitrate = 64000;
		}
	}
        else
	{
		max_bitrate = 10; /* 160 kbps */
		if(gui_bitrate > 160000)
			gui_bitrate = 160000;
		if(gui_channels > 1)
		{
			min_bitrate = 2; /* 32 kbps */
			if(gui_bitrate < 32000)
				gui_bitrate = 32000;
		}			
	}
	if(bitrate_menu_menu)
		gtk_widget_destroy(bitrate_menu_menu);
	
	bitrate_menu_menu = gtk_menu_new ();
	for(item_loop = min_bitrate; item_loop <= max_bitrate; item_loop++){
		buf = g_strdup_printf("%d",lv_bitrates[item_loop]);
		glade_menuitem = gtk_menu_item_new_with_label (buf);
		g_free(buf);
		gtk_widget_show (glade_menuitem);
		gtk_menu_append (GTK_MENU (bitrate_menu_menu), glade_menuitem);
		gtk_signal_connect(GTK_OBJECT(glade_menuitem), "activate",
				   GTK_SIGNAL_FUNC(set_bitrate_cb), (gpointer) lv_bitrates[item_loop]);
	}
	
	gtk_option_menu_set_menu (GTK_OPTION_MENU (bitrate_menu), bitrate_menu_menu);
	gtk_option_menu_set_history (GTK_OPTION_MENU (bitrate_menu), 0);
	for(item_loop = min_bitrate; item_loop <= max_bitrate; item_loop++)
	{
		if(gui_bitrate == lv_bitrates[item_loop])
		{
			gtk_option_menu_set_history (GTK_OPTION_MENU (bitrate_menu), item_loop - min_bitrate);
			gui_bitrate=lv_bitrates[item_loop];
		}
	}
	return 0;
}



/* I know I'm probably asking for trouble by passing ints as pointers....
   but I never was the safest programmer*/
static void set_sample_rate_cb(GtkWidget *w, gpointer data){
	gui_sample_rate=(gint) data;
	check_audio_format();
	
}
static void set_bitrate_cb(GtkWidget *w, gpointer data)
{
	if(gui_bitrate != (gint)data)
	{
		gui_bitrate=(gint) data;
		check_audio_format();
	}
}

static void set_channels_cb(GtkWidget *w, gpointer data){
	gui_channels=(gint) data;
	check_audio_format();
}

static void set_encoder_cb(GtkWidget *w, gpointer data){
	gui_encoder=(gint) data;
	check_audio_format();
}



static void conf_ok_cb(GtkButton * button, gpointer data)
{
	conf_apply_cb(button, data);

	gtk_widget_destroy(GTK_WIDGET(configure_window));
}

static void conf_cancel_cb(GtkButton * button, gpointer data)
{
	gtk_widget_destroy(GTK_WIDGET(configure_window));
	configure_window = NULL;
}

static void conf_apply_cb(GtkButton * button, gpointer data)
{
	ConfigFile *cfg;
	gchar *filename;




	/* encdoer command */
	lv_conf.encoder=gui_encoder;
	g_free(lv_conf.encoder_path);
	lv_conf.encoder_path=g_strdup(gtk_entry_get_text(GTK_ENTRY(encoder_command)));

	/* stream name */
	g_free(lv_conf.name);
	lv_conf.name=g_strdup(gtk_entry_get_text(GTK_ENTRY(stream_name_entry)));
	/* stream description */
	g_free(lv_conf.description);
	lv_conf.description=g_strdup(gtk_entry_get_text(GTK_ENTRY(stream_description_entry)));

	/* stream URL */
	g_free(lv_conf.url);
	lv_conf.url=g_strdup(gtk_entry_get_text(GTK_ENTRY(stream_url_entry)));

	/* stream genre */
	g_free(lv_conf.genre);
	lv_conf.genre=g_strdup(gtk_entry_get_text(GTK_ENTRY(stream_genre_entry)));

	/* remote server */
	g_free(lv_conf.server);
	lv_conf.server=g_strdup(gtk_entry_get_text(GTK_ENTRY(server_addr_entry)));
        /* remote server port */
       	lv_conf.port=atoi(gtk_entry_get_text(GTK_ENTRY(server_port_entry)));
	
	/* remote server password */
	g_free(lv_conf.password);
	lv_conf.password=g_strdup(gtk_entry_get_text(GTK_ENTRY(server_password_entry)));
	
	/* stream mountpoint */
	g_free(lv_conf.mountpoint);
	lv_conf.mountpoint=g_strdup(gtk_entry_get_text(GTK_ENTRY(stream_mountpoint_entry)));
	

	/* audio format */
	lv_conf.sample_rate=gui_sample_rate;
	lv_conf.bitrate=gui_bitrate;
	lv_conf.channels=gui_channels;
	
	/* checkbuttons */
	/*check state of public_checkbutton*/
	lv_conf.public=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(public_checkbutton));
	lv_conf.header_format=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(header_type_button));
	lv_conf.title_streaming=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(title_streaming_button));
	

	/* remote dumpfile */
	lv_conf.remote_dumpfile_enable=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(remote_dumpfile_button));
	g_free(lv_conf.remote_dumpfile);
	lv_conf.remote_dumpfile=g_strdup(gtk_entry_get_text(GTK_ENTRY(remote_dumpfile_entry)));
	


	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	cfg = xmms_cfg_open_file(filename);
	if (!cfg)
		cfg = xmms_cfg_new();

	xmms_cfg_write_int(cfg, "LiveIce", "port", lv_conf.port);
	xmms_cfg_write_int(cfg, "LiveIce", "public", lv_conf.public);
	xmms_cfg_write_int(cfg, "LiveIce", "bitrate", lv_conf.bitrate);
	xmms_cfg_write_int(cfg, "LiveIce", "vbr_quality", lv_conf.vbr_quality);
	xmms_cfg_write_int(cfg, "LiveIce", "encoding_quality", lv_conf.encoding_quality);
	xmms_cfg_write_int(cfg, "LiveIce", "sample_rate", lv_conf.sample_rate);
	xmms_cfg_write_int(cfg, "LiveIce", "channels", lv_conf.channels);
	xmms_cfg_write_int(cfg, "LiveIce", "header_format", lv_conf.header_format);
	xmms_cfg_write_int(cfg, "LiveIce", "copyright", lv_conf.copyright);
	xmms_cfg_write_int(cfg, "LiveIce", "encoder", lv_conf.encoder);	
	xmms_cfg_write_int(cfg, "LiveIce", "remote_dumpfile_enable", lv_conf.remote_dumpfile_enable);
	xmms_cfg_write_int(cfg, "LiveIce", "title_streaming", lv_conf.title_streaming);
	

	xmms_cfg_write_string(cfg, "LiveIce", "server", lv_conf.server);
	xmms_cfg_write_string(cfg, "LiveIce", "password", lv_conf.password);
	xmms_cfg_write_string(cfg, "LiveIce", "mountpoint", lv_conf.mountpoint);
	xmms_cfg_write_string(cfg, "LiveIce", "name", lv_conf.name);
	xmms_cfg_write_string(cfg, "LiveIce", "genre", lv_conf.genre);
	xmms_cfg_write_string(cfg, "LiveIce", "url", lv_conf.url);
	xmms_cfg_write_string(cfg, "LiveIce", "description", lv_conf.description);
	xmms_cfg_write_string(cfg, "LiveIce", "encoder_path", lv_conf.encoder_path);
	xmms_cfg_write_string(cfg, "LiveIce", "remote_dumpfile", lv_conf.remote_dumpfile);
	
	
	xmms_cfg_write_file(cfg, filename);
	xmms_cfg_free(cfg);
	g_free(filename);
	
	/* now all teh changes have been written - force a reconnect and restart */
	/* I'm restarting everything right now ... jsut for the moment */
	lv_conf.send_enabled=SEND_RESTART_ALL;


}



void liveice_configure (void)
{
	char buf[128];
	gint item_loop;
	if (configure_window != NULL)
		return;

	configure_window = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_object_set_data (GTK_OBJECT (configure_window), "configure_window", configure_window);
	gtk_window_set_title (GTK_WINDOW (configure_window), "Configure LiveIce Plugin");
	gtk_window_set_policy(GTK_WINDOW (configure_window), FALSE, FALSE, FALSE);
	gtk_signal_connect(GTK_OBJECT(configure_window), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configure_window);
	gtk_container_set_border_width (GTK_CONTAINER (configure_window), 10);

	
	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (configure_window), vbox1);
	
	notebook1 = gtk_notebook_new ();
	gtk_widget_show (notebook1);
	gtk_box_pack_start (GTK_BOX (vbox1), notebook1, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 5);
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (notebook1), vbox2);
	
	frame6 = gtk_frame_new ("Audio Format");
	gtk_widget_show (frame6);
	gtk_box_pack_start (GTK_BOX (vbox2), frame6, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame6), 5);
	
	table1 = gtk_table_new (2, 3, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
	
	
	gtk_widget_show (table1);
	gtk_container_add (GTK_CONTAINER (frame6), table1);

	label10 = gtk_label_new ("Sample Rate (Hz):");
	gtk_misc_set_alignment(GTK_MISC(label10), 1, 0.5);
	gtk_widget_show (label10);
	gtk_table_attach (GTK_TABLE (table1), label10, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	samplerate_menu = gtk_option_menu_new ();
	
	gtk_widget_show (samplerate_menu);
	gtk_table_attach (GTK_TABLE (table1), samplerate_menu, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);
	
	samplerate_menu_menu = gtk_menu_new ();

	for(item_loop=0;item_loop<6;item_loop++){
		sprintf(buf,"%d",lv_sample_rates[item_loop]);
		glade_menuitem = gtk_menu_item_new_with_label(buf);
		gtk_widget_show(glade_menuitem);
		gtk_menu_append (GTK_MENU (samplerate_menu_menu), glade_menuitem);
		
		gtk_signal_connect(GTK_OBJECT(glade_menuitem), "activate",
				   GTK_SIGNAL_FUNC(set_sample_rate_cb), (gpointer) lv_sample_rates[item_loop]);
		
	}
	
	gtk_option_menu_set_menu (GTK_OPTION_MENU (samplerate_menu), samplerate_menu_menu);
	gtk_option_menu_set_history (GTK_OPTION_MENU (samplerate_menu),2);
	for(item_loop=0;item_loop<6;item_loop++){
		if(lv_conf.sample_rate>=lv_sample_rates[item_loop]){
			gtk_option_menu_set_history (GTK_OPTION_MENU (samplerate_menu), item_loop);
			gui_sample_rate=lv_sample_rates[item_loop];
		}
	}
	
	label12 = gtk_label_new ("Number Of Channels:");
	gtk_misc_set_alignment(GTK_MISC(label12), 1, 0.5);
	gtk_widget_show (label12);
	gtk_table_attach (GTK_TABLE (table1), label12, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);
	
	channels_menu = gtk_option_menu_new ();
	
	gtk_widget_show (channels_menu);
	gtk_table_attach (GTK_TABLE (table1), channels_menu, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	
	channels_menu_menu = gtk_menu_new ();
	glade_menuitem = gtk_menu_item_new_with_label ("Stereo");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (channels_menu_menu), glade_menuitem);
	gtk_signal_connect(GTK_OBJECT(glade_menuitem), "activate",
				   GTK_SIGNAL_FUNC(set_channels_cb), (gpointer) 2);
	glade_menuitem = gtk_menu_item_new_with_label ("Mono");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (channels_menu_menu), glade_menuitem);
	gtk_signal_connect(GTK_OBJECT(glade_menuitem), "activate",
				   GTK_SIGNAL_FUNC(set_channels_cb), (gpointer) 1);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (channels_menu), channels_menu_menu);
	if(lv_conf.channels==2){
		gtk_option_menu_set_history (GTK_OPTION_MENU (channels_menu), 0);
		gui_channels=2;
	} else {
		gtk_option_menu_set_history (GTK_OPTION_MENU (channels_menu), 1);
		gui_channels=1;
	}

	label11 = gtk_label_new ("Stream Bitrate (bps):");
	gtk_widget_show (label11);
	gtk_misc_set_alignment(GTK_MISC(label11), 1, 0.5);
	gtk_table_attach (GTK_TABLE (table1), label11, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	bitrate_menu = gtk_option_menu_new ();
	
	gtk_widget_show (bitrate_menu);
	gtk_table_attach (GTK_TABLE (table1), bitrate_menu, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);

	frame7 = gtk_frame_new ("Encoder");
	gtk_container_set_border_width (GTK_CONTAINER (frame7), 5);
	gtk_widget_show (frame7);
	gtk_box_pack_start (GTK_BOX (vbox2), frame7, FALSE, FALSE, 0);
	
	table2 = gtk_table_new (2, 3, FALSE);
	gtk_widget_show (table2);
	gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
	gtk_container_add (GTK_CONTAINER (frame7), table2);

	label6 = gtk_label_new ("Encoder Type:");
	gtk_misc_set_alignment(GTK_MISC(label6), 1, 0.5);
	gtk_widget_show (label6);
	gtk_table_attach (GTK_TABLE (table2), label6, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	encoder_menu = gtk_option_menu_new ();
	
	gtk_widget_show (encoder_menu);
	gtk_table_attach (GTK_TABLE (table2), encoder_menu, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);
	encoder_menu_menu = gtk_menu_new ();
	glade_menuitem = gtk_menu_item_new_with_label ("Lame (3.21 and above)");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (encoder_menu_menu), glade_menuitem);
	gtk_signal_connect(GTK_OBJECT(glade_menuitem), "activate",
				   GTK_SIGNAL_FUNC(set_encoder_cb), (gpointer) LAME3);
	glade_menuitem = gtk_menu_item_new_with_label ("mp3enc (registered)");
	gtk_widget_show (glade_menuitem);
	gtk_menu_append (GTK_MENU (encoder_menu_menu), glade_menuitem);
	gtk_signal_connect(GTK_OBJECT(glade_menuitem), "activate",
				   GTK_SIGNAL_FUNC(set_encoder_cb), (gpointer) MP3ENC);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (encoder_menu), encoder_menu_menu);
	if(lv_conf.encoder==MP3ENC){
		gtk_option_menu_set_history (GTK_OPTION_MENU (encoder_menu), 1);
		gui_encoder=MP3ENC;
	} else {
		gtk_option_menu_set_history (GTK_OPTION_MENU (encoder_menu), 0);
		gui_encoder=LAME3;
	}
	
	
	label7 = gtk_label_new ("Executable name:");
	
	gtk_widget_show (label7);
	gtk_table_attach (GTK_TABLE (table2), label7, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);
	gtk_misc_set_alignment (GTK_MISC (label7), 1, 0.5);
	
	encoder_command = gtk_entry_new ();

	gtk_widget_show (encoder_command);
	gtk_table_attach (GTK_TABLE (table2), encoder_command, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text (GTK_ENTRY (encoder_command), lv_conf.encoder_path);

	gui_bitrate = lv_conf.bitrate;
	check_audio_format();
	
	label1 = gtk_label_new ("Audio Format");
	
	gtk_widget_show (label1);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label1);
	
	vbox6 = gtk_vbox_new (FALSE, 5);
	gtk_widget_show (vbox6);
	gtk_container_add (GTK_CONTAINER (notebook1), vbox6);
	
	frame9 = gtk_frame_new ("Names");
	
	gtk_widget_show (frame9);
	gtk_box_pack_start (GTK_BOX (vbox6), frame9, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame9), 5);
	
	table3 = gtk_table_new (2, 3, FALSE);	
	gtk_widget_show (table3);
	gtk_container_set_border_width(GTK_CONTAINER(table3), 5);
	gtk_container_add (GTK_CONTAINER (frame9), table3);

	label14 = gtk_label_new ("Stream Title:");
	gtk_misc_set_alignment(GTK_MISC(label14), 1, 0.5);
	gtk_widget_show (label14);
	gtk_table_attach (GTK_TABLE (table3), label14, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);

	
	stream_name_entry = gtk_entry_new ();
	gtk_widget_show (stream_name_entry);
	gtk_table_attach (GTK_TABLE (table3), stream_name_entry, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);
	gtk_entry_set_text (GTK_ENTRY (stream_name_entry), lv_conf.name);

	label15 = gtk_label_new ("Description:");
	gtk_misc_set_alignment(GTK_MISC(label15), 1, 0.5);
	gtk_widget_show (label15);
	gtk_table_attach (GTK_TABLE (table3), label15, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	stream_description_entry = gtk_entry_new ();
	gtk_widget_show (stream_description_entry);
	gtk_table_attach (GTK_TABLE (table3), stream_description_entry, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);
	gtk_entry_set_text (GTK_ENTRY (stream_description_entry), lv_conf.description);

	label16 = gtk_label_new ("URL:");
	gtk_misc_set_alignment(GTK_MISC(label16), 1, 0.5);
	gtk_widget_show (label16);
	gtk_table_attach (GTK_TABLE (table3), label16, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	stream_url_entry = gtk_entry_new ();
	gtk_widget_show (stream_url_entry);
	gtk_table_attach (GTK_TABLE (table3), stream_url_entry, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);
	gtk_entry_set_text (GTK_ENTRY (stream_url_entry), lv_conf.url);

	label17 = gtk_label_new ("Genre:");
	
	gtk_widget_show (label17);
	gtk_misc_set_alignment(GTK_MISC(label17), 1, 0.5);
	gtk_table_attach (GTK_TABLE (table3), label17, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);

	stream_genre_entry = gtk_entry_new ();
	gtk_widget_show (stream_genre_entry);
	gtk_table_attach (GTK_TABLE (table3), stream_genre_entry, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text (GTK_ENTRY (stream_genre_entry), lv_conf.genre);
	
	frame10 = gtk_frame_new ("Public");
	gtk_widget_show (frame10);
	gtk_box_pack_start (GTK_BOX (vbox6), frame10, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame10), 5);
	
	hbox4 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox4);
	gtk_container_add (GTK_CONTAINER (frame10), hbox4);
	
	public_checkbutton = gtk_check_button_new_with_label ("Public Stream (Will appear on the directory servers)");
	gtk_widget_show (public_checkbutton);
	gtk_box_pack_start (GTK_BOX (hbox4), public_checkbutton, TRUE, FALSE, 0);
	if(lv_conf.public){
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (public_checkbutton), TRUE);
	} else {
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (public_checkbutton), FALSE);
	}
	
	label2 = gtk_label_new ("Description");
	gtk_widget_show (label2);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label2);
	
	vbox7 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox7);
	gtk_container_add (GTK_CONTAINER (notebook1), vbox7);
	
	frame12 = gtk_frame_new ("Server Location");
	gtk_widget_show (frame12);
	gtk_box_pack_start (GTK_BOX (vbox7), frame12, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame12), 5);
	
	table4 = gtk_table_new (2, 2, FALSE);
	gtk_widget_show (table4);
	gtk_container_set_border_width(GTK_CONTAINER(table4), 5);
	gtk_container_add (GTK_CONTAINER (frame12), table4);
	
	label19 = gtk_label_new ("Server Address:");
	gtk_misc_set_alignment(GTK_MISC(label19), 1, 0.5);
	gtk_widget_show (label19);
	gtk_table_attach (GTK_TABLE (table4), label19, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	server_addr_entry = gtk_entry_new ();
	gtk_widget_show (server_addr_entry);
	gtk_table_attach (GTK_TABLE (table4), server_addr_entry, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);
	gtk_entry_set_text (GTK_ENTRY (server_addr_entry), lv_conf.server);

	label20 = gtk_label_new ("Server Port:");
	gtk_misc_set_alignment(GTK_MISC(label20), 1, 0.5);
	gtk_widget_show (label20);
	gtk_table_attach (GTK_TABLE (table4), label20, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	server_port_entry = gtk_entry_new ();
	gtk_widget_show (server_port_entry);
	gtk_table_attach (GTK_TABLE (table4), server_port_entry, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);
	sprintf(buf,"%d",lv_conf.port);
	gtk_entry_set_text (GTK_ENTRY (server_port_entry), buf);

	label22 = gtk_label_new ("Encoder Password:");
	gtk_misc_set_alignment(GTK_MISC(label22), 1, 0.5);
	gtk_widget_show (label22);
	gtk_table_attach (GTK_TABLE (table4), label22, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);
		
	server_password_entry = gtk_entry_new ();
	gtk_entry_set_visibility(GTK_ENTRY(server_password_entry), FALSE);
	gtk_widget_show (server_password_entry);
	gtk_table_attach (GTK_TABLE (table4), server_password_entry, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text (GTK_ENTRY (server_password_entry), lv_conf.password);


	frame13 = gtk_frame_new ("Extra Icecast Only Features");
	gtk_widget_show (frame13);
	gtk_box_pack_start (GTK_BOX (vbox7), frame13, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame13), 5);
	
	vbox8 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox8);
	gtk_container_add (GTK_CONTAINER (frame13), vbox8);
	
	header_type_button = gtk_check_button_new_with_label ("Use X-Audiocast Headers");
	gtk_widget_show (header_type_button);
	gtk_box_pack_start (GTK_BOX (vbox8), header_type_button, FALSE, FALSE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (header_type_button), 5);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (header_type_button), TRUE);
	if(lv_conf.header_format){
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (header_type_button), TRUE);
	} else {
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (header_type_button), FALSE);
	}

	table5 = gtk_table_new(3, 2, FALSE);
	gtk_widget_show (table5);
	gtk_box_pack_start (GTK_BOX (vbox8), table5, TRUE, TRUE, 0);
	
	title_streaming_button = gtk_check_button_new_with_label ("Enable Icecast Title Data");
	gtk_widget_show (title_streaming_button);
	gtk_table_attach (GTK_TABLE (table5), title_streaming_button, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	if(lv_conf.title_streaming){
	        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (title_streaming_button), TRUE);
	} else {
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (title_streaming_button), FALSE);
	}

	label21 = gtk_label_new ("Stream Mountpoint:");
	gtk_misc_set_alignment(GTK_MISC(label21), 1, 0.5);
	gtk_widget_show (label21);
	gtk_table_attach (GTK_TABLE (table5), label21, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	
	stream_mountpoint_entry = gtk_entry_new ();
	gtk_widget_show (stream_mountpoint_entry);
	gtk_entry_set_text (GTK_ENTRY (stream_mountpoint_entry), lv_conf.mountpoint);
	gtk_table_attach (GTK_TABLE (table5), stream_mountpoint_entry, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);
	
	remote_dumpfile_button = gtk_check_button_new_with_label ("Remote Dumpfile:");
	gtk_widget_show (remote_dumpfile_button);
	gtk_table_attach (GTK_TABLE (table5), remote_dumpfile_button, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);

	if(lv_conf.remote_dumpfile_enable){
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remote_dumpfile_button), TRUE);
	} else {
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remote_dumpfile_button), FALSE);
	}


	remote_dumpfile_entry = gtk_entry_new ();
	gtk_widget_show (remote_dumpfile_entry);
	gtk_entry_set_text (GTK_ENTRY (remote_dumpfile_entry), lv_conf.remote_dumpfile);
	gtk_table_attach (GTK_TABLE (table5), remote_dumpfile_entry, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	
	label3 = gtk_label_new ("Server");
	gtk_widget_show (label3);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label3);
	
	hbuttonbox1 = gtk_hbutton_box_new ();
	gtk_widget_show (hbuttonbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, FALSE, TRUE, 0);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox1), 5);
	
	ok_button = gtk_button_new_with_label ("OK");
	gtk_widget_show (ok_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), ok_button);
	GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
			   GTK_SIGNAL_FUNC(conf_ok_cb), NULL);
	
	cancel_button = gtk_button_new_with_label ("Cancel");
	gtk_widget_show (cancel_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), cancel_button);
	GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
	gtk_signal_connect_object(GTK_OBJECT(cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(configure_window));
	
	apply_button = gtk_button_new_with_label ("Apply");
	gtk_widget_show (apply_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), apply_button);
	GTK_WIDGET_SET_FLAGS (apply_button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(apply_button), "clicked",
			   GTK_SIGNAL_FUNC(conf_apply_cb), NULL);

	gtk_widget_grab_default (ok_button);
	
	gtk_widget_show(configure_window);
}

void liveice_about (void)
{
	GtkWidget *frame14;
	GtkWidget *vbox9;
	GtkWidget *label22;
	GtkWidget *scrolledwindow1;
	GtkWidget *text1;
	GtkWidget *about_ok_button;
	GdkFont *font;
	
	if(about_window != NULL){
		return;
	}
	about_window = gtk_window_new (GTK_WINDOW_DIALOG);
	
	
	gtk_object_set_data (GTK_OBJECT (about_window), "about_window", about_window);
	gtk_window_set_title (GTK_WINDOW (about_window), "About LiveIce Plugin");
	
	gtk_signal_connect(GTK_OBJECT(about_window), "destroy",
			   GTK_SIGNAL_FUNC(liveice_about_destroy_cb), NULL);
	
	frame14 = gtk_frame_new ("About LiveIce Plugin");
	
	gtk_widget_show (frame14);
	gtk_container_add (GTK_CONTAINER (about_window), frame14);
	gtk_container_set_border_width (GTK_CONTAINER (frame14), 5);
	
	vbox9 = gtk_vbox_new (FALSE, 0);
	
	gtk_widget_show (vbox9);
	gtk_container_add (GTK_CONTAINER (frame14), vbox9);
	
	label22 = gtk_label_new ("LiveIce Plugin");
	gtk_widget_show (label22);
	gtk_box_pack_start (GTK_BOX (vbox9), label22, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (label22), 10, 10);
	
	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox9), scrolledwindow1, TRUE, TRUE, 0);
	
	text1 = gtk_text_new (NULL, NULL);
	gtk_widget_set_usize(text1, 500, 200);
	
	gtk_widget_show (text1);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);
	gtk_widget_realize (text1);
	font = gdk_font_load("-adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*");
	gtk_text_insert (GTK_TEXT (text1), font, NULL, NULL,
			 "LiveIce Plugin For XMMS\n=======================\n\nWritten by Scott Manley with lots of technical help from Peter of the\nXMMS team.\n\nThis  code is available under the GPL and I'd appreciate mentions \nwhen people decide to borrow bits of it. \n\nRespect is due to all the mp3 hackers who've put together the \nencoding engines this software needs to run since without them\nI would lack  the ability to do this.\n\nCopyright 2000 Scott Manley\nspm@star.arm.ac.uk\n\n(Who was serving live mp3 before other people got in on the act and\nstarted getting annoyed by me stepping on 'their' turf - you know who\nyou are ;-)\n", 602);
	gdk_font_unref(font);
	
	about_ok_button = gtk_button_new_with_label ("OK");
	
	gtk_widget_show (about_ok_button);
	gtk_signal_connect(GTK_OBJECT(about_ok_button), "clicked",
			   GTK_SIGNAL_FUNC(liveice_about_ok_cb), NULL);
	GTK_WIDGET_SET_FLAGS(about_ok_button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(about_ok_button);
	gtk_box_pack_start (GTK_BOX (vbox9), about_ok_button, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (about_ok_button), 10);
	gtk_widget_show(about_window);
}

