/* this code is based on the echo plugin but with a completely new liveice
   encoding streamer over the top - so gimme credit if you borrow my code...

   and remember that Linux was streaming live mp3 a year before Shoutcast
   came along - we beat you to it justin ;-)

   Scott Manley spm@star.arm.ac.uk

   BTW this is all GPL'd at the moment
*/

#include "config.h"

#include <xmms/plugin.h>
#include <xmms/configfile.h>
#include <xmms/xmmsctrl.h>
#include <xmms/util.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <gtk/gtk.h>
#include "liveice.h"
#include "serverlib.h"
#include <errno.h>
#include <pthread.h>



extern int errno;

static sckt *liveice_sp=NULL;

static gboolean config_read = FALSE;
static gboolean title_thread_on = FALSE;
static gint stream_running=0;
static pthread_t title_thread;


static void init(void);
static void cleanup(void);
static int launch_encoder(void);
static int send_stream(gpointer * d, gint length, AFormat afmt, gint srate, gint nch);

#define MAX_SRATE 50000
#define MAX_CHANNELS 2
#define BYTES_PS 2
#define BUFFER_SAMPLES (MAX_SRATE * MAX_DELAY / 1000)
#define BUFFER_SHORTS (BUFFER_SAMPLES * MAX_CHANNELS)
#define BUFFER_BYTES (BUFFER_SHORTS * BYTES_PS)

EffectPlugin liveice_ep =
{
	NULL,
	NULL,
	PACKAGE " " VERSION,
	init,
	cleanup,
	liveice_about,
	liveice_configure,
	send_stream,
	NULL
};

/* this is presumably called to return the plugin function structure */
EffectPlugin *get_eplugin_info(void)
{
	return &liveice_ep;
}


/* if we get a sigpipe then check to see if the encoder has died */
void bugger(int signo){
	/* check to see if the encoder is running */
	if(lv_conf.enc_pid>0){
		kill(lv_conf.enc_pid,9);
	}      
	/* close the pipes to and fromt the encoder */
	close(lv_conf.read_fd);
	close(lv_conf.write_fd);
	lv_conf.send_enabled=0;
	launch_encoder();
}




static void string_init(char **strp, char *str){
        *strp = malloc(strlen(str)+2);
        strcpy(*strp,str);
} 


static void init(void)
{

	ConfigFile *cfg;
        gchar *filename;

        if(!config_read) {

		lv_conf.port=8000;
		lv_conf.server=NULL;
		lv_conf.password=NULL;
		lv_conf.mountpoint=NULL;
		lv_conf.name=NULL;
		lv_conf.genre=NULL;
		lv_conf.url=NULL;
		lv_conf.description=NULL;
		lv_conf.public=0;
		lv_conf.bitrate=24000;
		lv_conf.vbr_quality=30;
		lv_conf.encoding_quality=30;
		lv_conf.sample_rate=22050;
		lv_conf.channels=1;
		lv_conf.header_format=1;
		lv_conf.copyright=0;
		lv_conf.encoder=DEFAULT_ENCODER; 
		lv_conf.remote_dumpfile_enable=0;
		lv_conf.title_streaming=0;

		lv_conf.read_fd=-1;
		lv_conf.write_fd=-1;
		lv_conf.send_fd=-1;			
		lv_conf.enc_pid=-1;             
		lv_conf.send_enabled=SEND_INIT;

		/* should be a little more useful */
		lv_conf.encoder_active=ENCODER_INIT;
		lv_conf.connection_active=CONNECTION_INIT;
		
		filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
		cfg = xmms_cfg_open_file(filename);
		if (cfg) {
			xmms_cfg_read_int(cfg, "LiveIce", "port", &lv_conf.port);
			xmms_cfg_read_int(cfg, "LiveIce", "public", &lv_conf.public);
			xmms_cfg_read_int(cfg, "LiveIce", "bitrate", &lv_conf.bitrate);
			xmms_cfg_read_int(cfg, "LiveIce", "vbr_quality", &lv_conf.vbr_quality);
			xmms_cfg_read_int(cfg, "LiveIce", "encoding_quality", &lv_conf.encoding_quality);
			xmms_cfg_read_int(cfg, "LiveIce", "sample_rate", &lv_conf.sample_rate);
			xmms_cfg_read_int(cfg, "LiveIce", "channels", &lv_conf.channels);
			xmms_cfg_read_int(cfg, "LiveIce", "header_format", &lv_conf.header_format);
			xmms_cfg_read_int(cfg, "LiveIce", "copyright", &lv_conf.copyright);
			xmms_cfg_read_int(cfg, "LiveIce", "encoder", &lv_conf.encoder);
			xmms_cfg_read_int(cfg, "LiveIce", "remote_dumpfile_enable", &lv_conf.remote_dumpfile_enable);
			xmms_cfg_read_int(cfg, "LiveIce", "title_streaming", &lv_conf.title_streaming);
			
			
			if(!xmms_cfg_read_string(cfg, "LiveIce", "server", &lv_conf.server))
				lv_conf.server=g_strdup("localhost");
			      
			if(!xmms_cfg_read_string(cfg, "LiveIce", "password", &lv_conf.password))
				lv_conf.password=g_strdup("hackme");
			
			if(!xmms_cfg_read_string(cfg, "LiveIce", "mountpoint", &lv_conf.mountpoint))
				lv_conf.mountpoint=g_strdup("/live_xmms");
			
			if(!xmms_cfg_read_string(cfg, "LiveIce", "name", &lv_conf.name))
				lv_conf.name=g_strdup("XMMS Music");
			
			if(!xmms_cfg_read_string(cfg, "LiveIce", "genre", &lv_conf.genre))
				lv_conf.genre=g_strdup("live");

			if(!xmms_cfg_read_string(cfg, "LiveIce", "url", &lv_conf.url))
				lv_conf.url=g_strdup("http://www.icecast.org");

			if(!xmms_cfg_read_string(cfg, "LiveIce", "description", &lv_conf.description))
				lv_conf.description=g_strdup("Music from XMMS");
			if(!xmms_cfg_read_string(cfg, "LiveIce", "encoder_path", &lv_conf.encoder_path))
				lv_conf.encoder_path=g_strdup("lame");
			
			if(!xmms_cfg_read_string(cfg, "LiveIce", "remote_dumpfile", &lv_conf.remote_dumpfile))
			        lv_conf.encoder_path=g_strdup("liveice_xmms.mp3");
			
			xmms_cfg_free(cfg);

		} else {
			lv_conf.server=g_strdup("localhost");
			lv_conf.password=g_strdup("letmein");
			lv_conf.mountpoint=g_strdup("/live_xmms");
			lv_conf.name=g_strdup("XMMS Music");
			lv_conf.genre=g_strdup("live");
			lv_conf.url=g_strdup("http://www.icecast.org");
			lv_conf.description=g_strdup("Music from XMMS");
			lv_conf.encoder_path=g_strdup("lame");
			lv_conf.remote_dumpfile=g_strdup("liveice_xmms.mp3");
		}
		g_free(filename);
		config_read = TRUE;
	}
}

static void close_and_kill_stream(void) {
	
	/*fprintf(stderr,"killing encoder");*/
	if(lv_conf.enc_pid>0){
		kill(lv_conf.enc_pid,9);
	}
	if(lv_conf.send_enabled>0){
		sclose(liveice_sp);
		close(lv_conf.read_fd);
		close(lv_conf.write_fd);
		close(lv_conf.send_fd);
		lv_conf.send_enabled=0;
	}
}

/* try  executing it and seeing what happens */
static int check_executable(char *filename){
        int result;
        if(fork()){
                wait(&result);
        } else {
                close(0);
                close(1);
                close(2);
                open("/dev/null", O_RDONLY);
                open("/dev/null", O_WRONLY);
                open("/dev/null", O_WRONLY);
                execlp(filename,filename,NULL);
                exit(31337);
        }
        if(result==31337){
                result= 0;
        } else {
                result=1;
        }
        return result;
}




/* launch the encoder with all teh pies connected in teh right order */
static int launch_encoder(void){
	int send_pipe[2],retn_pipe[2],i;
	pid_t enc_pid;
	char br[32],sr[32],ch[32];

	if(lv_conf.encoder_active){
	  fprintf(stderr,"launch_encoder() called when encoder already active\n");
	  return -1;
	}

	if((lv_conf.encoder== MP3ENC) || (lv_conf.encoder==LAME3) ){
		if(!check_executable(lv_conf.encoder_path)){
			/* error */
			lv_conf.encoder_active=ENCODER_NOTFOUND; /* no executable */
			lv_conf.send_enabled=SEND_UNRECOVERABLE;
			return -1;
		}
	} else {
		lv_conf.encoder_active=ENCODER_INVALID; /* unsupported encoder */
		lv_conf.send_enabled=SEND_UNRECOVERABLE;
		return -1;
	}
	
	pipe(send_pipe);
	pipe(retn_pipe);

	enc_pid=fork();
	
	if(enc_pid<0){
		/* error forking the process */
		lv_conf.encoder_active=ENCODER_PANIC;/* can't fork new encoder */
		lv_conf.send_enabled=SEND_UNRECOVERABLE;

		return -1;
	} if(enc_pid>0) {
		close(send_pipe[0]);
		close(retn_pipe[1]);
		lv_conf.write_fd = send_pipe[1];
		lv_conf.read_fd  = retn_pipe[0];
		lv_conf.enc_pid = enc_pid;
	} else {
		/*fprintf(stdout,"Launching encoder\n");*/
		close(send_pipe[1]);
		close(retn_pipe[0]);
		close(0);
		close(1);
		close(2);
		dup(send_pipe[0]);
		dup(retn_pipe[1]);
		open("/dev/null",O_WRONLY);
		/*close(send_pipe[0]);
		  close(retn_pipe[1]);*/
		
		for(i=3;i<100;i++){
			close(i);
		}
		if(lv_conf.encoder==MP3ENC){

			sprintf(br,"%d",lv_conf.bitrate);
			sprintf(sr,"%d",lv_conf.sample_rate);	
			sprintf(ch,"%d",lv_conf.channels);	
			execlp(lv_conf.encoder_path,lv_conf.encoder_path,"-sti","-sto","-qual","1","-br",br,"-nc",ch,"-sr",sr,NULL);

		} else if(lv_conf.encoder==LAME3){

			sprintf(br,"%d",lv_conf.bitrate/1000);
			sprintf(sr,"%f",lv_conf.sample_rate/1000.0);	
			if(lv_conf.channels==1){
				sprintf(ch,"m");
			} else {
				sprintf(ch,"j");
			}
			/* note that -x is needed on little endian systems - I might need to check some audio format stuff and have this switched */
			fprintf(stderr,"%s %s %s %s\n",lv_conf.encoder_path,br,sr,ch);
			execlp(lv_conf.encoder_path,lv_conf.encoder_path,"-s",sr,"-b",br,"-m",ch,"-x","-","-",NULL);
		}
		fprintf(stderr,"bugger - I was sure there was an encoder here somewhere\n");
		exit(1);
	}		
	/* now - set the read pipe to non-blocking */
	fcntl(lv_conf.read_fd,F_SETFL,O_NONBLOCK);
	signal(SIGPIPE,SIG_IGN);
	lv_conf.encoder_active=ENCODER_OK;
}

static int icy_login(int sd) {
        char buffer[4096];
	
        /* write the password first */
        sprintf(buffer, "%s\n",lv_conf.password);
        write(sd, buffer, strlen(buffer));

        /* now look for OK response */
        read(sd,buffer,3);  /* "OK\n" */
        buffer[2]=0;
        if (buffer[0] != 'O' && buffer[0] != 'o')
        {
		lv_conf.send_enabled=-4; /* connection not accepted */
                return -1;
        }

        /* send the bitrate */
        if(lv_conf.encoder!=XING_VBR){
                sprintf(buffer, "icy-br:%d\n", lv_conf.bitrate / 1000);
        } else {
                sprintf(buffer, "icy-br:VBR%d\n",lv_conf.vbr_quality);
                }
        write(sd, buffer, strlen(buffer));

        /* stream name */
        sprintf(buffer, "icy-name:%s\n",lv_conf.name);
        write(sd, buffer, strlen(buffer));

        /* genre */
        sprintf(buffer, "icy-genre:%s\n",lv_conf.genre);
        write(sd, buffer, strlen(buffer));

        /* URL */
        sprintf(buffer, "icy-url:%s\n",lv_conf.url);
        write(sd, buffer, strlen(buffer));

        /* Public or private? */
        sprintf(buffer, "icy-pub:%d\n",lv_conf.public);
        write(sd, buffer, strlen(buffer));

        /* Finally a newline */
        sprintf(buffer, "\n");
        write(sd, buffer, strlen(buffer));

        return 0;
}


int x_audio_login(int sd){
        char buffer[4096];
        /* x-audiocast style headers */
        /* send password */
        sprintf(buffer,"SOURCE %s ",lv_conf.password);
        write(sd, buffer, strlen(buffer));

        /* send the mountpoint string */
        sprintf(buffer,"/%s\n\n", (lv_conf.mountpoint[0] == '/' ? &(lv_conf.mountpoint[1]) : lv_conf.mountpoint));
        write(sd, buffer, strlen(buffer));

        /* send the Bitrate */
        if(lv_conf.encoder!=XING_VBR){
                sprintf(buffer, "x-audiocast-bitrate:%d\n", lv_conf.bitrate / 
1000);
        } else {
                sprintf(buffer,"x-audiocast-bitrate:VBR%d\n",lv_conf.vbr_quality);
        }

        /* stream name */
        write(sd, buffer, strlen(buffer));
        sprintf(buffer, "x-audiocast-name:%s\n",lv_conf.name);

        /* genre */
        write(sd, buffer, strlen(buffer));
        sprintf(buffer, "x-audiocast-genre:%s\n",lv_conf.genre);

        /* URL */
        write(sd, buffer, strlen(buffer));
        sprintf(buffer, "x-audiocast-url:%s\n",lv_conf.url);

        /* Public or private? */
        write(sd, buffer, strlen(buffer));
        sprintf(buffer, "x-audiocast-public:%d\n",lv_conf.public);

        /* Description string */
        write(sd, buffer, strlen(buffer));
        sprintf(buffer, "x-audiocast-description:%s\n",lv_conf.description);
        write(sd, buffer, strlen(buffer));
	

	/* if we've got a dumpfile which makes sense */
        if(lv_conf.remote_dumpfile_enable){
	  sprintf(buffer,"x-audiocast-dumpfile:%s\n",lv_conf.remote_dumpfile);
	  write(sd, buffer, strlen(buffer));
        }
	
        sprintf(buffer, "\n");
        write(sd, buffer, strlen(buffer));
        return 0;
}



static int open_connection(void) {
	int sd;
/*	lv_conf.send_fd = open("/home/peter/test.mp3",O_WRONLY | O_CREAT | O_TRUNC);
	perror("oops");
	return 0;*/
	if ((liveice_sp = sopen()) == 0){
	        /* unable to open a socket */
		lv_conf.send_enabled=SEND_UNRECOVERABLE;
		lv_conf.connection_active=CONNECTION_UNABLE;
		return -1;
	}
	if ((sd = sclient(liveice_sp, lv_conf.server, lv_conf.port)) == -1){
		sclose(liveice_sp);
		/* Can't bind to the socaket */
		lv_conf.send_enabled=SEND_UNRECOVERABLE;
		lv_conf.connection_active=CONNECTION_UNABLE;
		return -1;
	} 
	lv_conf.send_fd=sd;
        /* connection was successfuil */
	if(lv_conf.header_format){
		if(x_audio_login(lv_conf.send_fd)){
			sclose(liveice_sp);
			lv_conf.send_enabled=SEND_UNRECOVERABLE;
			lv_conf.connection_active=CONNECTION_REFUSED; 
			return -1;
		}	
	} else {
		if(icy_login(lv_conf.send_fd)){
			sclose(liveice_sp);
			lv_conf.send_enabled=SEND_UNRECOVERABLE;
			lv_conf.connection_active=CONNECTION_REFUSED; 
			return -1;
		}	
	}
	lv_conf.connection_active=CONNECTION_OK;
	return 0;
}

static void open_and_start_stream(void) {

	if(lv_conf.send_enabled){
		close_and_kill_stream();
	}
	
	/* open the remote connection */
	/* if not then quit */
	if(open_connection()<0){
		return;
	}
	
	if(launch_encoder()<0){ 
	        return;
	}
	
	/* ok in theory both the necoder and connection should be OK */
	if((lv_conf.connection_active == CONNECTION_OK) && (lv_conf.encoder_active == ENCODER_OK)) {
		lv_conf.send_enabled=SEND_OK;
	} else {
	        fprintf(stderr,"Yikes.... something isn't right\n Our system thinks it's ok... but it's not\n");
	}
}



static void cleanup(void)
{
	close_and_kill_stream();
}

static void range(int *v)
{
	if (*v < -32768)
		*v = -32768;
	if (*v > 32767)
		*v = 32767;
}



int encode_samples(short *samples,int num,int freq,int chan){
	int wrnum,wrtot;
	int rdnum,rdtot;
	short *sptr;
	char buff[4096];
	char *bptr;
	guint buf_size,buf_samples;
	static short *mod_buf=NULL;
	static guint old_buf_size=0;
	
	if(lv_conf.send_enabled!=SEND_OK){
	         fprintf(stderr,"encode samples called without encoder or connection\n");
	}

	/* figure out how big an output buffer we need */
	/* doh! this was causing all sorts of problems */
	buf_samples = (( num * lv_conf.sample_rate ) / freq);
	buf_size = buf_samples*2*lv_conf.channels;

	if(buf_size!=old_buf_size){
	  mod_buf = g_realloc(mod_buf,buf_size);	
	}
	convert_audio(samples,mod_buf,chan,lv_conf.channels,num,buf_samples);
	
	wrtot=buf_size;
	sptr=mod_buf;
	/* first see if we can read anything */
	/*fprintf(stderr,"trying to write data\n");*/
	while(wrtot>0){
		/* read and send bytes */
		rdnum=read(lv_conf.read_fd,buff,4096);
		if(rdnum<0){
			/* some problem reading  */
			if(errno!=EAGAIN){
				lv_conf.send_enabled=SEND_ERROR;
				lv_conf.encoder_active=ENCODER_ERROR; 
				return -1;
			}
		} else if (rdnum>0){

			/*fprintf(stderr,"Read %s bytes from encoder\n",rdnum);*/
			/* write data to the server */
			rdtot=rdnum;
			bptr=buff;
			while(rdtot>0){
				rdnum=write(lv_conf.send_fd,bptr,rdtot);
				if(rdnum<0){
					if(errno!=EAGAIN){
						lv_conf.send_enabled=SEND_ERROR;
						lv_conf.connection_active=CONNECTION_DISCONNECT;
						return -1;
					}
				} else {
					rdtot-=rdnum;
					bptr+=rdnum;
				}
			}
		}
		
		/* now try writing the data to the encoder */
		wrnum=write(lv_conf.write_fd,sptr,wrtot);
		if(wrnum<0){
			/* some error in writing */
			if(errno!=EAGAIN){
				lv_conf.send_enabled=SEND_ERROR;
				lv_conf.encoder_active=ENCODER_ERROR;
				return -1;
			}
		} else if (wrnum>0){
			wrtot-=wrnum;
			sptr+=wrnum;
		}
		/* now maybe add a small sleep */
		if((wrtot>0)&&(wrnum<=0))
			usleep(50000);
	}
	     
	return num;
}

/* handle all teh restarts and whatnot */

static int diagnose_problem(void){
  static time_t last=0;
	time_t now;
	if(last==0){
	        time(&last);
		last=last-300;
	}
	time(&now);
	if(lv_conf.send_enabled==SEND_UNRECOVERABLE){
	  /* bugger */
	  return;
	} else if(lv_conf.send_enabled==SEND_SHUTDOWN){
	  /* stuck here.... */
	  return;
	} else if(lv_conf.send_enabled==SEND_ERROR){
	        if(lv_conf.connection_active==CONNECTION_DISCONNECT){
		        /* connection has been dropped - so try and restart */
		        /* free the old variable */
		        sclose(liveice_sp);
			close(lv_conf.send_fd);
			lv_conf.connection_active=CONNECTION_INIT;
			if(open_connection()<0){
		                /* another error - not likely to be a good sign */
		                lv_conf.send_enabled=SEND_UNRECOVERABLE;
				return -1;
			}
			lv_conf.send_enabled=SEND_OK;
		}
		if(lv_conf.encoder_active==ENCODER_ERROR){
		        /* encoder has probably died - or has closed pipes */
		        /* kill it an restart */
		        /* if the PID isn't set then something is wrong */
		        if(lv_conf.enc_pid>0){
			          kill(lv_conf.enc_pid,9);
			} else {
		                   fprintf(stderr,"Somehow we want to restart an encoder which was never started\n");
				   lv_conf.send_enabled=SEND_UNRECOVERABLE;
			}
			/* close the fd's */
			close(lv_conf.read_fd);
			close(lv_conf.write_fd);
			/* now check to see if respawn is happening too quickly */
			if((now-last)<5){
			        lv_conf.send_enabled=SEND_UNRECOVERABLE;
				lv_conf.encoder_active=ENCODER_PANIC;
			} else {
			        last=now;
			}
			lv_conf.encoder_active=ENCODER_INIT;
			
			if(launch_encoder()<0){    
			        lv_conf.send_enabled=SEND_UNRECOVERABLE;
				return -1;
			} 
			
			lv_conf.send_enabled=SEND_OK;  		    
		} 
	} else if(lv_conf.send_enabled==SEND_RESTART_ENC){
	        /* shutdown the encoder and restart... */
	        if(lv_conf.enc_pid>0){
		        kill(lv_conf.enc_pid,9);
		} 
		/* close the fd's */
		close(lv_conf.read_fd);
		close(lv_conf.write_fd);
		lv_conf.encoder_active=ENCODER_INIT;
		if(launch_encoder()<0){    
		        return -1;
		} 
		lv_conf.send_enabled=SEND_OK;

	} else if(lv_conf.send_enabled==SEND_RESTART_ALL){
	        /*shutdown the connection*/
	        if(liveice_sp)
		        sclose(liveice_sp);
		close(lv_conf.send_fd);
		lv_conf.connection_active=CONNECTION_INIT;
		if(open_connection()<0){
				return -1;
			}
	        /* shutdown the encoder and restart... */
	        if(lv_conf.enc_pid>0){
		        kill(lv_conf.enc_pid,9);
		} 
		/* close the fd's */
		close(lv_conf.read_fd);
		close(lv_conf.write_fd);
		lv_conf.encoder_active=ENCODER_INIT;
		if(launch_encoder()<0){    
		        return -1;
		} 
		lv_conf.send_enabled=SEND_OK;
	} else if(lv_conf.send_enabled=SEND_SHUTDOWN_RQST){
	        /* this shouldn't end up happening - but just in case */
	        if(liveice_sp)
		        sclose(liveice_sp);
		close(lv_conf.send_fd);
		lv_conf.connection_active==CONNECTION_INIT;
		/* shutdown the encoder and restart... */
	        if(lv_conf.enc_pid>0){
		        kill(lv_conf.enc_pid,9);
		} 
		/* close the fd's */
		close(lv_conf.read_fd);
		close(lv_conf.write_fd);
		lv_conf.encoder_active==ENCODER_INIT;
		lv_conf.send_enabled=SEND_SHUTDOWN;
	} 
	
}

char * url_encode(char *string){
        char *target;
	int i,j;
	char k;
	target=malloc(strlen(string)*3 + 2);
	i=j=0;
	while(string[i]!=0){
		if(isalnum(string[i])){
			target[j]=string[i];
			j++;
		} else if(string[i]==' '){
			target[j]='+';
			j++;
		} else {
			sprintf(&target[j],"%%%02x",string[i]);
			j+=3;
		}
		i++;
	}
	target[j]=0;
	return target;
}


int update_meta_info_on_server (char *name){
        sckt *sp;
        int sd;
	char mesg[4096];
	char *esc_pass,*esc_mount,*esc_name;

        sp=sopen();
        if ((sd = sclient(sp, lv_conf.server, lv_conf.port)) == -1){
                fprintf(stderr,"error connecting to update metadata");
	        sclose(sp);
                return 1;
	} else {
	        esc_pass=url_encode(lv_conf.password);
		esc_mount=url_encode(lv_conf.mountpoint);
		esc_name=url_encode(name);
	        sprintf(mesg, "GET /admin.cgi?pass=%s&mode=updinfo&mount=%s&song=%s HTTP/1.0\nHost:%s:%d\nUser-Agent: liveice-xmms\n\n", esc_pass,lv_conf.mountpoint,esc_name,lv_conf.server,lv_conf.port);	
		free(esc_pass);
		free(esc_mount);
		free(esc_name);
		write(sd,mesg,strlen(mesg));
                sclose(sp);

	}
}


static void check_song_title(void){
  static gchar *title,*oldtitle=NULL;
  struct timespec delay;
  gint pos;
  if(oldtitle==NULL){
    oldtitle=strdup("START");
  }

  while(stream_running < 30){
    xmms_usleep(2000000);
    if(!stream_running){
      if(xmms_remote_is_running(0)) {

	pos = xmms_remote_get_playlist_pos(0);
	title = xmms_remote_get_playlist_title(0,pos);
	
	if(strcmp(title,oldtitle) && lv_conf.title_streaming && lv_conf.header_format){
	  /* it's changed - time to tell everone */
	  update_meta_info_on_server (title);
	  /* change over teh chunks of memory */
	  free(oldtitle);
	  oldtitle=title;
	}
      } 
    }
    stream_running++;
  }
  /* in theory this means the stream isn't running any more */
  /* try cleaning up */
  /*close_and_kill_stream();  stoopid */
  if(lv_conf.enc_pid>0){
    kill(lv_conf.enc_pid,9);
  }
  wait();
  title_thread_on=0;
}

static int send_stream(gpointer * d, gint length, AFormat afmt, gint srate, gint nch)
{
	int i, in, out, buf, tmp, r_ofs;
	gint16 *data = (gint16 *) * d;
	pthread_attr_t my_attr;
	/* reset this all the time */
	stream_running=0;
	
	/* ok... we want everythign in native format.... because I'm lazy */
	/* this is going to break on sparcs and other big endian processors */
	if (!(afmt == FMT_S16_NE || (afmt == FMT_S16_LE && G_BYTE_ORDER == G_LITTLE_ENDIAN) || (afmt == FMT_S16_BE && G_BYTE_ORDER == G_BIG_ENDIAN)))
		return length;	
	/* right OK.... we've been called */
	/* start up or try to fix a problem */
	if(lv_conf.send_enabled==SEND_INIT){
	  open_and_start_stream();
	} else if(lv_conf.send_enabled<0){
	  diagnose_problem();
	} 
	
	/* title thread is now the maintenance thread */
	if(!title_thread_on){
	  title_thread_on=1;
	  pthread_attr_init(&my_attr);
	  pthread_attr_setdetachstate(&my_attr, PTHREAD_CREATE_DETACHED);
	  pthread_create(&title_thread, &my_attr, check_song_title , NULL);
	}

	if(lv_conf.send_enabled==SEND_OK) 
		encode_samples(*d,length/(2*nch),srate,nch);
	return length;
}
