/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.CorruptHeaderException;
import helliker.id3.NoMPEGFramesException;
import helliker.id3.XingVBRHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MPEGAudioFrameHeader {
    public static final int MPEG_V_25 = 0;
    public static final int MPEG_V_2 = 2;
    public static final int MPEG_V_1 = 3;
    public static final int MPEG_L_3 = 1;
    public static final int MPEG_L_2 = 2;
    public static final int MPEG_L_1 = 3;
    public static final int MONO_MODE = 3;
    private final String TAG_START;
    private final int HEADER_SIZE;
    private final int MAX_TRIES;
    private final int[][] bitrateTable = new int[][]{{-2, -2, -2, -2, -2}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-1, -1, -1, -1, -1}};
    private final int[][] sampleTable = new int[][]{{44100, 22050, 11025}, {48000, 24000, 12000}, {32000, 16000, 8000}, {-1, -1, -1}};
    private final String[] versionLabels = new String[]{"MPEG Version 2.5", null, "MPEG Version 2.0", "MPEG Version 1.0"};
    private final String[] layerLabels = new String[]{null, "Layer III", "Layer II", "Layer I"};
    private final String[] channelLabels = new String[]{"Stereo", "Joint Stereo (STEREO)", "Dual Channel (STEREO)", "Single Channel (MONO)"};
    private final String[] emphasisLabels = new String[]{"none", "50/15 ms", null, "CCIT J.17"};
    private final int[] slotLength = new int[]{-1, 1, 1, 4};
    private XingVBRHeader xingHead = null;
    private File mp3 = null;
    private int version;
    private int layer;
    private int bitRate;
    private int sampleRate;
    private int channelMode;
    private boolean copyrighted;
    private boolean crced;
    private boolean original;
    private boolean privateBit;
    private int emphasis;
    private long location;
    private int frameLength;
    private boolean padding;

    private final long findOffset(RandomAccessFile randomAccessFile, long l, int n) throws CorruptHeaderException, IOException {
        byte[] byArray;
        String string;
        long l2 = -1L;
        randomAccessFile.seek(l);
        long l3 = l;
        if (l == 0L && (string = new String(byArray = new byte[]{randomAccessFile.readByte(), randomAccessFile.readByte(), randomAccessFile.readByte()})).equals("ID3")) {
            randomAccessFile.seek(randomAccessFile.getFilePointer() + 3L);
            byte[] byArray2 = new byte[]{randomAccessFile.readByte(), randomAccessFile.readByte(), randomAccessFile.readByte(), randomAccessFile.readByte()};
            l3 = BinaryParser.convertToSynchsafeInt(byArray2);
        }
        randomAccessFile.seek(l3);
        boolean bl = true;
        while (l2 == -1L) {
            byte by = randomAccessFile.readByte();
            if (!BinaryParser.matchPattern(by, "11111111")) continue;
            by = randomAccessFile.readByte();
            if (BinaryParser.matchPattern(by, "111xxxxx") && !BinaryParser.matchPattern(by, "xxxxx00x")) {
                by = randomAccessFile.readByte();
                if (!BinaryParser.matchPattern(by, "1111xxxx") && !BinaryParser.matchPattern(by, "xxxx11xx")) {
                    by = randomAccessFile.readByte();
                    if (!BinaryParser.matchPattern(by, "xxxxxx10")) {
                        l2 = randomAccessFile.getFilePointer() - 4L;
                        continue;
                    }
                    randomAccessFile.seek(randomAccessFile.getFilePointer() - 3L);
                    continue;
                }
                randomAccessFile.seek(randomAccessFile.getFilePointer() - 2L);
                continue;
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() - 1L);
        }
        return l2;
    }

    private final void readHeader(RandomAccessFile randomAccessFile, long l) throws IOException, CorruptHeaderException {
        byte[] byArray = new byte[4];
        randomAccessFile.seek(l);
        if (randomAccessFile.read(byArray) != 4) {
            throw new CorruptHeaderException("Error reading MPEG frame header.");
        }
        this.version = BinaryParser.convertToDecimal(byArray[1], 3, 4);
        this.layer = BinaryParser.convertToDecimal(byArray[1], 1, 2);
        this.findBitRate(BinaryParser.convertToDecimal(byArray[2], 4, 7));
        this.findSampleRate(BinaryParser.convertToDecimal(byArray[2], 2, 3));
        this.padding = BinaryParser.bitSet(byArray[2], 1);
        this.privateBit = BinaryParser.bitSet(byArray[2], 0);
        this.channelMode = BinaryParser.convertToDecimal(byArray[3], 6, 7);
        this.copyrighted = BinaryParser.bitSet(byArray[3], 3);
        this.crced = !BinaryParser.bitSet(byArray[1], 0);
        this.original = BinaryParser.bitSet(byArray[3], 2);
        this.emphasis = BinaryParser.convertToDecimal(byArray[3], 0, 1);
    }

    private final void findBitRate(int n) {
        int n2 = -1;
        if (this.version == 3) {
            if (this.layer == 3) {
                n2 = 0;
            } else if (this.layer == 2) {
                n2 = 1;
            } else if (this.layer == 1) {
                n2 = 2;
            }
        } else if (this.version == 2 || this.version == 0) {
            if (this.layer == 3) {
                n2 = 3;
            } else if (this.layer == 2 || this.layer == 1) {
                n2 = 4;
            }
        }
        if (n2 != -1 && n >= 0 && n <= 15) {
            this.bitRate = this.bitrateTable[n][n2];
        }
    }

    private final void findSampleRate(int n) {
        int n2 = -1;
        switch (this.version) {
            case 3: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 2;
            }
        }
        if (n2 != -1 && n >= 0 && n <= 3) {
            this.sampleRate = this.sampleTable[n][n2];
        }
    }

    public int getFrameLength() {
        int n = -1;
        int n2 = 0;
        if (this.padding) {
            n2 = this.slotLength[this.layer];
        }
        n = this.layer == 3 ? (12 * (this.bitRate * 1000) / this.sampleRate + n2) * 4 : 144 * (this.bitRate * 1000) / this.sampleRate + n2;
        return n;
    }

    public String toString() {
        String string = new String();
        string = this.getVersion() + " " + this.getLayer() + "\nBitRate:\t\t\t" + this.getBitRate() + "kbps\nSampleRate:\t\t\t" + this.getSampleRate() + "Hz\nChannelMode:\t\t\t" + this.getChannelMode() + "\nCopyrighted:\t\t\t" + this.isCopyrighted() + "\nOriginal:\t\t\t" + this.isOriginal() + "\nCRC:\t\t\t\t" + this.isProtected() + "\nEmphasis:\t\t\t" + this.getEmphasis() + "\nOffset:\t\t\t\t" + this.getLocation() + "\nPrivateBit:\t\t\t" + this.privateBitSet() + "\nPadding:\t\t\t" + this.hasPadding() + "\nFrameLength:\t\t\t" + this.getFrameLength() + "\nVBR:\t\t\t\t" + this.isVBR() + "\nNumFrames:\t\t\t\t" + this.getNumFrames();
        if (this.isVBR()) {
            string = string + "\n" + this.xingHead.toString();
        }
        return string;
    }

    public String getVersion() {
        String string = null;
        if (this.version >= 0 && this.version < this.versionLabels.length) {
            string = this.versionLabels[this.version];
        }
        return string;
    }

    public String getLayer() {
        String string = null;
        if (this.layer >= 0 && this.layer < this.layerLabels.length) {
            string = this.layerLabels[this.layer];
        }
        return string;
    }

    public String getChannelMode() {
        String string = null;
        if (this.channelMode >= 0 && this.channelMode < this.channelLabels.length) {
            string = this.channelLabels[this.channelMode];
        }
        return string;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isCopyrighted() {
        return this.copyrighted;
    }

    public boolean isProtected() {
        return this.crced;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public boolean isVBR() {
        return this.xingHead.headerExists();
    }

    public String getEmphasis() {
        String string = null;
        if (this.emphasis >= 0 && this.emphasis < this.emphasisLabels.length) {
            string = this.emphasisLabels[this.emphasis];
        }
        return string;
    }

    public long getLocation() {
        return this.location;
    }

    public boolean isMP3() {
        return this.layer == 1;
    }

    public boolean hasPadding() {
        return this.padding;
    }

    public boolean privateBitSet() {
        return this.privateBit;
    }

    public int getVBRPlayingTime() {
        return this.xingHead.getPlayingTime();
    }

    public int getBitRate() {
        int n = 0;
        n = this.xingHead.headerExists() ? this.xingHead.getAvgBitrate() : this.bitRate;
        return n;
    }

    public int getNumFrames() {
        int n = 0;
        n = this.xingHead.headerExists() ? this.xingHead.getNumFrames() : (int)(this.mp3.length() - this.location) / this.getFrameLength();
        return n;
    }

    public MPEGAudioFrameHeader(File file) throws NoMPEGFramesException, FileNotFoundException, IOException, CorruptHeaderException {
        this(file, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MPEGAudioFrameHeader(File file, int n) throws NoMPEGFramesException, FileNotFoundException, IOException, CorruptHeaderException {
        this.TAG_START = "ID3";
        this.HEADER_SIZE = 4;
        this.MAX_TRIES = 9;
        this.mp3 = file;
        this.version = -1;
        this.layer = -1;
        this.bitRate = -1;
        this.sampleRate = -1;
        this.channelMode = -1;
        this.copyrighted = false;
        this.crced = false;
        this.original = false;
        this.emphasis = -1;
        this.location = -1L;
        this.padding = false;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            this.location = this.findOffset(randomAccessFile, n, 9);
            if (this.location == -1L) {
                throw new NoMPEGFramesException();
            }
            this.readHeader(randomAccessFile, this.location);
            this.xingHead = new XingVBRHeader(randomAccessFile, this.location, this.layer, this.version, this.sampleRate, this.channelMode);
            Object var5_4 = null;
            if (randomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (randomAccessFile == null) throw throwable;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
    }
}

