/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
import java.io.*;
import java.util.*;

public class ResourcesDiff {

    public static final String[] LC = {"de", "fr", "es", "it"};
    private static ResourceBundle mainProps;
    private static ResourceBundle diffProps;
    private static String fstr;
    private static String kvp;
    private static FileWriter fw;
    private static StringBuffer strb = new StringBuffer();
    

    /**
     * Outputs a list of missing identifiers in the property files for the 
     * language codes denoted  in LC, as compared to the default language 
     * master property file.
     * @param dir directory containing the property files.
     * @param mod the name of the property module.
     * @param outdir the directory to write the convenience translation files 
     * to. (optional, if not given $dir is used as $outdir)
     */

    public static void main(String[] argv)
    {
	String outdir;
	String dir = new String(argv[0]);
	String mod = new String(argv[1]);
	String rcstr = new String(dir + "." +  mod);

	try {
	    outdir = new String(argv[2]);
	    File f = new File(outdir);
	    f.mkdirs();
	    System.out.println("setting output directory to " + outdir);

	}
	catch (ArrayIndexOutOfBoundsException e) {
	    outdir = dir;
	}
	    
	try {
  	    mainProps = ResourceBundle.getBundle(rcstr, Locale.getDefault()); 
	} 
	catch (MissingResourceException e) {
            System.err.println(dir + "/" + mod +  " not found");
	}
	
	moveFiles(dir, mod);
	
	for (int i = 0; i < LC.length; i++) {
	    fstr = new String(dir + "." + LC[i]);
	    try {
		diffProps = ResourceBundle.getBundle(fstr, Locale.getDefault()); 
	    } 
	    catch (MissingResourceException e) {
		System.err.println(fstr + " not found");
		continue;
	    }

	    System.out.println("  missing keys in " + mod + "_" + LC[i]+
			       ".properties:");
	    System.out.println("  (available in" + outdir + "/" + mod + "_" + 
			       LC[i] + ".missing)");

	    try {
		fw = new FileWriter(outdir + "/" +  mod + "_" + LC[i] 
				    + ".missing");
	    } 
	    catch (IOException ioe) {
		System.err.println("error creating output file");
	    }
	    
	    
	    for (Enumeration e = mainProps.getKeys(); e.hasMoreElements();) {
		Object o = e.nextElement();
		try {
		    diffProps.getString((String)o); 
		}
		catch (MissingResourceException me) {
		    
		    kvp = new String
			(o + "=" + mainProps.getString((String)o) +"\n");
		    strb.append(kvp);
//  		    System.out.print(kvp);
		}
	    }
	}
	
	try {
	    fw.write(strb.toString());
	    fw.close();
	} catch (IOException ioe) {
	    System.err.println("error while writing to file");
	}
  	moveFilesBack(dir, mod);
    }
    
    private static void moveFiles(String dir, String mod)
    {
	for (int i = 0; i < LC.length; i++) {
	    File f = new File(dir + "/" +  mod + "_" + LC[i]+".properties");
	    f.renameTo(new File(dir + "/" + LC[i]+".properties"));
	}
    }
    
    private static void moveFilesBack(String dir, String mod)
    {
	for (int i = 0; i < LC.length; i++) {
	    File f = new File(dir + "/" + LC[i]+".properties");
	    f.renameTo(new File(dir + "/" +  mod + "_" + LC[i]+".properties"));
	}
    }
}


/*
  Local variables:
  compile-command: "jikes +D +P +F ResourcesDiff.java"
  End:
*/


    
