/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.gui.theme.*;
import xnap.plugin.PluginInfo;
import xnap.util.JarClassLoader;

// import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
// import com.l2fprod.gui.plaf.skin.impl.kde2.Kde2Skin;
import java.lang.reflect.*;
import java.util.*;
import javax.swing.*;
import javax.swing.plaf.*;

public class ThemeManager {

    //--- Constant(s) ---

//     static {
// 	try {
// 	    //SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePack("lib/themepack.zip"));
// 	    SkinLookAndFeel.setSkin(new Kde2Skin("/usr/share/apps/kstyle/themes/highcolor.themerc"));
// 	}
// 	catch (Exception e) {
// 	    e.printStackTrace(System.err);
// 	}
//     }

    public static final String[][] EXTRA_LAFS = {
	{ "Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel" },
	{ "Simple", "com.memoire.slaf.SlafLookAndFeel" },
	{ "Oyoaha", "com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel" },
	{ "Metouia", "net.sourceforge.mlf.metouia.MetouiaLookAndFeel" },
	{ "OpenStep", "nextlf.plaf.NextLookAndFeel" },
	{ "GTK", "org.gtk.java.swing.plaf.gtk.GtkLookAndFeel" },
	{ "3D", "swing.addon.plaf.threeD.ThreeDLookAndFeel" },
//  	{ "Skin", "com.l2fprod.gui.plaf.skin.SkinLookAndFeel" },
    };

    public static final Theme[] THEMES = {
	/*new DefaultTheme(),*/
	new BigTheme(),
	new BoldTheme(),
	new PlainTheme(),
	new CustomTheme(),
    };

    protected static Object[] savedDefaults = getDefaults();

    //--- Data field(s) ---

    //--- Constructor(s) ---

    protected ThemeManager()
    {
    }

    //--- Method(s) ---

    public static Object[] getDefaults()
    {
	UIDefaults defaults = UIManager.getDefaults();
	Object[] array = new Object[defaults.size() * 2];
	int i = 0;
	for (Enumeration e = defaults.keys(); e.hasMoreElements(); i += 2) {
	    Object key = e.nextElement();
	    array[i] = key;
	    array[i + 1] = defaults.get(key);
	}
	return array;
    }

    public static void setDefaults(Object[] defaults)
    {
	UIManager.getDefaults().putDefaults(defaults);
    }

    public static void setTheme(String className)
    {
	for (int i = 0; i < THEMES.length; i++) {
	    if (THEMES[i].getClass().getName().equals(className)) {
		setTheme(THEMES[i]);
		return;
	    }
	}
    }

    public static void setTheme(Theme theme)
    {
	UIManager.getDefaults().putDefaults(theme.getProperties());
    }

    public static Theme[] getThemes()
    {
	return THEMES;
    }

    public static Object[] getSavedDefaults()
    {
	return savedDefaults;
    }

    public static UIManager.LookAndFeelInfo[] getInstalledLookAndFeels()
    {
	LinkedList lafs = new LinkedList();
	UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
	if (info != null) {
	    for (int i = 0; i < info.length; i++) {
		try {
		    Class c = JarClassLoader.getInstance().loadClass(info[i].getClassName());
		    Object laf = c.newInstance();
		    Method m = c.getMethod("isSupportedLookAndFeel", null);
		    Object supported = m.invoke(laf, null);
		    if (((Boolean)supported).booleanValue()) {
			lafs.add(info[i]);
		    }
		}
		catch (Exception e) {
		}
	    }
	}
	UIManager.LookAndFeelInfo[] array 
	    = new UIManager.LookAndFeelInfo[lafs.size()];
	System.arraycopy(lafs.toArray(), 0, array, 0, array.length);
	return array;
    }

    public static void installLookAndFeels()
    {
	Hashtable lafsByClassName = new Hashtable();

	for (int i = 0; i < EXTRA_LAFS.length; i++) {
	    addLookAndFeel(lafsByClassName, EXTRA_LAFS[i][1], EXTRA_LAFS[i][0]);
	}

	PluginInfo[] infos = JarClassLoader.getInstance().getPluginInfos();
	for (int i = 0; i < infos.length; i++) {
	    String name = infos[i].getName();
	    String className = infos[i].getClassName();
	    if (name != null && className != null) {
		addLookAndFeel(lafsByClassName, className, name);
	    }
	}

	// some look and feels install themselfs in their constructor
	// therefore we collect all look and feels first and then
	// check if they are installed already
	UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
	if (info != null) {
	    for (int i = 0; i < info.length; i++) {
		lafsByClassName.remove(info[i].getClassName());
	    }
	}

	for (Iterator i = lafsByClassName.values().iterator(); i.hasNext();) {
	    UIManager.installLookAndFeel((UIManager.LookAndFeelInfo)i.next());
	}
    }
	
    public static void addLookAndFeel(Hashtable lafs, String className, 
				      String name)
    {
	try {
	    Class c = JarClassLoader.getInstance().loadClass(className);
	    Object laf = c.newInstance();
	    //  		Method m = c.getMethod("getName", null);
	    //  		String name = m.invoke(laf, null).toString();

	    lafs.put(className, new UIManager.LookAndFeelInfo(name, className)); 
	}
	catch (Exception e) {
	}
    }

}
