/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.*;
import xnap.gui.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class ChatPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private JTextField jtfAutoJoinChannels;
    private JCheckBox jcbBeepOnChatMessage;
    private JCheckBox jcbBlinkOnChannelJoin;
    private JCheckBox jcbShowChatMsgTime;
    private JCheckBox jcbPrintServerNotifications;
    private JCheckBox jcbAppendServerName;

    private JCheckBox jcbSendChatIgnoreMessage;
    private ValidatedTextField jteChatIgnoreMessage;
    
    //--- Constructor(s) ---

    public ChatPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// auto join channels
        GridBagHelper.addLabel(this, XNap.tr("Auto Join Channels"));
        jtfAutoJoinChannels = new JTextField(prefs.getAutoJoinChannels(), 10);
        GridBagHelper.add(this, jtfAutoJoinChannels);

	// misc panel
	JPanel jpMisc = new JPanel(new GridBagLayout());
	jpMisc.setBorder(new TitledBorder(XNap.tr("Miscellaneous", 1)));

	jcbBeepOnChatMessage = new JCheckBox
	    (XNap.tr("Beep On Chat Message", 1), prefs.getBeepOnChatMessage());
	GridBagHelper.add(jpMisc, jcbBeepOnChatMessage);

	jcbBlinkOnChannelJoin = new JCheckBox
	    (XNap.tr("Blink On Channel Join", 1),
	     prefs.getBlinkOnChannelJoin());
	GridBagHelper.add(jpMisc, jcbBlinkOnChannelJoin);

	jcbShowChatMsgTime = new JCheckBox
	    (XNap.tr("Timestamp Chat Messages", 1),
	     prefs.getShowChatMsgTime());
	GridBagHelper.add(jpMisc, jcbShowChatMsgTime);
	
	jcbAppendServerName = new JCheckBox
	    (XNap.tr("Append Server to User Names ", 1),
	     prefs.getAppendServerNameToChatUser());
	GridBagHelper.add(jpMisc, jcbAppendServerName);

	jcbPrintServerNotifications = new JCheckBox
	    (XNap.tr("Print Server Notifications", 1),
	     prefs.getPrintServerNotificationsInChatWindow());
	GridBagHelper.add(jpMisc, jcbPrintServerNotifications);

	GridBagHelper.add(this, jpMisc);

	JPanel jpChatIgnore = new JPanel(new GridBagLayout());
	jpChatIgnore.setBorder(new TitledBorder
	    (XNap.tr("Notify peer of chat ban", 1)));
	GridBagHelper.add(this, jpChatIgnore);

	jteChatIgnoreMessage = 
	    new ValidatedTextField(prefs.getChatIgnoreMessage(), 20,
				   ValidatedTextField.ANYTHING);

	EnableAction ac = 
	    new EnableAction(XNap.tr("Send Message"),
			     new Component[] { jteChatIgnoreMessage },
			     prefs.getSendChatIgnoreMessage());

	jcbSendChatIgnoreMessage = ac.getCheckBox();

	GridBagHelper.addComponent(jpChatIgnore, jcbSendChatIgnoreMessage);
	GridBagHelper.add(jpChatIgnore, jteChatIgnoreMessage);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setAutoJoinChannels(jtfAutoJoinChannels.getText());
	prefs.setBeepOnChatMessage(jcbBeepOnChatMessage.isSelected());
	prefs.setBlinkOnChannelJoin(jcbBlinkOnChannelJoin.isSelected());
	prefs.setShowChatMsgTime(jcbShowChatMsgTime.isSelected());
	prefs.setAppendServerNameToChatUser(jcbAppendServerName.isSelected());
	prefs.setPrintServerNotificationsInChatWindow
	    (jcbPrintServerNotifications.isSelected());
	prefs.setSendChatIgnoreMessage(jcbSendChatIgnoreMessage.isSelected());
	prefs.setChatIgnoreMessage(jteChatIgnoreMessage.getText());
    }

    public Icon getIcon()
    {
	return XNapFrame.getIcon("mail_generic.png");
    }

    public String getTitle()
    {
	return XNap.tr("Chat");
    }
}
