/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.wizard;

import xnap.*;
import xnap.gui.*;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class GeneralWizardPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private JTextField jteUsername;
    private JTextField jtePassword;
    private JTextField jteEmail;

    //--- Constructor(s) ---

    public GeneralWizardPanel()
    {
	setLayout(new GridBagLayout());

	// user
	JPanel jpUser = new JPanel(new GridBagLayout());
	jpUser.setBorder(new TitledBorder(XNap.tr("Personal", 1)));

        GridBagHelper.addLabel(jpUser, XNap.tr("Username"));
        jteUsername = new ValidatedTextField
	    (prefs.getUsername(), 20, ValidatedTextField.EMAIL);
        GridBagHelper.add(jpUser, jteUsername);
	
        GridBagHelper.addLabel(jpUser, XNap.tr("Password"));
        jtePassword = new ValidatedTextField
	    (prefs.getPassword(), 20, ValidatedTextField.EMAIL);
        GridBagHelper.add(jpUser, jtePassword);

        GridBagHelper.addLabel(jpUser, XNap.tr("Email"));
        jteEmail = new ValidatedTextField
	    (prefs.getEmail(), 20, ValidatedTextField.EMAIL);
        GridBagHelper.add(jpUser, jteEmail);

        GridBagHelper.add(this, jpUser);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setUsername(jteUsername.getText());
	prefs.setPassword(jtePassword.getText());
	prefs.setEmail(jteEmail.getText());
    }

    public String getDescription()
    {
	return XNap.tr("Setup your personal settings.You can leave the defaults if you like.");
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("gohome.png");
    }

    public String getTitle()
    {
	return XNap.tr("General settings");
    }

}
