/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.plugin.INetworkPlugin;
import xnap.net.AutoDownload;
import xnap.util.*;

import java.io.*;
import java.util.*;

/**
 * Immutable.
 */
public abstract class AbstractSearchResult implements ISearchResult {

    //--- Data field(s) ---

    protected String filename;
    protected IUser user;
    protected String hash;
    protected int length;
    protected int bitrate;
    protected int frequency;
    protected INetworkPlugin plugin;
    protected int score;
    protected long size;
    
    //--- Constructor(s) ---
    
    protected  AbstractSearchResult(long size, int bitrate, int frequency,
				    int length, IUser user, String filename, 
				    String hash, INetworkPlugin plugin)
    {
        this.size = size;
        this.filename = filename;
        this.user = user;
        this.hash = hash;
        this.length = length;
        this.bitrate = bitrate;
        this.frequency = frequency;
	this.plugin = plugin;
	this.score = 1;
    }
    
    //--- Method(s) ---

    public boolean equals(Object o)
    {
	if (o instanceof AbstractSearchResult) {
	    AbstractSearchResult sr = (AbstractSearchResult)o;
	    return (getBitrate() == sr.getBitrate()
		    && (getFilename().equals(sr.getFilename()))
		    && (getFilesize() == sr.getFilesize())
		    && (getFrequency() == sr.getFrequency())
		    && (getHash().equals(sr.getHash()))
		    && (getLength() == sr.getLength())
		    && (getUser().equals(sr.getUser())));
	}

	return false;
    }

    public int getBitrate() {
        return bitrate;
    }

    public boolean canGroup()
    {
	return true;
    }

    public abstract IDownload getDownload();
    
    public boolean download(SearchFilter filter, File file)
    {
	AutoDownload d = new AutoDownload(new ISearchResult[] { this }, 
					  filter, file);
	return DownloadQueue.getInstance().add(d);
    }

    public String getFilename() {
        return filename;
    }

    public long getFilesize() {
        return size;
    }

    public int getFrequency() {
        return frequency;
    }

    public String getHash()
    {
	return hash;
    }

    public int getLength() 
    {
        return length;
    }

    public String[] getPath()
    {
	return null;
    }

    public INetworkPlugin getPlugin()
    {
	return plugin;
    }

    public int getScore() 
    {
	return score;
    }

    public ISearchResult[] getSearchResults() 
    {
	return new ISearchResult[] { this };
    }

    public abstract String getShortFilename();

    public String toString()
    {
	return getShortFilename() + ", " + getUser();
    }

    public IUser getUser() 
    {
        return user;
    }
    
}
