/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin;

import xnap.gui.*;
import xnap.util.*;

import java.io.*;
import javax.swing.*;

public abstract class AbstractViewerPlugin extends AbstractPlugin
    implements IViewerPlugin
{
    
    //--- Constant(s) ---

    //--- Data Field(s) ---

    protected ViewerPanel vp;

    //--- Constructor(s) ---

    public AbstractViewerPlugin()
    {
    }

    //--- Method(s) ---

    public abstract String getDescription();

    public Icon getIcon()
    {
	return null;
    }

    public abstract String[] getExtensions();

    public abstract String getName();

    public ViewerPanel handle(File f)
    {
	vp.setFile(f);
	return vp;
    }

    public void start()
    {
	GUIPluginManager.getGUIInstance().installViewer(getExtensions(), this);

	super.start();
    }

    public void stop()
    {
	super.stop();

	GUIPluginManager.getGUIInstance().removeViewer(getExtensions(), this);
	vp = null;
    }


}
