/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.gui;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

import xnap.gui.AbstractPanel;
import xnap.gui.ConsolePane;
import xnap.gui.XNapFrame;
import xnap.plugin.gift.net.Engine;
import xnap.plugin.gift.net.event.DebugEvent;
import xnap.plugin.gift.net.event.listener.DebugEventListener;
import xnap.plugin.gift.util.GiftPreferences;
import xnap.util.Preferences;

public class DaemonPanel extends AbstractPanel implements Runnable, DebugEventListener {

    //--- Constant(s) ---
    
    //--- Data field(s) ---

    private GiftPreferences giftPrefs = GiftPreferences.getInstance();
    private Preferences prefs = Preferences.getInstance();

    private JLabel jlStatus;
    private ConsolePane cp;
    private DaemonControlAction daemonControlAction 
	= new DaemonControlAction();

    private Process daemon = null;

    //--- Constructor(s) ---
    
    public DaemonPanel()
    {
	initialize ();
	Engine.getInstance().addEventListener(this);
	Engine.getInstance().setDebug(true);
    }
    
    //--- Method(s) ---

    public void initialize() 
    {
	// status
	jlStatus = new JLabel("Output");

	// console
	cp = new ConsolePane();
	cp.append("giFT Debug View\n\n");

	/* me */
	setBorder(new EmptyBorder(5, 5, 5, 5));
	setLayout(new java.awt.BorderLayout());
	add(jlStatus, "North");
	add(cp, "Center");
    }
    
    public void run()
    {
	if (daemon == null)
	    return;

	try {
	    BufferedReader in = new BufferedReader
		(new InputStreamReader(daemon.getInputStream()));
	    
	    String s;
	    while ((s = in.readLine()) != null) {
		cp.appendLater(s + "\n");
	    }
	}
	catch (IOException e) {
	}
    }

    public boolean start()
    {
	String args[] = {
	    giftPrefs.getGiftDaemon()
	};

	try {
	    daemon = Runtime.getRuntime().exec(args);
	    (new Thread(this, "GiftDaemon")).start();
	}
	catch (IOException e) {
	    return false;
	}

	return true;
    }

    public void stop()
    {
	daemon.destroy();
	daemon = null;
    }

    public boolean isRunning() 
    {
	return (daemon != null);
    }

    public synchronized void setMyStatus(String newValue)
    {
	jlStatus.setText(newValue);
    }

    public AbstractAction[] getActions()
    {
	return (new AbstractAction[] { daemonControlAction });
    }


    /**
     * 
     */
    private class DaemonControlAction extends AbstractAction {

        public DaemonControlAction() 
	{
            putValue(Action.NAME, "Start");
            putValue(Action.SHORT_DESCRIPTION,
		     "Start giFT daemon" );
	    putValue(Action.SMALL_ICON, XNapFrame.getIcon("1rightarrow.png"));
            putValue(Action.MNEMONIC_KEY, new Integer('S'));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    if (giftPrefs.getGiftDaemon().equals("")) {
		setStatus("giFT Daemon not configured, check preferences");
		return;
	    }

	    if (daemon == null){
		if (start()) {
		    setMyStatus("Output (running)");
		    setStatus("giFT daemon started");
		    putValue(Action.SHORT_DESCRIPTION,
		     "Stop giFT daemon" );
		    putValue(Action.SMALL_ICON, 
			     XNapFrame.getIcon("player_stop.png"));
		    // putValue(Action.NAME, "Stop");
		} 
		else {
		    setStatus("Could not start giFT daemon");
		}
	    }
	    else {
		stop();
		setMyStatus("Output (not running)");
		putValue(Action.SHORT_DESCRIPTION,
		     "Start giFT daemon" );
		putValue(Action.SMALL_ICON, 
			 XNapFrame.getIcon("1rightarrow.png"));
		//putValue(Action.NAME, "Start");
	    }
	}
	
    }
    
	/**
	 * @see xnap.plugin.gift.net.event.listener.DebugEventListener#commandReceived(xnap.plugin.gift.net.event.DebugEvent)
	 */
	public void commandReceived(DebugEvent evt) {
		cp.append("<<");
		cp.append(evt.getCmd().print());
	}

	/**
	 * @see xnap.plugin.gift.net.event.listener.DebugEventListener#commandSent(xnap.plugin.gift.net.event.DebugEvent)
	 */
	public void commandSent(DebugEvent evt) {
		cp.append(">>");
		cp.append(evt.getCmd().print());
	}

}









