/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.gui.table;

import xnap.net.*;
import xnap.util.*;

import java.util.*;
import javax.swing.table.*;

public class StatsTableModel extends AbstractTableModel {

    //--- Constant(s) ---

    private final int MEDIA = 0;
    private final int FILES = 1;
    private final int SIZE = 2;
	private final int USERS = 3;    
    //--- Data field(s) ---

    private Vector rows;

    private final String columnNames[] = {
	"Media", "Files", "Size","Users"
    };

    private final Class columnClasses[];

    //--- Constructor(s) ---

    public StatsTableModel() {
        rows = new Vector();

        Class s = String.class;
        Class l = Long.class;
        columnClasses = (new Class[] {s, l, s, l});
    }

    //--- Method(s) ---

    public Class getColumnClass(int i) {
        return columnClasses[i];
    }

    public AbstractSearchResult getRow(int i) {
        return (AbstractSearchResult)rows.elementAt(i);
    }

    public void add(Object[] o) {
	rows.add(o);
	
	int i = rows.size();
	if (i > 0)
	    i--;

        fireTableRowsInserted(i, i);
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public void clear() {
        int k = rows.size() - 1;
        for (int i = k; i >= 0; i--)
            removeRow(i);

        fireTableRowsDeleted(0, k);
    }

    public String getColumnName(int i) {
        return columnNames[i];
    }

    public int getRowCount() {
        return rows.size();
    }

    public Object getValueAt(int i, int j) {
        if (i >= rows.size()) 
	    return null;

        Object[] o = (Object [])rows.elementAt(i);

        if (j >= o.length) 
	    return null;

	return o[j];
    }

    public boolean isCellEditable(int i, int j) {
        return false;
    }

    public void removeRow(int i) {
        rows.removeElementAt(i);
    }

}
