/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

import xnap.net.AbstractDownload;
import xnap.net.IDownloadContainer;

public class Download extends AbstractDownload {

    // --- Constant(s) ---

    // --- Data field(s) ---

    private HttpURLConnection conn = null;
    private InputStream in = null;
    private SearchResult sr;

    //--- Constructor(s) ---

    public Download(SearchResult sr)
    {
	super(sr.getUser(), sr.getFilesize());

	this.sr = sr;
    } 
    
    //--- Method(s) ---

    public int available() throws IOException
    {
	return in.available();
    }

    public void close() {
        try {
	    if (in != null)
		in.close();
	    if (conn != null)
		conn.disconnect();
        } 
	catch (IOException e) {
        }
    }

    /** 
     * Makes an http connection to the specified url.
     */
    public boolean connect(long offset) throws IOException
    {
	/*URL url = new URL(sr.getAddress());
	conn = (HttpURLConnection)url.openConnection();

	if (conn.getResponseCode() != HttpURLConnection.HTTP_OK) {
	    throw new IOException(conn.getResponseMessage());
	}

	InputStream stream = url.openStream();   
	in = new ThrottledInputStream(new BufferedInputStream(stream));

	return true;*/
	return false;
    }


    public void enqueue(IDownloadContainer p)
    {
	setParent(p);
    }

    /**
     * Reads bytes from input stream.
     */
    public int read(byte[] b) throws IOException
    {
	return in.read(b);
    }

	/**
	 * @see xnap.net.IDownload#dequeue()
	 */
	public void dequeue() {
	}

}
