/*
 * xnap
 *
 * TestClass.java
 * Created on 03.01.2003 by Tammo
 *
 * copyright (c) 2002 by Tammo van Lessen, University of Stuttgart.
 * All Rights Reserved.
 * 
 */
package xnap.plugin.gift.net;

import xnap.plugin.gift.net.event.*;
import xnap.plugin.gift.net.event.DebugEvent;
import xnap.plugin.gift.net.event.listener.*;
import xnap.plugin.gift.net.event.listener.DebugEventListener;
import xnap.plugin.gift.net.event.listener.SharesEventListener;

/**
 * enclosing_type
 * 
 * @author <a href="mailto:tvanlessen@taval.de>Tammo van Lessen</a>
 * @version   CVS $Id: TestClass.java,v 1.1 2003/01/15 16:17:53 squig Exp $
 */
public class TestClass implements DebugEventListener, SharesEventListener {

	public static void main(String[] args) {
		TestClass tc = new TestClass();
		try {
			Engine engine = new Engine("localhost", 1213);
			engine.setDebug(true);
			engine.addEventListener(tc);
			engine.start();
			while (engine.isConnected()) {}
			engine.stop();
			System.out.println("done");
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see xnap.plugin.gift.net.event.DebugEventListener#commandReceived(xnap.plugin.gift.net.event.DebugEvent)
	 */
	public void commandReceived(DebugEvent evt) {
		System.out.println(evt.getClass()+": "+evt);
	}

	/**
	 * @see xnap.plugin.gift.net.event.DebugEventListener#commandSent(xnap.plugin.gift.net.event.DebugEvent)
	 */
	public void commandSent(DebugEvent evt) {
		System.out.println(evt.getClass()+": "+evt);
	}
	/**
	 * @see xnap.plugin.gift.net.event.SharesEventListener#sharesListingStarted(xnap.plugin.gift.net.event.ControlEvent)
	 */
	public void sharesListingStarted(ControlEvent evt) {
		System.out.println(evt.getClass()+": "+evt);
	}
	/**
	 * @see xnap.plugin.gift.net.event.SharesEventListener#shareItemReceived(xnap.plugin.gift.net.event.ShareItemEvent)
	 */
	public void shareItemReceived(ShareItemEvent evt) {
		System.out.println(evt.getClass()+": "+evt);
	}
	/**
	 * @see xnap.plugin.gift.net.event.SharesEventListener#sharesListingFinished(xnap.plugin.gift.net.event.ControlEvent)
	 */
	public void sharesListingFinished(ControlEvent evt) {
		System.out.println(evt.getClass()+": "+evt);
	}

}
