/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net;

import xnap.net.IBrowse;
import xnap.net.IChannel;
import xnap.net.IUser;

import xnap.net.event.StatusChangeListener;

import xnap.user.UserData2;

import java.util.StringTokenizer;


/**
 * User
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: User.java,v 1.4 2003/01/16 01:48:15 taval Exp $
 */
public class User implements IUser {
    //~ Instance fields --------------------------------------------------------

    private String giftUser;
    private String host;
    private String name;
    private boolean temporary;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for User.
     *
     * @param user DOCUMENT ME!
     */
    public User(String user) {
        giftUser = user;

        StringTokenizer st = new StringTokenizer(user, "@");

        if (st.countTokens() == 1) {
            this.name = user;
            this.host = user;
        } else {
            this.name = st.nextToken();
            this.host = st.nextToken();
        }

        this.temporary = true;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * @see xnap.net.IUser#isActionSupported(java.lang.Class)
     */
    public boolean isActionSupported(Class actionClass) {
        return false;
    }

    /**
     * @see xnap.net.IUser#getBrowse()
     */
    public IBrowse getBrowse() {
        return null;
    }

    /**
     * @see xnap.net.IUser#setCategory(java.lang.String)
     */
    public void setCategory(String newValue) {
    }

    /**
     * @see xnap.net.IUser#getCategory()
     */
    public String getCategory() {
        return null;
    }

    /**
     * @see xnap.net.IUser#setChatIgnored(boolean)
     */
    public void setChatIgnored(boolean newValue) {
    }

    /**
     * @see xnap.net.IUser#isChatIgnored()
     */
    public boolean isChatIgnored() {
        return false;
    }

    /**
     * @see xnap.net.IUser#getClientInfo()
     */
    public String getClientInfo() {
        return "giFT";
    }

    /**
     * @see xnap.net.IUser#setComment(java.lang.String)
     */
    public void setComment(String newValue) {
    }

    /**
     * @see xnap.net.IUser#getComment()
     */
    public String getComment() {
        return null;
    }

    /**
     * @see xnap.net.IUser#getData()
     */
    public UserData2 getData() {
        return null;
    }

    /**
     * @see xnap.net.IUser#getFileCount()
     */
    public int getFileCount() {
        return 0;
    }

    /**
     * Returns giFT user
     *
     * @return user
     */
    public String getGiFTName() {
        return giftUser;
    }

    /**
     * @see xnap.net.IUser#getHost()
     */
    public String getHost() {
        return host;
    }

    /**
     * @see xnap.net.IUser#getLinkSpeed()
     */
    public int getLinkSpeed() {
        return 0;
    }

    /**
     * @see xnap.net.IUser#getLocalDownloadCount()
     */
    public int getLocalDownloadCount() {
        return 0;
    }

    /**
     * @see xnap.net.IUser#getLocalUploadCount()
     */
    public int getLocalUploadCount() {
        return 0;
    }

    /**
     * @see xnap.net.IUser#setMaxDownloads(int)
     */
    public void setMaxDownloads(int newValue) {
    }

    /**
     * @see xnap.net.IUser#getMaxDownloads()
     */
    public int getMaxDownloads() {
        return 0;
    }

    /**
     * @see xnap.net.IUser#setMaxUploads(int)
     */
    public void setMaxUploads(int newValue) {
    }

    /**
     * @see xnap.net.IUser#getMaxUploads()
     */
    public int getMaxUploads() {
        return 0;
    }

    /**
     * @see xnap.net.IUser#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * @see xnap.net.IUser#getPrivateChannel()
     */
    public IChannel getPrivateChannel() {
        return null;
    }

    /**
     * @see xnap.net.IUser#getStatus()
     */
    public int getStatus() {
        return STATUS_ONLINE;
    }

    /**
     * @see xnap.net.IUser#getStatusText()
     */
    public String getStatusText() {
        return null;
    }

    /**
     * @see xnap.net.IUser#setTemporary(boolean)
     */
    public void setTemporary(boolean newValue) {
        temporary = newValue;
    }

    /**
     * @see xnap.net.IUser#isTemporary()
     */
    public boolean isTemporary() {
        return temporary;
    }

    /**
     * @see xnap.net.IUser#addStatusChangeListener(xnap.net.event.StatusChangeListener)
     */
    public void addStatusChangeListener(StatusChangeListener l) {
    }

    /**
     * @see xnap.net.IUser#modifyLocalDownloadCount(int)
     */
    public void modifyLocalDownloadCount(int newValue) {
    }

    /**
     * @see xnap.net.IUser#modifyLocalUploadCount(int)
     */
    public void modifyLocalUploadCount(int newValue) {
    }

    /**
     * @see xnap.net.IUser#removeStatusChangeListener(xnap.net.event.StatusChangeListener)
     */
    public void removeStatusChangeListener(StatusChangeListener l) {
    }
}
