/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net.event;

import xnap.plugin.gift.net.DownloadContainer;

import java.util.Vector;


/**
 * DownloadUpdatedEvent
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: DownloadUpdatedEvent.java,v 1.1 2003/01/15 16:17:54 squig Exp $
 */
public class DownloadUpdatedEvent extends Event {
    //~ Instance fields --------------------------------------------------------

    private DownloadContainer dc;
    private String filename;
    private String hash;
    private Vector sources;
    private String state;
    private long elapsed;
    private long size;
    private long throughput;
    private long transmit;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for DownloadUpdatedEvent.
     *
     * @param dc DOCUMENT ME!
     */
    public DownloadUpdatedEvent(DownloadContainer dc) {
        super();
        sources = new Vector();
        this.dc = dc;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * Returns the DownloadContainer.
     *
     * @return DownloadContainer
     */
    public DownloadContainer getDownloadContainer() {
        return dc;
    }

    /**
     * Sets the elapsed.
     *
     * @param elapsed The elapsed to set
     */
    public void setElapsed(long elapsed) {
        this.elapsed = elapsed;
    }

    /**
     * Returns the elapsed.
     *
     * @return long
     */
    public long getElapsed() {
        return elapsed;
    }

    /**
     * Sets the filename.
     *
     * @param filename The filename to set
     */
    public void setFilename(String filename) {
        this.filename = filename;
    }

    /**
     * Returns the filename.
     *
     * @return String
     */
    public String getFilename() {
        return filename;
    }

    /**
     * Sets the hash.
     *
     * @param hash The hash to set
     */
    public void setHash(String hash) {
        this.hash = hash;
    }

    /**
     * Returns the hash.
     *
     * @return String
     */
    public String getHash() {
        return hash;
    }

    /**
     * Sets the size.
     *
     * @param size The size to set
     */
    public void setSize(long size) {
        this.size = size;
    }

    /**
     * Returns the size.
     *
     * @return long
     */
    public long getSize() {
        return size;
    }

    /**
     * Sets the state.
     *
     * @param state The state to set
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * Returns the state.
     *
     * @return int
     */
    public String getState() {
        return state;
    }

    /**
     * Sets the throughput.
     *
     * @param throughput The throughput to set
     */
    public void setThroughput(long throughput) {
        this.throughput = throughput;
    }

    /**
     * Returns the throughput.
     *
     * @return long
     */
    public long getThroughput() {
        return throughput;
    }

    /**
     * Sets the transmit.
     *
     * @param transmit The transmit to set
     */
    public void setTransmit(long transmit) {
        this.transmit = transmit;
    }

    /**
     * Returns the transmit.
     *
     * @return long
     */
    public long getTransmit() {
        return transmit;
    }
	/*CHGDOWNLOAD(2)
	SOURCE
	{
	start(0)
	status(Active)
	total(2425179)
	transmit(41160)
	url(OpenFT://62.108.30.159:2672/.share/cds/cecilia_bartoli/se_tu_mami_-_arie_antiche/04_a._scarlatti__o_cessate_di_piagarmi.mp3)
	user(spif@62.108.30.159)}

	elapsed(951)
	file(04_a._scarlatti__o_cessate_di_piagarmi.mp3)
	hash(4184c229d6a629956755eca3a4f00e79)
	size(2425179)
	state(Active)
	throughput(2824)
	transmit(41160);
	*/

}
