/*
 * 04/02/2001
 *
 * DataOutputStream.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.io;

import java.io.*;


/**
 *
 * @version 0.1 06/22/2001
 * @author Frederik Zimmer
 */

public class DataOutputStream extends FilterOutputStream {

    public DataOutputStream(OutputStream out) {
	super(out);
    }

    public final void writeByte(int v) throws IOException {
	out.write(v);
    }

    public final void writeShort(int v) throws IOException {
	OutputStream out = this.out;
	out.write(v & 0xFF);
	out.write((v >> 8) & 0xFF);
    }
	
    public final void writeChar(int v) throws IOException {
	OutputStream out = this.out;
	out.write(v & 0xFF);
	out.write((v >> 8) & 0xFF);
    }

    /**
     * Writes an <code>int</code> to the underlying output stream as four
     * bytes, high byte first. If no exception is thrown, the counter 
     * <code>written</code> is incremented by <code>4</code>.
     *
     * @param      v   an <code>int</code> to be written.
     * @exception  IOException  if an I/O error occurs.
     * @see        java.io.FilterOutputStream#out
     */
    public final void writeInt(int v) throws IOException {
	OutputStream out = this.out;
	out.write(v & 0xFF);
	out.write((v >> 8) & 0xFF);
	out.write((v >> 16) & 0xFF);
	out.write((v >> 24) & 0xFF);
    }

    /*public final void writeLong(long v) throws IOException {
      OutputStream out = this.out;
      out.write((int)(v >> 56) & 0xFF);
      out.write((int)(v >> 48) & 0xFF);
      out.write((int)(v >> 40) & 0xFF);
      out.write((int)(v >> 32) & 0xFF);
      out.write((int)(v >> 24) & 0xFF);
      out.write((int)(v >> 16) & 0xFF);
      out.write((int)(v >>  8) & 0xFF);
      out.write((int)(v >>  0) & 0xFF);
      }*/

    public final void writeBytes(String s) throws IOException {
	OutputStream out = this.out;
	int len = s.length();
	for (int i = 0 ; i < len ; i++) {
	    out.write((byte) s.charAt(i));
	}
    }
}
