/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.gui;

import xnap.gui.DefaultDialog;
import xnap.gui.EnableAction;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Server;
import xnap.util.PortRange;
import xnap.util.Preferences;
import xnap.util.StringHelper;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class ServerEditorDialog extends DefaultDialog {
    
    //--- Data field(s) ---

    private Server server;

    private JTextField jtHost;
    private ValidatedTextField jtPort;
    private JTextField jtNetwork;
    private JCheckBox jcbCustomizeUser;
    private JTextField jtNick;
    private JTextField jtPassword;
    private JTextField jtEmail;
    private JCheckBox jcbNapigator;

    //--- Constructor(s) ---
    
    public ServerEditorDialog(Server server)
    {
	this.server = server;

	initialize();
    }

    // --- Methods ---

    private void initialize()
    {
        setTitle(Plugin.tr("Server"));

	JPanel jp = getMainPanel();
	jp.setLayout(new GridBagLayout());

	// host
	GridBagHelper.addLabel(jp, Plugin.tr("Host"));
	jtHost = new JTextField(server.getHost(), 20);
	GridBagHelper.add(jp, jtHost);

	// port
	GridBagHelper.addLabel(jp, Plugin.tr("Port"));
	jtPort = new ValidatedTextField
	    (server.getPort() + "", 5, ValidatedTextField.NUMBERS_INT);
	GridBagHelper.add(jp, jtPort, false);
	
	// network
	GridBagHelper.addLabel(jp, Plugin.tr("Network"));
	jtNetwork = new ValidatedTextField(server.getNetwork(), 20,
					   StringHelper.REGULAR_STRING);
	GridBagHelper.add(jp, jtNetwork);

	// user
	JPanel jpUser = new JPanel(new GridBagLayout());
	jpUser.setBorder(new TitledBorder(Plugin.tr("User", 1)));

	boolean custom = server.isLoginCustomized();
	jtNick = new JTextField(server.getUsername(), 20);
	jtPassword = new JTextField(server.getPassword(), 20);
	jtEmail = new JTextField(server.getEmail(), 20);

	Component[] c = new Component[] { jtNick, jtPassword, jtEmail };
	EnableAction ac 
	    = new EnableAction(Plugin.tr("Customize", 1, 1), c, custom);
	jcbCustomizeUser = ac.getCheckBox();
	GridBagHelper.add(jpUser, jcbCustomizeUser);

	GridBagHelper.addLabel(jpUser, Plugin.tr("Nickname"));
	GridBagHelper.add(jpUser, jtNick);

	GridBagHelper.addLabel(jpUser, Plugin.tr("Password"));
	GridBagHelper.add(jpUser, jtPassword);

	GridBagHelper.addLabel(jpUser, Plugin.tr("Email"));
	GridBagHelper.add(jpUser, jtEmail);

	GridBagHelper.add(jp, jpUser);

	// napigator
	jcbNapigator = new JCheckBox(Plugin.tr("Napigator Server"));
	jcbNapigator.setSelected(server.isTemporary());
	GridBagHelper.add(jp, jcbNapigator);

	pack();
    }

    public static void showDialog(Component c, Server s)
    {
	ServerEditorDialog me = new ServerEditorDialog(s);
	if (c != null) {
	    me.setLocationRelativeTo(c);
	}
	me.show();
    }

    public void apply()
    {
	if (jtHost.getText().trim().length() == 0) {
	    throw new IllegalArgumentException("Please provide a hostname.");
	}
	
	int port = jtPort.getIntValue();
	if (port <= 0 || port > PortRange.MAX_PORT) {
	    StringBuffer sb = new StringBuffer();
	    sb.append("Please provide a valid port");
	    sb.append(" (1 - ");
	    sb.append(PortRange.MAX_PORT);
	    sb.append(")");
	    throw new IllegalArgumentException(sb.toString());
	}
	
	server.setHost(jtHost.getText());
	server.setPort(port);
	server.setNetwork(jtNetwork.getText());

	boolean custom = jcbCustomizeUser.isSelected();
	server.setUsername(custom ? jtNick.getText() : null);
	server.setPassword(custom ? jtPassword.getText() : null);
	server.setEmail(custom ? jtEmail.getText() : null);

	server.setTemporary(jcbNapigator.isSelected());
    }

}
