/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.plugin.nap.gui;

import xnap.gui.*;
import xnap.plugin.nap.*;
import xnap.plugin.nap.util.*;


import java.awt.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.border.*;

public class WizardPanel extends AbstractPreferencesPanel {

    //--- Data Field(s) ----

    private NapPreferences napPrefs = NapPreferences.getInstance();

    private JCheckBox jcAutoFetchNapigator;
    private ValidatedTextField jteLocalPort;
    private JCheckBox jcUseAutoconnector;
    
    //--- Constructor(s) ---

    public WizardPanel()
    {
	GridBagLayout gbNap = new GridBagLayout();
	setLayout(gbNap);

	JPanel jpConnection = new JPanel(new GridBagLayout());
	jpConnection.setBorder(new TitledBorder(Plugin.tr("Local Port", 1)));
	GridBagHelper.add(jpConnection,Plugin.tr("Set a local port to receive incoming connections"));
        jteLocalPort 
	    = new ValidatedTextField(napPrefs.getLocalPortRange() + "", 20,
				     ValidatedTextField.NUMBERS_INT + ";-");
	GridBagHelper.add(jpConnection, jteLocalPort, false);

	JPanel jpStartup = new JPanel(new GridBagLayout());
	jpStartup.setBorder(new TitledBorder(Plugin.tr("Startup", 1)));
	GridBagHelper.add(jpStartup, Plugin.tr("Actions to be executed when plugin is loaded."));
	jcAutoFetchNapigator 
	    = new JCheckBox(Plugin.tr("Download Napigator List"), 
                            napPrefs.getAutoFetchNapigator());
        GridBagHelper.add(jpStartup, jcAutoFetchNapigator);
	jcUseAutoconnector = new JCheckBox(Plugin.tr("Use Autoconnector"),
					   napPrefs.getUseAutoconnector());
	GridBagHelper.add(jpStartup, jcUseAutoconnector);
	
	GridBagHelper.add(this, jpConnection);
	GridBagHelper.add(this, jpStartup);
	GridBagHelper.addVerticalSpacer(this);
    }

    //--- Method(s) ---

    public void apply()
    {
	napPrefs.setAutoFetchNapigator(jcAutoFetchNapigator.isSelected());
	napPrefs.setLocalPortRange(jteLocalPort.getText());
	napPrefs.setUseAutoconnector(jcUseAutoconnector.isSelected());
    }

    public String getDescription()
    {
	return Plugin.tr("Configure your OpenNap settings. Ignore the local port setting if you are firewalled.");

    }

    public String getTitle()
    {
	return Plugin.tr("OpenNap settings");
    }


}
