/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.client;

import xnap.io.MP3File;
import xnap.io.VideoFile;
import xnap.util.FileHelper;
import xnap.util.Preferences;
import xnap.util.SearchFilter;
import xnap.util.SearchFilterHelper;
import xnap.plugin.nap.util.NapFileHelper;


import java.io.File;
import java.util.StringTokenizer;

public class ShareFileMessage extends ClientMessage {

    //--- Constant(s) ---

    // FIX ME: we should use 10300
    public static final int TYPE = 100;

    //--- Constructor(s) ---

    public ShareFileMessage(int index, File file)
    {
	super(TYPE);
	
	StringBuffer sb = new StringBuffer();
	sb.append("\"");
	sb.append(NapFileHelper.getShareString(index, file));
	sb.append("\" ");

	if (file instanceof MP3File) {
	    MP3File m = (MP3File)file;
	    // do not calculate md5, send 0 instead
	    sb.append("0 ");
	    sb.append(m.length());
	    sb.append(" ");
	    sb.append(m.getBitrate());
	    sb.append(" ");
	    sb.append(m.getFrequency());
	    sb.append(" ");
	    sb.append(m.getPlayingTime());
	}
	else if (file instanceof VideoFile) {
	    type = 10300;
	    // use new share syntax
	    sb.append(file.length());
	    sb.append(" 0 video");
	}
	else {
	    int mediaType = SearchFilterHelper.getMediatypeFromExtension
		(FileHelper.extension(file.getName()));

	    // treat MEDIA_ANYTHING differently with old share syntax
	    if (mediaType == SearchFilter.MEDIA_ANYTHING) {
		sb.append("0 ");
		sb.append(file.length());
		sb.append(" ");
		sb.append("24 16000 600");
	    }
	    else {
		type = 10300;
		sb.append(file.length() + " 0 ");
		switch(mediaType) {
		case SearchFilter.MEDIA_AUDIO:
		    sb.append("audio");
		    break;
		case SearchFilter.MEDIA_VIDEO:
		    sb.append("video");
		    break;
		case SearchFilter.MEDIA_IMAGES:
		    sb.append("image");
		    break;
		case SearchFilter.MEDIA_SOFTWARE:
		    sb.append("application");
		    break;
		case SearchFilter.MEDIA_DOCUMENTS:
		    sb.append("text");
		    break;
		default:
		    sb.append("text");
		}
	    }
	}

	data = sb.toString();
    }

}
