/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.cmdl.Console;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.util.PrivateChannel;
import xnap.util.QuotedStringTokenizer;

public class ClientStatisticsMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 10118;

    //--- Data Field(s) ---

    public String clientInfo;
    public int connectedCount;

    //--- Constructor(s) ---

    public ClientStatisticsMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 0);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	clientInfo = (t.hasMoreTokens()) ? t.nextToken() : null;
	connectedCount
	    = (t.hasMoreTokens()) ? Integer.parseInt(t.nextToken()) : 0;
    }

    public void received()
    {
	if (clientInfo != null) {
	    StringBuffer sb = new StringBuffer();
	    sb.append("Client: ");
	    sb.append(clientInfo);
	    sb.append(" [");
	    sb.append(connectedCount);
	    sb.append("]");
	    Console.getInstance().println(sb.toString());
	}
    }

}
