/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.user;

import xnap.XNap;
import xnap.net.IUser;
import xnap.util.LinkSpeed;

import java.io.Serializable;

public class UserData2 extends UserData implements Serializable
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    public String category = "";

    public transient int localDownloads = 0;
    public transient int localUploads = 0;

    //--- Constructor(s) ---

    public UserData2(String parentClass, String name)
    {
	super(parentClass, name);
    }

    public UserData2(UserData data)
    {
	super(data.parentClass, data.name);

	this.browseCacheFilename = data.browseCacheFilename;
	this.comment = data.comment;
	this.cacheBrowseResults = data.cacheBrowseResults;
	this.downloadBandwidth = data.downloadBandwidth;
	this.ignoreChat = data.ignoreChat;
	this.maxDownloads = data.maxDownloads;
	this.maxUploads = data.maxUploads;
	this.uploadBandwidth = data.uploadBandwidth;

	this.category = ((this.ignoreChat) 
			 ? XNap.tr("Banned") 
			 : XNap.tr("Hotlist"));
    }

    //--- Method(s) ---

}
