/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3v2Header;
import de.vdheide.mp3.NoMP3FrameException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class MP3Properties {
    public static final int MODE_STEREO = 0;
    public static final int MODE_JOINT_STEREO = 1;
    public static final int MODE_DUAL_CHANNEL = 2;
    public static final int MODE_MONO = 3;
    public static final int EMPHASIS_ILLEGAL = 0;
    public static final int EMPHASIS_NONE = 1;
    public static final int EMPHASIS_5015MS = 2;
    public static final int EMPHASIS_CCITT = 3;
    protected File file;
    protected int level;
    protected int layer;
    protected int bitrate;
    protected int samplerate;
    protected int mode;
    protected int emphasis;
    protected boolean protection;
    protected boolean padding;
    protected boolean privat;
    protected boolean original;
    protected boolean copy;
    protected long length;

    public MP3Properties(File file) throws IOException, NoMP3FrameException {
        this.readProperties(file);
    }

    public int getMPEGLevel() {
        return this.level;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getSamplerate() {
        return this.samplerate;
    }

    public int getMode() {
        return this.mode;
    }

    public int getEmphasis() {
        return this.emphasis;
    }

    public boolean getProtection() {
        return this.protection;
    }

    public boolean getPadding() {
        return this.padding;
    }

    public boolean getPrivate() {
        return this.privat;
    }

    public boolean getCopyright() {
        return this.copy;
    }

    public boolean getOriginal() {
        return this.original;
    }

    public long getLength() {
        return this.length;
    }

    protected void readProperties(File file) throws IOException, NoMP3FrameException {
        this.file = file;
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.mark(15);
        int n = this.skipID3v2(fileInputStream);
        if (n == 0) {
            fileInputStream.close();
            fileInputStream = new FileInputStream(file);
        }
        int n2 = this.synchronize(fileInputStream);
        int n3 = fileInputStream.read();
        int n4 = fileInputStream.read();
        fileInputStream.close();
        this.level = this.convertMPEGLevel(this.getBit(n2, 3));
        this.layer = this.convertLayer(this.getBit(n2, 2), this.getBit(n2, 1));
        this.protection = this.getBit(n2, 0) == 0;
        this.bitrate = this.convertBitrate(this.getBit(n3, 7), this.getBit(n3, 6), this.getBit(n3, 5), this.getBit(n3, 4));
        this.samplerate = this.convertSamplerate(this.getBit(n3, 3), this.getBit(n3, 2));
        this.padding = this.getBit(n3, 1) == 1;
        this.privat = this.getBit(n3, 0) == 1;
        this.mode = this.convertMode(this.getBit(n4, 7), this.getBit(n4, 6));
        this.copy = this.getBit(n4, 3) == 1;
        this.original = this.getBit(n4, 2) == 1;
        this.emphasis = this.convertEmphasis(this.getBit(n4, 1), this.getBit(n4, 0));
        this.length = this.calculateLength(n);
    }

    protected int skipID3v2(FileInputStream fileInputStream) throws IOException {
        ID3v2Header iD3v2Header = null;
        try {
            iD3v2Header = new ID3v2Header(fileInputStream);
        }
        catch (Exception exception) {
            return 0;
        }
        fileInputStream.skip(iD3v2Header.getTagSize());
        return iD3v2Header.getTagSize();
    }

    protected int synchronize(FileInputStream fileInputStream) throws IOException, NoMP3FrameException {
        boolean bl = false;
        int n = 0;
        while (!bl) {
            int n2 = fileInputStream.read();
            while (n2 != 255 && n2 != -1) {
                n2 = fileInputStream.read();
            }
            if (n2 == -1) {
                throw new NoMP3FrameException();
            }
            n = fileInputStream.read();
            if (n >= 224) {
                bl = true;
                continue;
            }
            if (n != -1) continue;
            throw new NoMP3FrameException();
        }
        return n;
    }

    protected int convertMPEGLevel(int n) {
        if (n == 1) {
            return 1;
        }
        return 2;
    }

    protected int convertLayer(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return 0;
        }
        return 4 - ((n << 1) + n2);
    }

    protected int convertBitrate(int n, int n2, int n3, int n4) {
        int[][] nArrayArray = new int[][]{{0, 0, 0, 0, 0, 0}, {32, 32, 32, 32, 32, 8}, {64, 48, 40, 64, 48, 16}, {96, 56, 48, 96, 56, 24}, {128, 64, 56, 128, 64, 32}, {160, 80, 64, 160, 80, 64}, {192, 96, 80, 192, 96, 80}, {224, 112, 96, 224, 112, 56}, {256, 128, 112, 256, 128, 64}, {288, 160, 128, 288, 160, 128}, {320, 192, 160, 320, 192, 160}, {352, 224, 192, 352, 224, 112}, {384, 256, 224, 384, 256, 128}, {416, 320, 256, 416, 320, 256}, {448, 384, 320, 448, 384, 320}, {0, 0, 0, 0, 0, 0}};
        int n5 = n << 3 | n2 << 2 | n3 << 1 | n4;
        int n6 = (this.level - 1) * 3 + this.layer - 1;
        return nArrayArray[n5][n6];
    }

    protected int convertSamplerate(int n, int n2) {
        int n3 = 0;
        switch (n << 1 | n2) {
            case 0: {
                n3 = 44100;
                break;
            }
            case 1: {
                n3 = 48000;
                break;
            }
            case 2: {
                n3 = 32000;
                break;
            }
            case 3: {
                n3 = 0;
            }
        }
        if (this.level == 1) {
            return n3;
        }
        return n3 / 2;
    }

    protected int convertMode(int n, int n2) {
        int[] nArray = new int[]{0, 1, 2, 3};
        return nArray[n << 1 | n2];
    }

    protected int convertEmphasis(int n, int n2) {
        int[] nArray = new int[]{1, 2, 0, 3};
        return nArray[n << 1 | n2];
    }

    protected long calculateLength(int n) {
        return (long)Math.floor((double)((this.file.length() - (long)n) / (long)this.bitrate) * 0.008);
    }

    private int getBit(int n, int n2) {
        if ((n & 1 << n2) > 0) {
            return 1;
        }
        return 0;
    }
}

