/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
 * This is a wrapper class for JavaReadline and the GNU Readline library.
 *
 */
package xnap.cmdl;

import xnap.*;
import xnap.util.*;

import java.io.*;
import java.util.*;


public class Console {

    // --- Data Field(s) ---

    private static Console singleton = new Console();
  
    private boolean prompting = false;
    private StringBuffer outputQueue = new StringBuffer();
    private IConsole handler = null;

    // --- Constructor(s) ---

    private Console()
    {
    }

    // --- Method(s) ---

    public static Console getInstance()
    {
	return singleton;
    }

    public void add(Process p)
    {
	add(p.getInputStream());
	add(p.getErrorStream());
    }

    public void add(InputStream in)
    {
	Thread t = new Thread(new ConsoleWriter(in), "ConsoleWriter");
	t.start();
    }

    public void setConsole(IConsole newValue)
    {
	handler = newValue;
    }

    public boolean isEchoing()
    {
	return (handler != null) ? handler.isEchoing() : false;
    }

    public String readln(String prompt)
    {
	if (handler == null) {
	    return null;
	}

	printQueue();

	prompting = true;
	String s = handler.readLine(prompt);
	prompting = false;

	return s;
    }

    public void printFile(String filename)
    {
	InputStream s = FileHelper.getResourceAsStream(filename);

	if (s == null) {
	    println("File " + filename + " not found");
	    return;
	}

	try {
	    BufferedReader in = 
		new BufferedReader(new InputStreamReader(s));
			
	    while (in.ready())
		outputQueue.append(in.readLine() + "\n");

	    printQueue();
	}
	catch(IOException e) {
	    println("error: " + e.getMessage());
	}
    }

    private void printQueue() 
    {
	println(null);
    }

    public void println(String output)
    {
	if (handler == null) {
	    return;
	}

	if (output != null) {
	    outputQueue.append(output + "\n");
	}

	if (!prompting) {
	    handler.printLine(outputQueue.toString());
	    outputQueue.setLength(0);
	}
    }

    /**
     * Set your completer function.
     *
     * @param rlc An object implementing the ReadlineCompleter interface
     */
    public Completer getCompleter() 
    {
	return (handler != null) ? handler.getCompleter() : null;
    }

}
