/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.XNap;
import xnap.io.ResumeFile3;
import xnap.io.ResumeRepository;
import xnap.net.AutoDownload;
import xnap.util.SearchFilter;
import xnap.util.SearchFilterData;
import xnap.util.SearchFilterHelper;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

/**
 * FIX: This class needs to be rewritten. AutoDownload should handle the
 * search filter and resume repository updates itself.
 */
public class AutoDownloadEditorDialog extends DefaultDialog
{
    
    //--- Data field(s) ---

    private AutoDownload download;

    private JTextField jtFilename;
    private JTextField jtSearchText;
    private JComboBox jcbMediaType;
    private JComboBox jcbBitrateCompare;
    private JComboBox jcbBitrate;

    //--- Constructor(s) ---
    
    private AutoDownloadEditorDialog(AutoDownload download)
    {
	this.download = download;

	initialize(download.getResumeFile());
    }

    // --- Methods ---

    private void initialize(ResumeFile3 file)
    {
        setTitle(XNap.tr("Edit search filter"));
	setModal(true);

	JPanel jp = getMainPanel();
	jp.setLayout(new GridBagLayout());

	// final filename
	GridBagHelper.addLabel(jp, XNap.tr("Final Filename"));
	jtFilename = new JTextField(file.getFinalFilename());
	GridBagHelper.add(jp, jtFilename);

	SearchFilterData data = file.getFilterData();

	// search text
	GridBagHelper.addLabel(jp, XNap.tr("Search Text"));
	jtSearchText = new JTextField(data.searchText);
	GridBagHelper.add(jp, jtSearchText);
	
	// media type
	GridBagHelper.addLabel(jp, XNap.tr("Media Type"));
	jcbMediaType = new JComboBox(SearchFilter.media);
	jcbMediaType.addActionListener(new MediaTypeSelectionListener());
	GridBagHelper.add(jp, jcbMediaType);

	// bitrate compare, bitrate
	GridBagHelper.addLabel(jp, XNap.tr("Bitrate"));
	jcbBitrateCompare = new JComboBox(SearchFilter.COMPARES);
	jcbBitrateCompare.setSelectedIndex(data.bitrateCompare);

	jcbBitrate = new JComboBox(SearchFilter.BITRATES);
  	int i = SearchFilterHelper.getIndexFromBitrate(data.bitrate);
  	jcbBitrate.setSelectedIndex(i);

	/* must be done here, since the listener changes jcbBitrate and
           jcbBitrateCompare which must me instantiated.  */
	jcbMediaType.setSelectedIndex(data.mediaType);

	Box hBox = Box.createHorizontalBox();
	hBox.add(jcbBitrateCompare);
	hBox.add(Box.createGlue());
	hBox.add(jcbBitrate);
	GridBagHelper.add(jp, hBox);

	pack();
    }

    public static void showDialog(Component c, AutoDownload d)
    {
	AutoDownloadEditorDialog me = new AutoDownloadEditorDialog(d);
	if (c != null) {
	    me.setLocationRelativeTo(c);
	}
	me.show();
    }

    public void apply()
    {
	ResumeFile3 file = download.getResumeFile();
	file.setFinalFilename(jtFilename.getText());

	file.getFilterData().searchText = jtSearchText.getText();
	file.getFilterData().mediaType = jcbMediaType.getSelectedIndex();
	
	if (jcbBitrateCompare.isEnabled()) {
	    file.getFilterData().bitrateCompare 
		= jcbBitrateCompare.getSelectedIndex();
	    int i = jcbBitrate.getSelectedIndex();
	    file.getFilterData().bitrate
		= SearchFilter.getBitrateFromIndex(i);
	}

	download.updatedSearchFilter();

	// write changes to repository
	ResumeRepository.getInstance().updateLater();
    }

    private class MediaTypeSelectionListener implements ActionListener
    {
	public void actionPerformed(ActionEvent e)
	{
	    int index = jcbMediaType.getSelectedIndex();
	    if (index == SearchFilter.MEDIA_ANYTHING 
		|| index == SearchFilter.MEDIA_AUDIO) {
		jcbBitrateCompare.setEnabled(true);
		jcbBitrate.setEnabled(true);
	    }
	    else {
		jcbBitrateCompare.setEnabled(false);
		jcbBitrate.setEnabled(false);
	    }
	}
    }

}
