/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import org.apache.log4j.Logger;

public class FontPanel extends JPanel
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    //private static Logger logger = Logger.getLogger(FontPanel.class);

    private Component parent;
    private Font font;
    private JLabel jlFont;

    //--- Constructor(s) ---

    public FontPanel(Component parent, Font newFont)
    {
	this.parent = parent;

	setLayout(new BorderLayout());
	
	jlFont = new JLabel();
	jlFont.setBorder(new BevelBorder(BevelBorder.LOWERED));
	add(jlFont, BorderLayout.CENTER);

	JButton jb = new JButton(new FontAction());
	jb.setMargin(new Insets(1, 1, 1, 1));
	add(jb, BorderLayout.EAST);

	setSelectedFont(newFont);
    }

    //--- Method(s) ---

    public Font getSelectedFont()
    {
	return font;
    }

    /**
     * Makes sure that font is always != null.
     */
    public void setSelectedFont(Font newValue)
    {
	font = newValue;
	jlFont.setFont(font);
	jlFont.setText(" " + font.getName() + ", " + font.getSize());
    }

    /**
     * 
     */
    private class FontAction extends AbstractAction {

        public FontAction() 
	{
            putValue(Action.SHORT_DESCRIPTION, "Opens font selection dialog.");
	    putValue(Action.SMALL_ICON, XNapFrame.getSmallIcon("charset.png"));
            putValue(Action.MNEMONIC_KEY, new Integer(KeyEvent.VK_O));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    Font f = FontChooserDialog.showDialog(parent, getSelectedFont());
	    if (f != null) {
		setSelectedFont(f);
	    }
	}

    }

}

