/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import xnap.XNap;
import xnap.*;

public class SplashWindow extends JWindow
{
    // --- Constant(s) ---

    public static final int TIMEOUT = 20000;

    // --- Data Field(s) ---

    private static SplashWindow me = null;
    private static Thread waitThread = null; 

    private static JProgressBar jpbStatus;

    // --- Constructors ---

    private SplashWindow(String filename)
    {
	super();

	//getContentPane().setBackground(Color.black);
	setBackground(Color.white);
	getContentPane().setBackground(Color.white);

	StringBuffer sb = new StringBuffer();
	sb.append(XNap.tr("Version", 0, 1));
	sb.append(XNap.VERSION);
	sb.append(XNap.tr(", see About for License"));
	JLabel jlImage = new JLabel(sb.toString());

	jlImage.setIcon(XNapFrame.getImage(filename));
  	jlImage.setHorizontalAlignment(SwingConstants.CENTER);
  	jlImage.setVerticalAlignment(SwingConstants.CENTER);
	jlImage.setHorizontalTextPosition(SwingConstants.CENTER);
	jlImage.setVerticalTextPosition(SwingConstants.BOTTOM);

	jpbStatus = new JProgressBar(0, 100);
	jpbStatus.setString(XNap.tr("Loading..."));
	jpbStatus.setStringPainted(true);

	getContentPane().add(jlImage, BorderLayout.CENTER);
	getContentPane().add(jpbStatus, BorderLayout.SOUTH);

	pack();

	// center on screen
	Dimension screenSize =
	    Toolkit.getDefaultToolkit().getScreenSize();
	Dimension labelSize = jlImage.getPreferredSize();
	setLocation(screenSize.width / 2 - (labelSize.width / 2),
		    screenSize.height / 2 - (labelSize.height / 2));

	// close on mouse click
	addMouseListener(new MouseAdapter()
	    {
		public void mousePressed(MouseEvent e)
		{
		    setVisible(false);
		    dispose();
		}
	    });
    }

    // --- Methods ---

    public static void showSplashWindow()
    {
	if (me == null)
	    {
		me = new SplashWindow("xnap_logo.png");
		me.setVisible(true);

		waitThread = new Thread("SplashWindowWaiter")
		    {
			public void run()
			{
			    try {
				Thread.sleep(TIMEOUT);
			    } catch(Exception e) {
			    }

			    me.setVisible(false);
			    me.dispose();
			    me = null;
			}
		    };
		waitThread.start();
	    } else
		me.setVisible(true);
    }

    public static void incProgress(int newValue)
    {
	if (me != null)
	    jpbStatus.setValue(jpbStatus.getValue() + newValue);
    }

    public static void setProgress(int newValue)
    {
	if (me != null)
	    jpbStatus.setValue(newValue);
    }

    public static void setText(String newValue)
    {
	if (me != null)
	    jpbStatus.setString(newValue);
    }

    public static void closeSplashWindow()
    {
	if (waitThread != null)
	    waitThread.interrupt();
    }	
}

