/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.table;

import xnap.util.Formatter;

import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;

public class TimeCellRenderer extends DefaultTableCellRenderer {

    //--- Constructor(s) ---

    public TimeCellRenderer() 
    {
	setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
    }

    //--- Method(s) ---

    protected void setValue(Object value) 
    {
	String s = "";

	if (value != null) {
	    if (value instanceof Integer) {
		int i = ((Number)value).intValue();
		if (i >= 0) {
		    s = Formatter.formatLength(i);
		}
	    }
	    else if (value instanceof Long) {
		long l = ((Long)value).longValue();
		if (l >= 0) {
		    s = Formatter.formatTime(l);
		}
	    }
	}

	super.setValue(s);
    } 
} 
