/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.tree;

import xnap.net.*;

import javax.swing.tree.*;

public class SearchPathNode extends DefaultMutableTreeNode
{

    // --- Data Field(s) ---

    protected int resultCount = 0;

    // --- Constructor(s) ---

    public SearchPathNode(String name)
    {
	super(name);
    }

    // --- Method(s) ---

    public String getName()
    {
	return getUserObject().toString();
    }

    public String[] getSearchPath()
    {
	TreeNode[] pathToRoot = getPath();

	if (pathToRoot.length > 1) {
	    String[] path = new String[pathToRoot.length - 1];
	    for (int i = 0; i < pathToRoot.length - 1; i++) {
		path[i] = ((SearchPathNode)pathToRoot[i + 1]).getName();
	    }
	    return path;
	}
	else {
	    return null;
	}
    }

    public void incResultCount()
    {
	resultCount++;
    }

    public String toString()
    {
	StringBuffer sb = new StringBuffer();
	sb.append(getUserObject().toString());
	if (resultCount > 0) {
	    sb.append(" (");
	    sb.append(resultCount);
	    sb.append(")");
	}
	return sb.toString();
    }

} 
