/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.net.event.ChannelEvent;
import xnap.net.event.ChannelListener;
import xnap.net.event.ChannelSupport;

import java.io.*;
import java.util.*;

public abstract class AbstractChannel implements IChannel {

    // --- Constant(s) ---

    //--- Data field(s) ---

    protected ChannelSupport cs = new ChannelSupport(this);
    protected List users = Collections.synchronizedList(new ArrayList());
    protected String name;
    protected IChatServer chatServer;
    protected String topic;
    protected int userCount;

    //--- Constructor(s) ---
    
    public AbstractChannel(IChatServer chatServer, String name, String topic, 
			   int userCount)
    {
	this.chatServer = chatServer;
	this.name = name;
	this.topic = topic;
	this.userCount = userCount;
    }

    //--- Method(s) ---

    public synchronized void add(IUser user)
    {
	users.add(user);
	cs.fireUserAdded(user);
    }

    public void addChannelListener(ChannelListener l)
    {
	cs.addChannelListener(l);
    }

    public void removeChannelListener(ChannelListener l)
    {
	cs.removeChannelListener(l);
    }

    public void close() 
    {
	cs.fireChannelClosed();
    }

    public String getName()
    {
	return name;
    }

    public IChatServer getServer()
    {
	return chatServer;
    }

    public String getTopic()
    {
	return topic;
    }

    public void setTopic(String newValue)
    {
	topic = newValue;
	cs.fireTopicChanged(topic);
    }

    public int getUserCount()
    {
	return userCount;
    }

    public void setUserCount(int newValue)
    {
	userCount = newValue;
    }

    public abstract void join() throws IOException;

    public void messageReceived(IUser sender, String message)
    {
	cs.fireMessageReceived(sender, message, 
			       ChannelEvent.MESSAGE_TYPE_MESSAGE);
    }

    public void errorReceived(String message)
    {
	cs.fireMessageReceived(message, ChannelEvent.MESSAGE_TYPE_ERROR);
    }

    public void infoReceived(String message)
    {
	cs.fireMessageReceived(message, ChannelEvent.MESSAGE_TYPE_INFO);
    }

    public void topicChanged(String newTopic)
    {
	cs.fireTopicChanged(newTopic);
    }
    
    public IUser[] getUsers()
    {
	IUser[] array = new IUser[users.size()];
	System.arraycopy(users.toArray(), 0, array, 0, array.length);
	return array;
    }

    public synchronized void remove(IUser user)
    {
	users.remove(user);
	cs.fireUserRemoved(user);
    }

}
