/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import java.io.IOException;

public interface IChatServer {

    //--- Data field(s) ---

    //--- Method(s) ---

    /**
     * Creates a new channel.
     */
    IChannel create(String name) throws IOException;

    /**
     * Returns the channels on this server.
     */
    IChannel[] getChannels() throws IOException;

    /**
     * Returns the name of the server shown to the user.
     */
    String getName();

    /**
     * Returns the login user.
     */
    IUser getUser();

    /**
     * Fetch a new list of channels.
     */
    void updateChannels() throws IOException;

}




