/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.util;

import xnap.util.*;

import java.util.*;

public class XMLParser 
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    //--- Constructor(s) ---

    //--- Method(s) ---

    public static Hashtable parse(String text) {
	Hashtable table = new Hashtable();

	text = text.substring(text.indexOf(" "));

	StringTokenizer t1 = new StringTokenizer(text, "\"");

	while (t1.hasMoreTokens()) {
	    String key = t1.nextToken().trim();

	    if (t1.hasMoreTokens()) {
		// remove last character
		key = key.substring(0, key.length() - 1);
		String value = t1.nextToken();

		Debug.log("Parse: " + key + "/" + value);
		table.put(key.toLowerCase(), value);
	    }
	}

	return table;
    }
}
