/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.server;

import xnap.cmdl.Console;
import xnap.plugin.nap.net.User;
import xnap.util.QuotedStringTokenizer;
import xnap.util.StringHelper;

public class WhoisResponseMessage extends ServerMessage {

    //--- Constant(s) ---

    public static final int TYPE = 604;

    //--- Data Field(s) ---

    public String nick;
    public String userLevel;
    public int connectDuration;
    public String channels;
    public String status;
    public int sharedCount;
    public int downloadCount;
    public int uploadCount;
    public int linkSpeed;
    public String clientInfo;
    public int totalDownload;
    public int totalUploads;
    public String ip;
    public int connectingPort;
    public int dataPort;
    public String email;
    public boolean extendedInfo = false;

    //--- Constructor(s) ---

    public WhoisResponseMessage(String data) throws InvalidMessageException 
    {
	super(TYPE, data, 10);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	nick = t.nextToken();
	userLevel = t.nextToken();
	connectDuration = (new Long(t.nextToken())).intValue();
	channels = t.nextToken();
	status = t.nextToken();
	sharedCount = Integer.parseInt(t.nextToken());
	downloadCount = Integer.parseInt(t.nextToken());
	uploadCount = Integer.parseInt(t.nextToken());
	linkSpeed = Integer.parseInt(t.nextToken());
	clientInfo = t.nextToken();

	if (t.countTokens() >= 6) {
	    extendedInfo = true;
	    totalDownload = Integer.parseInt(t.nextToken());
	    totalUploads = Integer.parseInt(t.nextToken());
	    ip = t.nextToken();
	    connectingPort = Integer.parseInt(t.nextToken());
	    dataPort = Integer.parseInt(t.nextToken());
	    email = t.nextToken();
	}
    }

    public void received()
    {
	User u = server.getUser(nick);
	u.setClientInfo(clientInfo);
	u.setConnectDuration(connectDuration);
	u.setDownloadCount(downloadCount);
	u.setFileCount(sharedCount);
	u.setIP(ip);
	u.setLevel(userLevel);
	u.setLinkSpeed(linkSpeed);
	u.setStatus(status);
	u.setUploadCount(uploadCount);

	u.notifyWhoisReceived();
	
	StringBuffer sb = new StringBuffer();
	sb.append("=== whois " + nick + " ===");
	sb.append(nick);
	sb.append("server: ");
	sb.append(server);
	sb.append("\nuser: ");
	sb.append(nick);
	sb.append("\nuser level: ");
	sb.append(userLevel);
	sb.append("\nconnect duration: ");
	sb.append(connectDuration);
	sb.append("\nchannels: ");
	sb.append(channels);
	sb.append("\nstatus: ");
	sb.append(status);
	sb.append("\nshared: ");
	sb.append(sharedCount);
	sb.append("\ndownloads: ");
	sb.append(downloadCount);
	sb.append("\nuploads: ");
	sb.append(uploadCount);
	sb.append("\nlink speed: ");
	sb.append(linkSpeed);
	sb.append("\nclient: ");
	sb.append(clientInfo);

	Console.getInstance().println(sb.toString());
    }

}
