/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.viewer.video;

import xnap.gui.*;
import xnap.io.VideoFile;
import xnap.util.Debug;
import xnap.util.Formatter;


import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

/**
 * VideoInfoPanel displays the length and resolution of avi and mpg files.
 */

public class VideoInfoPanel extends ViewerPanel
{

    //--- Constant(s) ---
    
    //--- Data field(s) ---

    protected JTextField jtLength;
    protected JTextField jtHeight;
    protected JTextField jtWidth;
    
    //--- Constructor(s) ---

    public VideoInfoPanel() 
    {
	JPanel jpTag = new JPanel(new GridBagLayout());
	jpTag.setBorder(new TitledBorder(" Video info "));

	GridBagHelper.addLabel(jpTag, "Length");
	jtLength = new JTextField();
	jtLength.setEditable(false);
	GridBagHelper.add(jpTag, jtLength);

	GridBagHelper.addLabel(jpTag, "Width");
	jtWidth = new JTextField();
	jtWidth.setEditable(false);
	GridBagHelper.add(jpTag, jtWidth);

	GridBagHelper.addLabel(jpTag, "Height");
	jtHeight = new JTextField();
	jtHeight.setEditable(false);
	GridBagHelper.add(jpTag, jtHeight);

	setLayout(new BorderLayout());
	add(jpTag, "Center");
    }

    //--- Method(s) ---

    /**
     * 
     */
    public void display()
    {
	jtLength.setText("");
	jtWidth.setText("");
	jtHeight.setText("");
	
	VideoFile vf = new VideoFile(getFile());

	if (vf.parse()) {
	    jtLength.setText(Formatter.formatLength(vf.getLength()));
	    jtHeight.setText(vf.getHeight() + "");
	    jtWidth.setText(vf.getWidth() + "");

	    setStatus(null);
	}
	else {
	    setStatus("Not a valid video file");
	}
    }
}
