/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.XNap;

public class LinkSpeed implements Comparable
{

    //--- Constant(s) ---

    public static final int UNKNOWN = 0;

    public static final String[] LINKSPEEDS = {
	XNap.tr("unknown"),"14.4 kbps", "28.8 kbps", "33.6 kbps", "56.7 kbps", 
	"64K ISDN", "128K ISDN", "Cable", "DSL", "T1", "T3" + XNap.tr("or greater")
    };

    //--- Data field(s) ---

    public int speed;

    //--- Constructor(s) ---

    public LinkSpeed(int speed)
    {
	this.speed = speed;
    }

    //--- Method(s) ---

    public int compareTo(Object o)
    {
	return speed - ((LinkSpeed)o).speed;
    }

    public String toString()
    {
	if (speed >= 0 && speed < LINKSPEEDS.length)
	    return LINKSPEEDS[speed];
	else
	    return "";
    }

}
