/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util.prefs;

import xnap.util.StringHelper;

public class StringValidator implements Validator
{

    //--- Constant(s) ---

    public static final StringValidator EMAIL
	= new StringValidator(StringHelper.EMAIL, 1);

    public static final StringValidator REGULAR_STRING
	= new StringValidator(StringHelper.REGULAR_STRING, 1);

    //--- Data field(s) ---

    private String validChars;
    private int minLength;

    //--- Constructor(s) ---

    public StringValidator(String validChars, int minLength)
    {
	this.validChars = validChars;
	this.minLength = minLength;
    }

    public StringValidator(String validChars)
    {
	this(validChars, 0);
    }

    public StringValidator()
    {
	this(null);
    }

    //--- Method(s) ---

    /**
     * Validates <code>String</code>.
     * @exception IllegalArgumentException if newValue is invalid.
     */
    public void validate(String value)
    {
	if (value.length() < minLength) {
	    throw(new IllegalArgumentException("Value too short."));
	}

	if (validChars != null) {
	    for (int i = 0; i < value.length(); i++) {
		if (validChars.indexOf(value.charAt(i)) == -1) {
		    throw(new IllegalArgumentException("Invalid character."));
		}
	    }
	}
    }

}
