/*
 * gnuplay.c
 * gnutime/gnuavi test program - not ready!!!
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include "gt.h"
#include "video.h"
#include "sound.h"
#include "xt.h"

#define MT_UNKNOWN	0
#define MT_QTM	1
#define MT_QTP	2
#define MT_AVI	3

#define AUDIO_DEV "/dev/dsp"

/*
 */
void
usage (char *pname)
{
	fprintf (stderr, "Usage: %s [-v] [-s 0/1] [-l 0/1] <file>\n", pname);
	exit(1);
}


/*
 * gnuplay start point
 */
int
main (int argc, char *argv[])
{
	char *file;
	video *vid;
	int c, verbose = 0;
	int loop = 0;
	int use_snd = 1;
#ifdef HasSharedMemory
	int shm = 1;
#else
	int shm = 0;
#endif

	x_init (&argc, argv);
	while ((c = getopt (argc, argv, "vs:l:a:")) != EOF) {
		switch (c) {
			case 'v':
				verbose = 1;
				break;
			case 's':
				shm = atoi(optarg);
				break;
			case 'l':
				loop = atoi(optarg);
				break;
			case 'a':
				use_snd = atoi(optarg);
				break;
			default:
				usage (argv[0]);
				break;
		}
	}
	if (argc < optind || argc == optind) {
		usage (argv[0]);
	}
	file = argv[optind];
	if (verbose)
		printf ("loading file '%s'\n", file);
	vid = vid_open (file);
	if (!vid)
		return (1);
	if (verbose) {
		printf (" type      : %d\n", vid->type);
		printf (" size      : %d\n", vid->size);
		printf (" frames    : %d\n", vid->frames);
		printf (" tpf       : %d\n", vid->tpf);
		printf (" fps       : %d\n", vid->fps);
		printf (" geom      : %dx%d\n", vid->width, vid->height);
		printf (" snd codec : %d\n", vid->snd_codec);
	}
	if (vid->snd_codec && use_snd) {
#ifdef HasOSS
		int snd;
		if (!snd_init (AUDIO_DEV)) {
			use_snd = 0;
		} else {
			if (!(snd = snd_open_play()))
				perror(AUDIO_DEV);

			switch (vid_snd_format(vid)) {
				case VS_COD_WAV_PCM:
					snd_set_fmt(AFMT_S16_LE);
					break;
				case VS_COD_WAV_ALAW:
					snd_set_fmt(AFMT_A_LAW);
					break;
				case VS_COD_WAV_MLAW:
					snd_set_fmt(AFMT_MU_LAW);
					break;
				default:
					use_snd = 0;
					break;
			}
			snd_set_channels (vid_snd_channels(vid));
			snd_set_speed (vid_snd_sample_rate(vid));
		}
#else
		use_snd = 0;
#endif
	} else
		use_snd = 0;
	x_main (vid->width, vid->height);
	x_loop (vid, shm, loop, use_snd);

	vid_close (vid);
	return (0);
}

